/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.table.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

@JsonPropertyOrder(value={"timestamps", "column_names", "column_categories", "data_types", "values", "table", "database"})
public class InsertTabletRequest {
    public static final String JSON_PROPERTY_TIMESTAMPS = "timestamps";
    @JsonProperty(value="timestamps")
    private List<Long> timestamps;
    public static final String JSON_PROPERTY_COLUMN_NAMES = "column_names";
    @JsonProperty(value="column_names")
    private List<String> columnNames;
    public static final String JSON_PROPERTY_COLUMN_CATEGORIES = "column_categories";
    @JsonProperty(value="column_categories")
    private List<String> columnCategories;
    public static final String JSON_PROPERTY_DATA_TYPES = "data_types";
    @JsonProperty(value="data_types")
    private List<String> dataTypes;
    public static final String JSON_PROPERTY_VALUES = "values";
    @JsonProperty(value="values")
    private List<List<Object>> values;
    public static final String JSON_PROPERTY_TABLE = "table";
    @JsonProperty(value="table")
    private String table;
    public static final String JSON_PROPERTY_DATABASE = "database";
    @JsonProperty(value="database")
    private String database;

    public InsertTabletRequest timestamps(List<Long> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public InsertTabletRequest addTimestampsItem(Long timestampsItem) {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList<Long>();
        }
        this.timestamps.add(timestampsItem);
        return this;
    }

    @JsonProperty(value="timestamps")
    @ApiModelProperty(value="")
    public List<Long> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(List<Long> timestamps) {
        this.timestamps = timestamps;
    }

    public InsertTabletRequest columnNames(List<String> columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    public InsertTabletRequest addColumnNamesItem(String columnNamesItem) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnNamesItem);
        return this;
    }

    @JsonProperty(value="column_names")
    @ApiModelProperty(value="")
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public InsertTabletRequest columnCategories(List<String> columnCategories) {
        this.columnCategories = columnCategories;
        return this;
    }

    public InsertTabletRequest addColumnCategoriesItem(String columnCategoriesItem) {
        if (this.columnCategories == null) {
            this.columnCategories = new ArrayList<String>();
        }
        this.columnCategories.add(columnCategoriesItem);
        return this;
    }

    @JsonProperty(value="column_categories")
    @ApiModelProperty(value="")
    public List<String> getColumnCategories() {
        return this.columnCategories;
    }

    public void setColumnCategories(List<String> columnCategories) {
        this.columnCategories = columnCategories;
    }

    public InsertTabletRequest dataTypes(List<String> dataTypes) {
        this.dataTypes = dataTypes;
        return this;
    }

    public InsertTabletRequest addDataTypesItem(String dataTypesItem) {
        if (this.dataTypes == null) {
            this.dataTypes = new ArrayList<String>();
        }
        this.dataTypes.add(dataTypesItem);
        return this;
    }

    @JsonProperty(value="data_types")
    @ApiModelProperty(value="")
    public List<String> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<String> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public InsertTabletRequest values(List<List<Object>> values) {
        this.values = values;
        return this;
    }

    public InsertTabletRequest addValuesItem(List<Object> valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<List<Object>>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @JsonProperty(value="values")
    @ApiModelProperty(value="")
    @Valid
    public List<List<Object>> getValues() {
        return this.values;
    }

    public void setValues(List<List<Object>> values) {
        this.values = values;
    }

    public InsertTabletRequest table(String table) {
        this.table = table;
        return this;
    }

    @JsonProperty(value="table")
    @ApiModelProperty(value="")
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public InsertTabletRequest database(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="database")
    @ApiModelProperty(value="")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertTabletRequest insertTabletRequest = (InsertTabletRequest)o;
        return Objects.equals(this.timestamps, insertTabletRequest.timestamps) && Objects.equals(this.columnNames, insertTabletRequest.columnNames) && Objects.equals(this.columnCategories, insertTabletRequest.columnCategories) && Objects.equals(this.dataTypes, insertTabletRequest.dataTypes) && Objects.equals(this.values, insertTabletRequest.values) && Objects.equals(this.table, insertTabletRequest.table) && Objects.equals(this.database, insertTabletRequest.database);
    }

    public int hashCode() {
        return Objects.hash(this.timestamps, this.columnNames, this.columnCategories, this.dataTypes, this.values, this.table, this.database);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertTabletRequest {\n");
        sb.append("    timestamps: ").append(this.toIndentedString(this.timestamps)).append("\n");
        sb.append("    columnNames: ").append(this.toIndentedString(this.columnNames)).append("\n");
        sb.append("    columnCategories: ").append(this.toIndentedString(this.columnCategories)).append("\n");
        sb.append("    dataTypes: ").append(this.toIndentedString(this.dataTypes)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

