/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.time.ZoneId;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MultiColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;

public class FormatColumnTransformer
extends MultiColumnTransformer {
    private final ZoneId zoneId;

    public FormatColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList, ZoneId zoneId) {
        super(returnType, columnTransformerList);
        this.zoneId = zoneId;
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(childrenColumns, builder, i);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(childrenColumns, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(List<Column> childrenColumns, ColumnBuilder builder, int i) {
        List<Column> valueColumns = childrenColumns.subList(1, childrenColumns.size());
        Object[] values = new Object[valueColumns.size()];
        String pattern = String.valueOf(childrenColumns.get(0).getBinary(i));
        for (int j = 0; j < valueColumns.size(); ++j) {
            Column column = valueColumns.get(j);
            TypeEnum type = ((ColumnTransformer)this.columnTransformerList.get(j + 1)).getType().getTypeEnum();
            values[j] = column.isNull(i) ? null : this.valueConverter(type, column, i);
        }
        try {
            String formatted = String.format(pattern, values);
            this.returnType.writeBinary(builder, new Binary(org.apache.iotdb.pipe.api.type.Binary.stringToBytes((String)formatted)));
        }
        catch (IllegalFormatConversionException | MissingFormatArgumentException e) {
            String message = e.toString().replaceFirst("^java\\.util\\.(\\w+)Exception", "$1");
            throw new SemanticException(String.format("Invalid format string: %s (%s)", pattern, message));
        }
    }

    private Object valueConverter(TypeEnum type, Column column, int i) {
        switch (type) {
            case UNKNOWN: {
                return null;
            }
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case TEXT: 
            case STRING: 
            case BLOB: {
                return column.getObject(i);
            }
            case DATE: {
                return DateUtils.parseIntToLocalDate((int)column.getInt(i));
            }
            case TIMESTAMP: {
                return DateTimeUtils.convertToZonedDateTime(column.getLong(i), this.zoneId);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", type));
    }

    @Override
    protected void checkType() {
    }
}

