/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.io.File;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner.class);

    public static void clean() {
        PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner.cleanTsFileDir();
        PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner.cleanSnapshotDir();
    }

    private static void cleanTsFileDir() {
        for (String dataDir : IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File pipeHardLinkDir = new File(dataDir + File.separator + PipeConfig.getInstance().getPipeHardlinkBaseDirName());
            if (!pipeHardLinkDir.isDirectory()) continue;
            LOGGER.info("Pipe hardlink dir found, deleting it: {}, result: {}", (Object)pipeHardLinkDir, (Object)org.apache.commons.io.FileUtils.deleteQuietly((File)pipeHardLinkDir));
        }
    }

    private static void cleanSnapshotDir() {
        File pipeConsensusDir = new File(IoTDBDescriptor.getInstance().getConfig().getConsensusDir() + File.separator + "pipe_snapshot");
        if (pipeConsensusDir.isDirectory()) {
            LOGGER.info("Pipe snapshot dir found, deleting it: {},", (Object)pipeConsensusDir);
            FileUtils.deleteFileOrDirectory((File)pipeConsensusDir);
        }
    }

    private PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner() {
    }
}

