/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class NodeReference
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=580");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=582");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=581");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15203");
    private final NodeId nodeId;
    private final NodeId referenceTypeId;
    private final Boolean isForward;
    private final NodeId[] referencedNodeIds;

    public NodeReference(NodeId nodeId, NodeId referenceTypeId, Boolean isForward, NodeId[] referencedNodeIds) {
        this.nodeId = nodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.referencedNodeIds = referencedNodeIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsForward() {
        return this.isForward;
    }

    public NodeId[] getReferencedNodeIds() {
        return this.referencedNodeIds;
    }

    protected NodeReference(NodeReferenceBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((NodeReferenceBuilder)b).nodeId;
        this.referenceTypeId = ((NodeReferenceBuilder)b).referenceTypeId;
        this.isForward = ((NodeReferenceBuilder)b).isForward;
        this.referencedNodeIds = ((NodeReferenceBuilder)b).referencedNodeIds;
    }

    public static NodeReferenceBuilder<?, ?> builder() {
        return new NodeReferenceBuilderImpl();
    }

    public NodeReferenceBuilder<?, ?> toBuilder() {
        return new NodeReferenceBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeReference)) {
            return false;
        }
        NodeReference other = (NodeReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isForward = this.getIsForward();
        Boolean other$isForward = other.getIsForward();
        if (this$isForward == null ? other$isForward != null : !((Object)this$isForward).equals(other$isForward)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        return Arrays.deepEquals(this.getReferencedNodeIds(), other.getReferencedNodeIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isForward = this.getIsForward();
        result = result * 59 + ($isForward == null ? 43 : ((Object)$isForward).hashCode());
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReferencedNodeIds());
        return result;
    }

    @Override
    public String toString() {
        return "NodeReference(nodeId=" + this.getNodeId() + ", referenceTypeId=" + this.getReferenceTypeId() + ", isForward=" + this.getIsForward() + ", referencedNodeIds=" + Arrays.deepToString(this.getReferencedNodeIds()) + ")";
    }

    private static final class NodeReferenceBuilderImpl
    extends NodeReferenceBuilder<NodeReference, NodeReferenceBuilderImpl> {
        private NodeReferenceBuilderImpl() {
        }

        @Override
        protected NodeReferenceBuilderImpl self() {
            return this;
        }

        @Override
        public NodeReference build() {
            return new NodeReference(this);
        }
    }

    public static abstract class NodeReferenceBuilder<C extends NodeReference, B extends NodeReferenceBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private NodeId referenceTypeId;
        private Boolean isForward;
        private NodeId[] referencedNodeIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NodeReferenceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(NodeReference instance, NodeReferenceBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.referenceTypeId(instance.referenceTypeId);
            b.isForward(instance.isForward);
            b.referencedNodeIds(instance.referencedNodeIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isForward(Boolean isForward) {
            this.isForward = isForward;
            return (B)this.self();
        }

        public B referencedNodeIds(NodeId[] referencedNodeIds) {
            this.referencedNodeIds = referencedNodeIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NodeReference.NodeReferenceBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", referenceTypeId=" + this.referenceTypeId + ", isForward=" + this.isForward + ", referencedNodeIds=" + Arrays.deepToString(this.referencedNodeIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<NodeReference> {
        @Override
        public Class<NodeReference> getType() {
            return NodeReference.class;
        }

        @Override
        public NodeReference decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isForward = decoder.readBoolean("IsForward");
            NodeId[] referencedNodeIds = decoder.readNodeIdArray("ReferencedNodeIds");
            return new NodeReference(nodeId, referenceTypeId, isForward, referencedNodeIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NodeReference value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsForward", value.getIsForward());
            encoder.writeNodeIdArray("ReferencedNodeIds", value.getReferencedNodeIds());
        }
    }
}

