/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactPagePlan;
import org.apache.tsfile.read.common.TimeRange;

public class CompactChunkPlan {
    private final TimeRange timeRange;
    private List<CompactPagePlan> pageRecords;
    private final boolean isCompactedByDirectlyFlush;

    public CompactChunkPlan(List<CompactPagePlan> pageRecords) {
        this.timeRange = new TimeRange(pageRecords.get(0).getTimeRange().getMin(), pageRecords.get(pageRecords.size() - 1).getTimeRange().getMax());
        this.pageRecords = pageRecords;
        this.isCompactedByDirectlyFlush = false;
    }

    public CompactChunkPlan(long startTime, long endTime) {
        this.timeRange = new TimeRange(startTime, endTime);
        this.pageRecords = Collections.emptyList();
        this.isCompactedByDirectlyFlush = true;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public List<CompactPagePlan> getPageRecords() {
        return this.pageRecords;
    }

    public boolean isCompactedByDirectlyFlush() {
        return this.isCompactedByDirectlyFlush;
    }

    public String toString() {
        return "CompactChunkPlan{timeRange=" + this.timeRange + ", pageRecords=" + this.pageRecords + ", isCompactedByDirectlyFlush=" + this.isCompactedByDirectlyFlush + '}';
    }
}

