/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.FlatHashStrategy;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.HashStrategy;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.XxHash64;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.RowType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;
import org.apache.tsfile.read.common.type.UnknownType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TypeUtil {
    public static void serialize(Type type, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)type.getTypeEnum().ordinal(), (ByteBuffer)byteBuffer);
        List typeParameters = type.getTypeParameters();
        ReadWriteIOUtils.write((int)typeParameters.size(), (ByteBuffer)byteBuffer);
        for (Type typeParameter : typeParameters) {
            ReadWriteIOUtils.write((int)typeParameter.getTypeEnum().ordinal(), (ByteBuffer)byteBuffer);
        }
    }

    public static void serialize(Type type, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)type.getTypeEnum().ordinal(), (OutputStream)stream);
        List typeParameters = type.getTypeParameters();
        ReadWriteIOUtils.write((int)typeParameters.size(), (OutputStream)stream);
        for (Type typeParameter : typeParameters) {
            ReadWriteIOUtils.write((int)typeParameter.getTypeEnum().ordinal(), (OutputStream)stream);
        }
    }

    public static Type deserialize(ByteBuffer byteBuffer) {
        TypeEnum typeEnum = TypeEnum.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Type> typeParameters = new ArrayList<Type>(size);
        while (size-- > 0) {
            typeParameters.add(TypeUtil.getType(TypeEnum.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)], Collections.emptyList()));
        }
        return TypeUtil.getType(typeEnum, typeParameters);
    }

    public static Type getType(TypeEnum typeEnum, List<Type> subTypes) {
        switch (typeEnum) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case INT32: {
                return IntType.INT32;
            }
            case INT64: {
                return LongType.INT64;
            }
            case FLOAT: {
                return FloatType.FLOAT;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case TEXT: {
                return BinaryType.TEXT;
            }
            case STRING: {
                return StringType.STRING;
            }
            case BLOB: {
                return BlobType.BLOB;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case DATE: {
                return DateType.DATE;
            }
            case ROW: {
                return RowType.anonymous(subTypes);
            }
        }
        return UnknownType.UNKNOWN;
    }

    public static boolean isFlatVariableWidth(Type type) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DATE: {
                return false;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int getFlatFixedSize(Type type) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case DATE: {
                return 4;
            }
            case INT64: 
            case TIMESTAMP: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return 16;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int getFlatVariableWidthSize(Type type, Column column, int position) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DATE: {
                return 0;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return column.isNull(position) ? 0 : column.getBinary(position).getLength();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int getFlatVariableWidthSize(Type type, Column column, int[] position) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DATE: {
                return 0;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                int result = 0;
                for (int i = 0; i < position.length; ++i) {
                    if (column.isNull(i)) continue;
                    result += column.getBinary(position[i]).getLength();
                }
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static void readFlat(Type type, byte[] fixedChunk, int fixedOffset, byte[] variableChunk, ColumnBuilder columnBuilder) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                columnBuilder.writeBoolean(fixedChunk[fixedOffset] != 0);
                break;
            }
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(BytesUtils.bytesToLongFromOffset((byte[])fixedChunk, (int)8, (int)fixedOffset));
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(BytesUtils.bytesToFloat((byte[])fixedChunk, (int)fixedOffset));
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(BytesUtils.bytesToDouble((byte[])fixedChunk, (int)fixedOffset));
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                int length = BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset);
                byte[] result = new byte[length];
                if (length <= 12) {
                    System.arraycopy(fixedChunk, fixedOffset + 4, result, 0, length);
                    columnBuilder.writeBinary(new Binary(result));
                    break;
                }
                int variableSizeOffset = BytesUtils.bytesToInt((byte[])fixedChunk, (int)(fixedOffset + 4 + 8));
                System.arraycopy(variableChunk, variableSizeOffset, result, 0, length);
                columnBuilder.writeBinary(new Binary(result));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static void writeFlat(Type type, Column column, int position, byte[] fixedChunk, int fixedOffset, byte[] variableChunk, int variableOffset) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                fixedChunk[fixedOffset] = (byte)(column.getBoolean(position) ? 1 : 0);
                break;
            }
            case INT32: 
            case DATE: {
                BytesUtils.intToBytes((int)column.getInt(position), (byte[])fixedChunk, (int)fixedOffset);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                BytesUtils.longToBytes((long)column.getLong(position), (byte[])fixedChunk, (int)fixedOffset);
                break;
            }
            case FLOAT: {
                BytesUtils.floatToBytes((float)column.getFloat(position), (byte[])fixedChunk, (int)fixedOffset);
                break;
            }
            case DOUBLE: {
                BytesUtils.doubleToBytes((double)column.getDouble(position), (byte[])fixedChunk, (int)fixedOffset);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                byte[] value = column.getBinary(position).getValues();
                BytesUtils.intToBytes((int)value.length, (byte[])fixedChunk, (int)fixedOffset);
                if (value.length <= 12) {
                    System.arraycopy(value, 0, fixedChunk, fixedOffset + 4, value.length);
                    break;
                }
                BytesUtils.intToBytes((int)variableOffset, (byte[])fixedChunk, (int)(fixedOffset + 4 + 8));
                System.arraycopy(value, 0, variableChunk, variableOffset, value.length);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static boolean notDistinctFrom(Type type, byte[] fixedChunk, int fixedOffset, byte[] variableChunk, Column column, int position) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                return fixedChunk[fixedOffset] != 0 == column.getBoolean(position);
            }
            case INT32: 
            case DATE: {
                return BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset) == column.getInt(position);
            }
            case INT64: 
            case TIMESTAMP: {
                return BytesUtils.bytesToLongFromOffset((byte[])fixedChunk, (int)8, (int)fixedOffset) == column.getLong(position);
            }
            case FLOAT: {
                return BytesUtils.bytesToFloat((byte[])fixedChunk, (int)fixedOffset) == column.getFloat(position);
            }
            case DOUBLE: {
                return BytesUtils.bytesToDouble((byte[])fixedChunk, (int)fixedOffset) == column.getDouble(position);
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                int leftLength = BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset);
                byte[] leftValue = new byte[leftLength];
                byte[] rightValue = column.getBinary(position).getValues();
                if (leftLength != rightValue.length) {
                    return false;
                }
                if (leftLength <= 12) {
                    System.arraycopy(fixedChunk, fixedOffset + 4, leftValue, 0, leftLength);
                } else {
                    int variableSizeOffset = BytesUtils.bytesToInt((byte[])fixedChunk, (int)(fixedOffset + 4 + 8));
                    System.arraycopy(variableChunk, variableSizeOffset, leftValue, 0, leftLength);
                }
                return Arrays.equals(leftValue, rightValue);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static long hash(Type type, byte[] fixedChunk, int fixedOffset, byte[] variableChunk) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                return fixedChunk[fixedOffset] != 0 ? XxHash64.TRUE_XX_HASH : XxHash64.FALSE_XX_HASH;
            }
            case INT32: 
            case DATE: {
                return XxHash64.hash(BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset));
            }
            case INT64: 
            case TIMESTAMP: {
                return XxHash64.hash(BytesUtils.bytesToLongFromOffset((byte[])fixedChunk, (int)8, (int)fixedOffset));
            }
            case FLOAT: {
                float value = BytesUtils.bytesToFloat((byte[])fixedChunk, (int)fixedOffset);
                if (value == 0.0f) {
                    return 0L;
                }
                return XxHash64.hash(Float.floatToIntBits(value));
            }
            case DOUBLE: {
                double value1 = BytesUtils.bytesToDouble((byte[])fixedChunk, (int)fixedOffset);
                if (value1 == 0.0) {
                    return 0L;
                }
                return XxHash64.hash(Double.doubleToLongBits(value1));
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                int length = BytesUtils.bytesToInt((byte[])fixedChunk, (int)fixedOffset);
                byte[] values = new byte[length];
                if (length <= 12) {
                    System.arraycopy(fixedChunk, fixedOffset + 4, values, 0, length);
                } else {
                    int variableSizeOffset = BytesUtils.bytesToInt((byte[])fixedChunk, (int)(fixedOffset + 4 + 8));
                    System.arraycopy(variableChunk, variableSizeOffset, values, 0, length);
                }
                return XxHash64.hash(values);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static long hash(Type type, Column column, int position) {
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                return column.getBoolean(position) ? XxHash64.TRUE_XX_HASH : XxHash64.FALSE_XX_HASH;
            }
            case INT32: 
            case DATE: {
                return XxHash64.hash(column.getInt(position));
            }
            case INT64: 
            case TIMESTAMP: {
                return XxHash64.hash(column.getLong(position));
            }
            case FLOAT: {
                float value = column.getFloat(position);
                if (value == 0.0f) {
                    return 0L;
                }
                return XxHash64.hash(Float.floatToIntBits(column.getFloat(position)));
            }
            case DOUBLE: {
                double value1 = column.getDouble(position);
                if (value1 == 0.0) {
                    return 0L;
                }
                return XxHash64.hash(Double.doubleToLongBits(column.getDouble(position)));
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return XxHash64.hash(column.getBinary(position).getValues());
            }
        }
        throw new UnsupportedOperationException();
    }

    public static FlatHashStrategy getFlatHashStrategy(List<Type> hashTypes) {
        return new HashStrategy(hashTypes);
    }
}

