/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingElement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class GroupBy
extends Node {
    private final boolean isDistinct;
    private final List<GroupingElement> groupingElements;

    public GroupBy(boolean isDistinct, List<GroupingElement> groupingElements) {
        super(null);
        this.isDistinct = isDistinct;
        this.groupingElements = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingElements));
    }

    public GroupBy(NodeLocation location, boolean isDistinct, List<GroupingElement> groupingElements) {
        super(Objects.requireNonNull(location, "location is null"));
        this.isDistinct = isDistinct;
        this.groupingElements = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingElements));
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public List<GroupingElement> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingElements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)o;
        return this.isDistinct == groupBy.isDistinct && Objects.equals(this.groupingElements, groupBy.groupingElements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isDistinct, this.groupingElements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isDistinct", this.isDistinct).add("groupingElements", this.groupingElements).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!GroupBy.sameClass(this, other)) {
            return false;
        }
        return this.isDistinct == ((GroupBy)other).isDistinct;
    }
}

