/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatePreSetTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatePreSetTable.class);
    private static final String SNAPSHOT_FILENAME = "template_preset_info.bin";
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<Integer, Set<PartialPath>> templatePreSetMap = new ConcurrentHashMap<Integer, Set<PartialPath>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPreSet(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.readLock().lock();
        try {
            Set<PartialPath> templatePreSetPaths = this.templatePreSetMap.get(templateId);
            if (templatePreSetPaths == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = templatePreSetPaths.contains(templateSetPath);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void preSetTemplate(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.writeLock().lock();
        try {
            this.templatePreSetMap.computeIfAbsent(templateId, k -> Collections.synchronizedSet(new HashSet())).add(templateSetPath);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSetTemplate(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.writeLock().lock();
        try {
            Set<PartialPath> set = this.templatePreSetMap.get(templateId);
            if (set == null) {
                boolean bl = false;
                return bl;
            }
            if (set.remove(templateSetPath)) {
                if (set.isEmpty()) {
                    this.templatePreSetMap.remove(templateId);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl;
            if (this.templatePreSetMap.isEmpty()) {
                boolean bl2 = true;
                return bl2;
            }
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take snapshot of TemplatePreSetTable, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl3 = false;
                return bl3;
            }
            File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
                BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
                try {
                    this.serialize(outputStream);
                }
                finally {
                    outputStream.flush();
                    fileOutputStream.getFD().sync();
                    outputStream.close();
                }
                bl = tmpFile.renameTo(snapshotFile);
            }
            catch (Throwable throwable) {
                for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                    LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
                }
                throw throwable;
            }
            for (int retry = 0; retry < 5 && tmpFile.exists(); ++retry) {
                if (tmpFile.delete()) {
                    break;
                }
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
            if (!snapshotFile.exists()) {
                return;
            }
            if (!snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot of TemplatePreSetTable,snapshot file [{}] is not a valid file.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                this.templatePreSetMap.clear();
                this.deserialize(bufferedInputStream);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.templatePreSetMap.size(), (OutputStream)outputStream);
        for (Map.Entry<Integer, Set<PartialPath>> entry : this.templatePreSetMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
            for (PartialPath preSetPath : entry.getValue()) {
                ReadWriteIOUtils.write((String)preSetPath.getFullPath(), (OutputStream)outputStream);
            }
        }
    }

    private void deserialize(InputStream inputStream) throws IOException {
        int templateNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        while (templateNum > 0) {
            --templateNum;
            int templateId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            int preSetPathNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            Set<PartialPath> set = Collections.synchronizedSet(new HashSet());
            while (preSetPathNum > 0) {
                --preSetPathNum;
                try {
                    set.add(new PartialPath(ReadWriteIOUtils.readString((InputStream)inputStream)));
                }
                catch (IllegalPathException illegalPathException) {}
            }
            this.templatePreSetMap.put(templateId, set);
        }
    }
}

