/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.scheduler;

import io.moquette.broker.scheduler.Expirable;
import io.moquette.broker.scheduler.ExpirableTracker;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledExpirationService<T extends Expirable> {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledExpirationService.class);
    static final Duration FIRER_TASK_INTERVAL = Duration.ofSeconds(1L);
    private final DelayQueue<ExpirableTracker<T>> expiringEntities = new DelayQueue();
    private final ScheduledFuture<?> expiredEntityTask;
    private final Clock clock;
    private final Consumer<T> action;
    private final ScheduledExecutorService actionsExecutor;
    private final Map<String, ExpirableTracker<T>> expiringEntitiesCache = new HashMap<String, ExpirableTracker<T>>();

    public ScheduledExpirationService(Clock clock, Consumer<T> action) {
        this.clock = clock;
        this.action = action;
        this.actionsExecutor = Executors.newSingleThreadScheduledExecutor();
        this.expiredEntityTask = this.actionsExecutor.scheduleWithFixedDelay(this::checkExpiredEntities, FIRER_TASK_INTERVAL.getSeconds(), FIRER_TASK_INTERVAL.getSeconds(), TimeUnit.SECONDS);
    }

    private void checkExpiredEntities() {
        ArrayList expiredEntities = new ArrayList();
        int drainedEntities = this.expiringEntities.drainTo(expiredEntities);
        LOG.debug("Retrieved {} expired entity on {}", (Object)drainedEntities, (Object)this.expiringEntities.size());
        expiredEntities.stream().map(ExpirableTracker::expirable).forEach(this.action);
    }

    public void track(String entityId, T entity) {
        if (!entity.expireAt().isPresent()) {
            throw new RuntimeException("Can't track for expiration an entity without expiry instant, client_id: " + entityId);
        }
        ExpirableTracker<T> entityTracker = new ExpirableTracker<T>(entity, this.clock);
        this.expiringEntities.add(entityTracker);
        this.expiringEntitiesCache.put(entityId, entityTracker);
    }

    public boolean untrack(String entityId) {
        ExpirableTracker<T> entityTracker = this.expiringEntitiesCache.get(entityId);
        if (entityTracker == null) {
            return false;
        }
        return this.expiringEntities.remove(entityTracker);
    }

    public void shutdown() {
        if (this.expiredEntityTask.cancel(false)) {
            LOG.info("Successfully cancelled expired entities task");
        } else {
            LOG.warn("Can't cancel the execution of expired entities task, was already cancelled? {}, was done? {}", (Object)this.expiredEntityTask.isCancelled(), (Object)this.expiredEntityTask.isDone());
        }
        this.actionsExecutor.shutdownNow();
    }
}

