/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.evictor;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Evictor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evictor.class);
    private ScheduledFuture<?> scheduledFuture;
    private final String name;
    private final Duration evictorShutdownTimeoutDuration;
    private ScheduledExecutorService executor;

    public Evictor(String name, Duration evictorShutdownTimeoutDuration) {
        this.name = name;
        this.evictorShutdownTimeoutDuration = evictorShutdownTimeoutDuration;
    }

    void cancel() {
        this.scheduledFuture.cancel(false);
    }

    @Override
    public abstract void run();

    void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public String toString() {
        return this.getClass().getName() + " [scheduledFuture=" + this.scheduledFuture + "]";
    }

    public void startEvictor(Duration delay) {
        if (null == this.executor) {
            this.executor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(this.name);
        }
        ScheduledFuture<?> scheduledFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate(this.executor, this, delay.toMillis(), delay.toMillis(), TimeUnit.MILLISECONDS);
        this.setScheduledFuture(scheduledFuture);
    }

    public void stopEvictor() {
        if (this.executor == null) {
            return;
        }
        LOGGER.info("Stopping {}", (Object)this.name);
        this.cancel();
        this.executor.shutdown();
        try {
            boolean result = this.executor.awaitTermination(this.evictorShutdownTimeoutDuration.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                LOGGER.info("unable to stop evictor after {} ms", (Object)this.evictorShutdownTimeoutDuration.toMillis());
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.executor = null;
    }
}

