/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto.impl;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEHeader;
import java.util.Collections;
import java.util.Set;

public class CriticalHeaderParamsDeferral {
    private Set<String> deferredParams = Collections.emptySet();

    public Set<String> getProcessedCriticalHeaderParams() {
        return Collections.emptySet();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return Collections.unmodifiableSet(this.deferredParams);
    }

    public void setDeferredCriticalHeaderParams(Set<String> defCritHeaders) {
        this.deferredParams = defCritHeaders == null ? Collections.emptySet() : defCritHeaders;
    }

    public boolean headerPasses(Header header) {
        Set<String> crit = header.getCriticalParams();
        if (crit == null || crit.isEmpty()) {
            return true;
        }
        return this.deferredParams != null && this.deferredParams.containsAll(crit);
    }

    public void ensureHeaderPasses(JWEHeader header) throws JOSEException {
        if (!this.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter(s)");
        }
    }
}

