/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSplitTool {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSplitTool.class);
    private final String filename;
    private static final String SIZE_PARAM = "-size";
    private static final String LEVEL_PARAM = "-level";
    private final long chunkPointNumLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
    private static long targetSplitFileSize = IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize();
    private static String levelNum = "10";
    private static final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    protected long maxPlanIndex = Long.MIN_VALUE;
    protected long minPlanIndex = Long.MAX_VALUE;

    public static void main(String[] args) throws IOException {
        TsFileSplitTool.checkArgs(args);
        String fileName = args[0];
        logger.info("Splitting TsFile {} ...", (Object)fileName);
        new TsFileSplitTool(fileName).run();
    }

    public TsFileSplitTool(String filename) {
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (fsFactory.getFile(this.filename + ".mods").exists()) {
            throw new IOException("Unsupported to split TsFile with modification currently.");
        }
        try (TsFileIOWriter writer = null;
             TsFileSequenceReader reader = new TsFileSequenceReader(this.filename);){
            Iterator pathIterator = reader.getPathsIterator();
            HashSet<String> devices = new HashSet<String>();
            String[] filePathSplit = this.filename.split("-");
            int originVersionIndex = Integer.parseInt(filePathSplit[filePathSplit.length - 3]);
            int versionIndex = originVersionIndex + 1;
            filePathSplit[filePathSplit.length - 2] = levelNum;
            while (pathIterator.hasNext()) {
                for (Path path : (List)pathIterator.next()) {
                    String deviceId = path.getDevice();
                    if (devices.add(deviceId)) {
                        if (writer != null && writer.getPos() < targetSplitFileSize) {
                            writer.endChunkGroup();
                            writer.startChunkGroup(deviceId);
                        } else {
                            if (writer != null) {
                                TsFileResource resource = this.endFileAndGenerateResource(writer);
                                resource.close();
                            }
                            filePathSplit[filePathSplit.length - 3] = String.valueOf(versionIndex);
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < filePathSplit.length; ++i) {
                                sb.append(filePathSplit[i]);
                                if (i == filePathSplit.length - 1) continue;
                                sb.append("-");
                            }
                            writer = new TsFileIOWriter(fsFactory.getFile(sb.toString()));
                            ++versionIndex;
                            writer.startChunkGroup(deviceId);
                        }
                    }
                    List chunkMetadataList = reader.getChunkMetadataList(path);
                    assert (writer != null);
                    ChunkMetadata firstChunkMetadata = (ChunkMetadata)chunkMetadataList.get(0);
                    reader.position(firstChunkMetadata.getOffsetOfChunkHeader());
                    ChunkHeader chunkHeader = reader.readChunkHeader(reader.readMarker());
                    if (chunkHeader.getChunkType() == -127 || chunkHeader.getChunkType() == 65 || chunkHeader.getChunkType() == -123 || chunkHeader.getChunkType() == 69) {
                        throw new IOException("Unsupported to split TsFile with aligned timeseries currently.");
                    }
                    MeasurementSchema measurementSchema = new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                    int numInChunk = 0;
                    ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)measurementSchema);
                    for (int i = 0; i < chunkMetadataList.size(); ++i) {
                        PageHeader pageHeader;
                        if (i != 0) {
                            reader.position(((ChunkMetadata)chunkMetadataList.get(i)).getOffsetOfChunkHeader());
                            chunkHeader = reader.readChunkHeader(reader.readMarker());
                        }
                        TSDataType dataType = chunkHeader.getDataType();
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)dataType);
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                            valueDecoder.reset();
                            pageHeader = reader.readPageHeader(dataType, (byte)(chunkHeader.getChunkType() & 0x3F) == 1);
                            ByteBuffer pageData = reader.readPage(pageHeader, chunkHeader.getCompressionType());
                            PageReader pageReader = new PageReader(pageData, dataType, valueDecoder, defaultTimeDecoder, null);
                            BatchData batchData = pageReader.getAllSatisfiedPageData();
                            while (batchData.hasCurrent()) {
                                this.writeToChunkWriter(chunkWriter, batchData.currentTime(), batchData.currentValue(), chunkHeader.getDataType());
                                if ((long)(++numInChunk) == this.chunkPointNumLowerBoundInCompaction) {
                                    chunkWriter.writeToFileWriter(writer);
                                    numInChunk = 0;
                                }
                                batchData.next();
                            }
                        }
                    }
                    if (numInChunk == 0) continue;
                    chunkWriter.writeToFileWriter(writer);
                }
            }
            if (writer != null) {
                TsFileResource resource = this.endFileAndGenerateResource(writer);
                resource.close();
            }
        }
    }

    private void writeToChunkWriter(ChunkWriterImpl chunkWriter, long time, Object value, TSDataType dataType) {
        switch (dataType) {
            case INT32: {
                chunkWriter.write(time, ((Integer)value).intValue());
                break;
            }
            case INT64: {
                chunkWriter.write(time, ((Long)value).longValue());
                break;
            }
            case FLOAT: {
                chunkWriter.write(time, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                chunkWriter.write(time, ((Double)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                chunkWriter.write(time, ((Boolean)value).booleanValue());
                break;
            }
            case TEXT: {
                chunkWriter.write(time, (Binary)value);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
    }

    private TsFileResource endFileAndGenerateResource(TsFileIOWriter writer) throws IOException {
        writer.endChunkGroup();
        writer.endFile();
        TsFileResource tsFileResource = new TsFileResource(writer.getFile());
        Map deviceTimeseriesMetadataMap = writer.getDeviceTimeseriesMetadataMap();
        for (Map.Entry entry : deviceTimeseriesMetadataMap.entrySet()) {
            String device = (String)entry.getKey();
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime(device, timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(device, timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.setMinPlanIndex(this.minPlanIndex);
        tsFileResource.setMaxPlanIndex(this.maxPlanIndex);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource.serialize();
        return tsFileResource;
    }

    private static void checkArgs(String[] args) {
        if (args.length == 3) {
            if (args[1].equals(SIZE_PARAM)) {
                targetSplitFileSize = Long.parseLong(args[2]);
                return;
            }
            if (args[1].equals(LEVEL_PARAM)) {
                levelNum = args[2];
                return;
            }
        } else if (args.length == 5) {
            if (args[1].equals(SIZE_PARAM) && args[3].equals(LEVEL_PARAM)) {
                targetSplitFileSize = Long.parseLong(args[2]);
                levelNum = args[4];
                return;
            }
            if (args[1].equals(LEVEL_PARAM) && args[3].equals(SIZE_PARAM)) {
                levelNum = args[2];
                targetSplitFileSize = Long.parseLong(args[4]);
                return;
            }
        }
        throw new UnsupportedOperationException("Invalid param");
    }
}

