/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeSevice
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeSevice.class);
    private ExecutorService upgradeThreadPool;
    private static final AtomicInteger cntUpgradeFileNum = new AtomicInteger();

    private UpgradeSevice() {
    }

    public static UpgradeSevice getINSTANCE() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void start() {
        int updateThreadNum = IoTDBDescriptor.getInstance().getConfig().getUpgradeThreadNum();
        if (updateThreadNum <= 0) {
            updateThreadNum = 1;
        }
        this.upgradeThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool(updateThreadNum, "UpgradeThread");
        UpgradeLog.createUpgradeLog();
        UpgradeSevice.countUpgradeFiles();
        if (cntUpgradeFileNum.get() == 0) {
            this.stop();
            return;
        }
        UpgradeSevice.upgradeAll();
    }

    @Override
    public void stop() {
        UpgradeLog.closeLogWriter();
        UpgradeUtils.clearUpgradeRecoverMap();
        if (this.upgradeThreadPool != null) {
            this.upgradeThreadPool.shutdownNow();
            logger.info("Waiting for upgrade task pool to shut down");
            this.upgradeThreadPool = null;
            logger.info("Upgrade service stopped");
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UPGRADE_SERVICE;
    }

    public static AtomicInteger getTotalUpgradeFileNum() {
        return cntUpgradeFileNum;
    }

    public void submitUpgradeTask(UpgradeTask upgradeTask) {
        this.upgradeThreadPool.submit(upgradeTask);
    }

    private static void countUpgradeFiles() {
        cntUpgradeFileNum.addAndGet(StorageEngine.getInstance().countUpgradeFiles());
        logger.info("finish counting upgrading files, total num:{}", (Object)cntUpgradeFileNum);
    }

    private static void upgradeAll() {
        try {
            StorageEngine.getInstance().upgradeAll();
        }
        catch (StorageEngineException e) {
            logger.error("Cannot perform a global upgrade because", (Throwable)e);
        }
    }

    public static class InstanceHolder {
        private static final UpgradeSevice INSTANCE = new UpgradeSevice();

        private InstanceHolder() {
        }
    }
}

