/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.executor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogger;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.SystemStatus;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.archiving.ArchivingOperate;
import org.apache.iotdb.db.engine.archiving.ArchivingTask;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.cq.ContinuousQueryService;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.ContinuousQueryException;
import org.apache.iotdb.db.exception.QueryIdNotExsitException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.db.exception.TriggerManagementException;
import org.apache.iotdb.db.exception.UDFRegistrationException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePartitionPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryIndexPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDAFPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.ExportSchemaPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.KillQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.PauseArchivingPlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetArchivingPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SettlePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowArchivingPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildNodesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowFunctionsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowLockInfoPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowNodesInTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPathsSetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPathsUsingTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowContinuousQueriesResult;
import org.apache.iotdb.db.query.dataset.ShowDevicesDataSet;
import org.apache.iotdb.db.query.dataset.ShowTimeseriesDataSet;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationInformation;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.db.utils.AuthUtils;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.EmptyDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutor
implements IPlanExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutor.class);
    private static boolean enableAuditLog = IoTDBDescriptor.getInstance().getConfig().isEnableAuditLog();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    protected IQueryRouter queryRouter = new QueryRouter();
    private final IAuthorizer authorizer;
    private ThreadPoolExecutor insertionPool;
    private static final String INSERT_MEASUREMENTS_FAILED_MESSAGE = "failed to insert measurements ";

    public PlanExecutor() throws QueryProcessException {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException, MetadataException, InterruptedException {
        if (queryPlan instanceof QueryPlan) {
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            return this.processAuthorQuery((AuthorPlan)queryPlan);
        }
        if (queryPlan instanceof ShowPlan) {
            return this.processShowQuery((ShowPlan)queryPlan, context);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    @Override
    public boolean processNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        switch (plan.getOperatorType()) {
            case DELETE: {
                this.delete((DeletePlan)plan);
                return true;
            }
            case INSERT: {
                this.insert((InsertRowPlan)plan);
                return true;
            }
            case BATCH_INSERT_ONE_DEVICE: {
                this.insert((InsertRowsOfOneDevicePlan)plan);
                return true;
            }
            case BATCH_INSERT_ROWS: {
                this.insert((InsertRowsPlan)plan);
                return true;
            }
            case BATCH_INSERT: {
                this.insertTablet((InsertTabletPlan)plan);
                return true;
            }
            case MULTI_BATCH_INSERT: {
                this.insertTablet((InsertMultiTabletPlan)plan);
                return true;
            }
            case CREATE_ROLE: 
            case DELETE_ROLE: 
            case CREATE_USER: 
            case REVOKE_USER_ROLE: 
            case REVOKE_ROLE_PRIVILEGE: 
            case REVOKE_USER_PRIVILEGE: 
            case GRANT_ROLE_PRIVILEGE: 
            case GRANT_USER_PRIVILEGE: 
            case GRANT_USER_ROLE: 
            case MODIFY_PASSWORD: 
            case DELETE_USER: {
                AuthorPlan author = (AuthorPlan)plan;
                return this.operateAuthor(author);
            }
            case GRANT_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), true);
            }
            case REVOKE_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), false);
            }
            case DELETE_TIMESERIES: {
                return this.deleteTimeSeries((DeleteTimeSeriesPlan)plan);
            }
            case CREATE_TIMESERIES: {
                return this.createTimeSeries((CreateTimeSeriesPlan)plan);
            }
            case CREATE_ALIGNED_TIMESERIES: {
                return this.createAlignedTimeSeries((CreateAlignedTimeSeriesPlan)plan);
            }
            case CREATE_MULTI_TIMESERIES: {
                return this.createMultiTimeSeries((CreateMultiTimeSeriesPlan)plan);
            }
            case ALTER_TIMESERIES: {
                return this.alterTimeSeries((AlterTimeSeriesPlan)plan);
            }
            case SET_STORAGE_GROUP: {
                return this.setStorageGroup((SetStorageGroupPlan)plan);
            }
            case DELETE_STORAGE_GROUP: {
                return this.deleteStorageGroups((DeleteStorageGroupPlan)plan);
            }
            case TTL: {
                this.operateTTL((SetTTLPlan)plan);
                return true;
            }
            case LOAD_CONFIGURATION: {
                this.loadConfiguration((LoadConfigurationPlan)plan);
                return true;
            }
            case LOAD_FILES: {
                this.operateLoadFiles((OperateFilePlan)plan);
                return true;
            }
            case REMOVE_FILE: {
                this.operateRemoveFile((OperateFilePlan)plan);
                return true;
            }
            case UNLOAD_FILE: {
                this.operateUnloadFile((OperateFilePlan)plan);
                return true;
            }
            case FLUSH: {
                this.operateFlush((FlushPlan)plan);
                return true;
            }
            case MERGE: 
            case FULL_MERGE: {
                this.operateMerge();
                return true;
            }
            case SET_SYSTEM_MODE: {
                this.operateSetSystemMode((SetSystemModePlan)plan);
                return true;
            }
            case CLEAR_CACHE: {
                PlanExecutor.operateClearCache();
                return true;
            }
            case DELETE_PARTITION: {
                DeletePartitionPlan p = (DeletePartitionPlan)plan;
                VirtualStorageGroupProcessor.TimePartitionFilter filter = (storageGroupName, partitionId) -> storageGroupName.equals(((DeletePartitionPlan)plan).getStorageGroupName().getFullPath()) && p.getPartitionId().contains(partitionId);
                StorageEngine.getInstance().removePartitions(((DeletePartitionPlan)plan).getStorageGroupName(), filter);
                return true;
            }
            case CREATE_SCHEMA_SNAPSHOT: {
                this.operateCreateSnapshot();
                return true;
            }
            case CREATE_FUNCTION: {
                return this.operateCreateFunction((CreateFunctionPlan)plan);
            }
            case DROP_FUNCTION: {
                return this.operateDropFunction((DropFunctionPlan)plan);
            }
            case CREATE_TRIGGER: {
                return this.operateCreateTrigger((CreateTriggerPlan)plan);
            }
            case DROP_TRIGGER: {
                return this.operateDropTrigger((DropTriggerPlan)plan);
            }
            case START_TRIGGER: {
                return this.operateStartTrigger((StartTriggerPlan)plan);
            }
            case STOP_TRIGGER: {
                return this.operateStopTrigger((StopTriggerPlan)plan);
            }
            case KILL: {
                try {
                    this.operateKillQuery((KillQueryPlan)plan);
                }
                catch (QueryIdNotExsitException e) {
                    throw new QueryProcessException(e.getMessage());
                }
                return true;
            }
            case CREATE_TEMPLATE: {
                return this.createTemplate((CreateTemplatePlan)plan);
            }
            case DROP_TEMPLATE: {
                return this.dropTemplate((DropTemplatePlan)plan);
            }
            case APPEND_TEMPLATE: {
                return this.appendTemplate((AppendTemplatePlan)plan);
            }
            case PRUNE_TEMPLATE: {
                return this.pruneTemplate((PruneTemplatePlan)plan);
            }
            case SET_TEMPLATE: {
                return this.setTemplate((SetTemplatePlan)plan);
            }
            case ACTIVATE_TEMPLATE: {
                return this.activateTemplate((ActivateTemplatePlan)plan);
            }
            case DEACTIVATE_TEMPLATE: {
                return this.deactivateTemplate((DeactivateTemplatePlan)plan);
            }
            case UNSET_TEMPLATE: {
                return this.unsetTemplate((UnsetTemplatePlan)plan);
            }
            case CREATE_CONTINUOUS_QUERY: {
                return this.operateCreateContinuousQuery((CreateContinuousQueryPlan)plan);
            }
            case DROP_CONTINUOUS_QUERY: {
                return this.operateDropContinuousQuery((DropContinuousQueryPlan)plan);
            }
            case SETTLE: {
                this.settle((SettlePlan)plan);
                return true;
            }
            case SHOW_QUERY_RESOURCE: {
                return this.processShowQueryResource();
            }
            case SET_ARCHIVING: {
                this.operateSetArchiving((SetArchivingPlan)plan);
                return true;
            }
            case PAUSE_ARCHIVING: {
                this.operatePauseArchiving((PauseArchivingPlan)plan);
                return true;
            }
            case EXPORT_SCHEMA: {
                return this.exportSchema((ExportSchemaPlan)plan);
            }
        }
        throw new UnsupportedOperationException(String.format("operation %s is not supported", plan.getOperatorName()));
    }

    private boolean exportSchema(ExportSchemaPlan plan) throws QueryProcessException {
        try {
            IoTDB.metaManager.exportSchema(plan.getTargetDir());
        }
        catch (IOException | MetadataException e) {
            throw new QueryProcessException(e.getMessage(), e);
        }
        return true;
    }

    private boolean createTemplate(CreateTemplatePlan createTemplatePlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.createSchemaTemplate(createTemplatePlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create template %s", createTemplatePlan.getName()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean dropTemplate(DropTemplatePlan dropTemplatePlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.dropSchemaTemplate(dropTemplatePlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("drop template %s", dropTemplatePlan.getName()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean appendTemplate(AppendTemplatePlan plan) throws QueryProcessException {
        try {
            IoTDB.metaManager.appendSchemaTemplate(plan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("append template %s", plan.getName()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean pruneTemplate(PruneTemplatePlan plan) throws QueryProcessException {
        try {
            IoTDB.metaManager.pruneSchemaTemplate(plan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("prune template %s", plan.getName()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean setTemplate(SetTemplatePlan setTemplatePlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.setSchemaTemplate(setTemplatePlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("set template %s", setTemplatePlan.getTemplateName()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean activateTemplate(ActivateTemplatePlan activateTemplatePlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.setUsingSchemaTemplate(activateTemplatePlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("active template in %s", activateTemplatePlan.getPaths()), AuditLogOperation.DML);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean deactivateTemplate(DeactivateTemplatePlan deactivateTemplatePlan) throws QueryProcessException {
        try {
            ArrayList<PartialPath> pathToDeactivate = new ArrayList<PartialPath>(IoTDB.metaManager.getPathsUsingTemplateUnderPrefix(deactivateTemplatePlan.getTemplateName(), deactivateTemplatePlan.getPrefixPath().getFullPath(), false));
            deactivateTemplatePlan.setPaths(pathToDeactivate);
            List<String> measurementsInnerPaths = IoTDB.metaManager.getMeasurementsInTemplate(deactivateTemplatePlan.getTemplateName(), "");
            ArrayList<PartialPath> innerPartialPath = new ArrayList<PartialPath>();
            for (String string : measurementsInnerPaths) {
                innerPartialPath.add(new PartialPath(string));
            }
            ArrayList<PartialPath> pathToDelete = new ArrayList<PartialPath>(innerPartialPath.size() * pathToDeactivate.size());
            for (PartialPath prePath : pathToDeactivate) {
                for (PartialPath sufPath : innerPartialPath) {
                    pathToDelete.add(prePath.concatPath(sufPath));
                }
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("delete timeseries %s", pathToDelete), AuditLogOperation.DDL);
            }
            DeleteTimeSeriesPlan deleteTimeSeriesPlan = new DeleteTimeSeriesPlan(pathToDelete);
            for (PartialPath path : pathToDelete) {
                StorageEngine.getInstance().deleteTimeseries(path, deleteTimeSeriesPlan.getIndex(), deleteTimeSeriesPlan.getPartitionFilter());
            }
            StorageEngine.getInstance().syncCloseAllProcessor();
            IoTDB.metaManager.deactivateSchemaTemplate(deactivateTemplatePlan);
        }
        catch (StorageEngineException e) {
            logger.error("Deactivation of template [{}] failed since one of its time series is failed to delete.", (Object)deactivateTemplatePlan.getTemplateName());
            logger.error(e.getMessage());
            throw new QueryProcessException(e);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean unsetTemplate(UnsetTemplatePlan unsetTemplatePlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.unsetSchemaTemplate(unsetTemplatePlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("unset template %s", unsetTemplatePlan.getTemplateName()), AuditLogOperation.DML);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean operateCreateFunction(CreateFunctionPlan plan) throws UDFRegistrationException {
        UDFRegistrationService.getInstance().register(plan.getUdfName(), plan.getClassName(), true);
        if (enableAuditLog) {
            AuditLogger.log(String.format("create function,udf name: %s,class name:%s", plan.getUdfName(), plan.getClassName()), AuditLogOperation.DDL);
        }
        return true;
    }

    private boolean operateDropFunction(DropFunctionPlan plan) throws UDFRegistrationException {
        UDFRegistrationService.getInstance().deregister(plan.getUdfName());
        if (enableAuditLog) {
            AuditLogger.log(String.format("drop function,udf name: %s", plan.getUdfName()), AuditLogOperation.DDL);
        }
        return true;
    }

    private boolean operateCreateTrigger(CreateTriggerPlan plan) throws TriggerManagementException, TriggerExecutionException {
        TriggerRegistrationService.getInstance().register(plan);
        if (enableAuditLog) {
            AuditLogger.log(String.format("create trigger %s", plan.getTriggerName()), AuditLogOperation.DDL);
        }
        return true;
    }

    private boolean operateDropTrigger(DropTriggerPlan plan) throws TriggerManagementException {
        TriggerRegistrationService.getInstance().deregister(plan);
        if (enableAuditLog) {
            AuditLogger.log(String.format("drop trigger %s", plan.getTriggerName()), AuditLogOperation.DDL);
        }
        return true;
    }

    private boolean operateStartTrigger(StartTriggerPlan plan) throws TriggerManagementException, TriggerExecutionException {
        TriggerRegistrationService.getInstance().activate(plan);
        if (enableAuditLog) {
            AuditLogger.log(String.format("start trigger %s", plan.getTriggerName()), AuditLogOperation.DML);
        }
        return true;
    }

    private boolean operateStopTrigger(StopTriggerPlan plan) throws TriggerManagementException {
        TriggerRegistrationService.getInstance().inactivate(plan);
        if (enableAuditLog) {
            AuditLogger.log(String.format("stop trigger %s", plan.getTriggerName()), AuditLogOperation.DML);
        }
        return true;
    }

    private void operateMerge() throws StorageEngineException {
        StorageEngine.getInstance().mergeAll();
    }

    public static void operateClearCache() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    private void operateCreateSnapshot() {
        IoTDB.metaManager.createMTreeSnapshot();
        if (enableAuditLog) {
            AuditLogger.log("create snapshot", AuditLogOperation.DDL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void operateKillQuery(KillQueryPlan killQueryPlan) throws QueryIdNotExsitException {
        QueryTimeManager queryTimeManager = QueryTimeManager.getInstance();
        long killQueryId = killQueryPlan.getQueryId();
        if (killQueryId != -1L) {
            if (queryTimeManager.getQueryContextMap().get(killQueryId) == null) throw new QueryIdNotExsitException(String.format("Query Id %d is not exist, please check it.", killQueryPlan.getQueryId()));
            queryTimeManager.killQuery(killQueryId);
            return;
        }
        if (queryTimeManager.getQueryContextMap().isEmpty()) return;
        Map<Long, QueryContext> map = queryTimeManager.getQueryContextMap();
        synchronized (map) {
            ArrayList<Long> queryIdList = new ArrayList<Long>(queryTimeManager.getQueryContextMap().keySet());
            for (Long queryId : queryIdList) {
                queryTimeManager.killQuery(queryId);
            }
            return;
        }
    }

    private void operateSetSystemMode(SetSystemModePlan plan) {
        IoTDBDescriptor.getInstance().getConfig().setSystemStatus(plan.isReadOnly() ? SystemStatus.READ_ONLY : SystemStatus.NORMAL);
    }

    private void operateFlush(FlushPlan plan) throws StorageGroupNotSetException {
        List<PartialPath> noExistSg;
        if (plan.getPaths().isEmpty()) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        } else {
            PlanExecutor.flushSpecifiedStorageGroups(plan);
        }
        if (!plan.getPaths().isEmpty() && !(noExistSg = this.checkStorageGroupExist(plan.getPaths())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            throw new StorageGroupNotSetException(sb.subSequence(0, sb.length() - 1).toString(), true);
        }
    }

    private boolean operateCreateContinuousQuery(CreateContinuousQueryPlan plan) throws ContinuousQueryException {
        return ContinuousQueryService.getInstance().register(plan, true);
    }

    private boolean operateDropContinuousQuery(DropContinuousQueryPlan plan) throws ContinuousQueryException {
        return ContinuousQueryService.getInstance().deregister(plan, true);
    }

    public static void flushSpecifiedStorageGroups(FlushPlan plan) throws StorageGroupNotSetException {
        Map<PartialPath, List<Pair<Long, Boolean>>> storageGroupMap = plan.getStorageGroupPartitionIds();
        for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : storageGroupMap.entrySet()) {
            PartialPath storageGroupName = entry.getKey();
            if (entry.getValue() == null) {
                if (plan.isSeq() == null) {
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, true, plan.isSync());
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, false, plan.isSync());
                    continue;
                }
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, plan.isSeq(), plan.isSync());
                continue;
            }
            List<Pair<Long, Boolean>> partitionIdSequencePairs = entry.getValue();
            for (Pair<Long, Boolean> pair : partitionIdSequencePairs) {
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, (Long)pair.left, (Boolean)pair.right, true);
            }
        }
    }

    protected QueryDataSet processDataQuery(QueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryFilterOptimizationException, QueryProcessException, IOException, InterruptedException {
        AlignByDeviceDataSet queryDataSet;
        if (queryPlan instanceof AlignByDevicePlan) {
            queryDataSet = this.getAlignByDeviceDataSet((AlignByDevicePlan)queryPlan, context, this.queryRouter);
        } else {
            if (queryPlan.getPaths() == null || queryPlan.getPaths().isEmpty()) {
                return new EmptyDataSet();
            }
            if (queryPlan instanceof UDAFPlan) {
                UDAFPlan udafPlan = (UDAFPlan)queryPlan;
                queryDataSet = this.queryRouter.udafQuery(udafPlan, context);
            } else if (queryPlan instanceof UDTFPlan) {
                UDTFPlan udtfPlan = (UDTFPlan)queryPlan;
                queryDataSet = this.queryRouter.udtfQuery(udtfPlan, context);
            } else if (queryPlan instanceof GroupByTimeFillPlan) {
                GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)queryPlan;
                queryDataSet = this.queryRouter.groupByFill(groupByFillPlan, context);
            } else if (queryPlan instanceof GroupByTimePlan) {
                GroupByTimePlan groupByTimePlan = (GroupByTimePlan)queryPlan;
                queryDataSet = this.queryRouter.groupBy(groupByTimePlan, context);
            } else {
                if (queryPlan instanceof QueryIndexPlan) {
                    throw new QueryProcessException("Query index hasn't been supported yet");
                }
                if (queryPlan instanceof AggregationPlan) {
                    AggregationPlan aggregationPlan = (AggregationPlan)queryPlan;
                    queryDataSet = this.queryRouter.aggregate(aggregationPlan, context);
                } else if (queryPlan instanceof FillQueryPlan) {
                    FillQueryPlan fillQueryPlan = (FillQueryPlan)queryPlan;
                    queryDataSet = this.queryRouter.fill(fillQueryPlan, context);
                } else {
                    queryDataSet = queryPlan instanceof LastQueryPlan ? this.queryRouter.lastQuery((LastQueryPlan)queryPlan, context) : this.queryRouter.rawDataQuery((RawDataQueryPlan)queryPlan, context);
                }
            }
        }
        queryDataSet.setRowLimit(queryPlan.getRowLimit());
        queryDataSet.setRowOffset(queryPlan.getRowOffset());
        queryDataSet.setWithoutAllNull(queryPlan.isWithoutAllNull());
        queryDataSet.setWithoutAnyNull(queryPlan.isWithoutAnyNull());
        queryDataSet.setWithoutNullColumnsIndex(queryPlan.getWithoutNullColumnsIndex());
        return queryDataSet;
    }

    protected AlignByDeviceDataSet getAlignByDeviceDataSet(AlignByDevicePlan plan, QueryContext context, IQueryRouter router) throws QueryProcessException {
        return new AlignByDeviceDataSet(plan, context, router);
    }

    protected QueryDataSet processShowQuery(ShowPlan showPlan, QueryContext context) throws QueryProcessException, MetadataException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return this.processShowTTLQuery((ShowTTLPlan)showPlan);
            }
            case FLUSH_TASK_INFO: {
                return this.processShowFlushTaskInfo();
            }
            case VERSION: {
                return this.processShowVersion();
            }
            case TIMESERIES: {
                return this.processShowTimeseries((ShowTimeSeriesPlan)showPlan, context);
            }
            case STORAGE_GROUP: {
                return this.processShowStorageGroup((ShowStorageGroupPlan)showPlan);
            }
            case LOCK_INFO: {
                return this.processShowLockInfo((ShowLockInfoPlan)showPlan);
            }
            case DEVICES: {
                return this.processShowDevices((ShowDevicesPlan)showPlan);
            }
            case CHILD_PATH: {
                return this.processShowChildPaths((ShowChildPathsPlan)showPlan);
            }
            case CHILD_NODE: {
                return this.processShowChildNodes((ShowChildNodesPlan)showPlan);
            }
            case COUNT_TIMESERIES: {
                return this.processCountTimeSeries((CountPlan)showPlan);
            }
            case COUNT_NODE_TIMESERIES: {
                return this.processCountNodeTimeSeries((CountPlan)showPlan);
            }
            case COUNT_DEVICES: {
                return this.processCountDevices((CountPlan)showPlan);
            }
            case COUNT_STORAGE_GROUP: {
                return this.processCountStorageGroup((CountPlan)showPlan);
            }
            case COUNT_NODES: {
                return this.processCountNodes((CountPlan)showPlan);
            }
            case QUERY_PROCESSLIST: {
                return this.processShowQueryProcesslist();
            }
            case FUNCTIONS: {
                return this.processShowFunctions((ShowFunctionsPlan)showPlan);
            }
            case TRIGGERS: {
                return this.processShowTriggers();
            }
            case CONTINUOUS_QUERY: {
                return this.processShowContinuousQueries();
            }
            case SCHEMA_TEMPLATE: {
                return this.processShowSchemaTemplates();
            }
            case NODES_IN_SCHEMA_TEMPLATE: {
                return this.processShowNodesInSchemaTemplate((ShowNodesInTemplatePlan)showPlan);
            }
            case PATHS_SET_SCHEMA_TEMPLATE: {
                return this.processShowPathsSetSchemaTemplate((ShowPathsSetTemplatePlan)showPlan);
            }
            case PATHS_USING_SCHEMA_TEMPLATE: {
                return this.processShowPathsUsingSchemaTemplate((ShowPathsUsingTemplatePlan)showPlan);
            }
            case SHOW_ARCHIVING: {
                return this.processShowArchiving((ShowArchivingPlan)showPlan);
            }
        }
        throw new QueryProcessException(String.format("Unrecognized show plan %s", showPlan));
    }

    private QueryDataSet processCountNodes(CountPlan countPlan) throws MetadataException {
        int num = this.getNodesNumInGivenLevel(countPlan.getPath(), countPlan.getLevel(), countPlan.isPrefixMatch());
        return this.createSingleDataSet("count", TSDataType.INT32, num);
    }

    private QueryDataSet processCountNodeTimeSeries(CountPlan countPlan) throws MetadataException {
        Map<PartialPath, Integer> countResults = this.getTimeseriesCountGroupByLevel(countPlan);
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("column", false), new PartialPath("count", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        for (PartialPath columnPath : countResults.keySet()) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(columnPath.getFullPath()));
            Field field1 = new Field(TSDataType.INT32);
            field1.setIntV(countResults.get(columnPath).intValue());
            record.addField(field);
            record.addField(field1);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processCountDevices(CountPlan countPlan) throws MetadataException {
        int num = this.getDevicesNum(countPlan.getPath(), countPlan.isPrefixMatch());
        return this.createSingleDataSet("devices", TSDataType.INT32, num);
    }

    private QueryDataSet processCountStorageGroup(CountPlan countPlan) throws MetadataException {
        int num = this.getStorageGroupNum(countPlan.getPath(), countPlan.isPrefixMatch());
        return this.createSingleDataSet("storage group", TSDataType.INT32, num);
    }

    private QueryDataSet createSingleDataSet(String columnName, TSDataType columnType, Object val) {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath(columnName, false)), Collections.singletonList(columnType));
        Field field = new Field(columnType);
        switch (columnType) {
            case TEXT: {
                field.setBinaryV((Binary)val);
                break;
            }
            case FLOAT: {
                field.setFloatV(((Float)val).floatValue());
                break;
            }
            case INT32: {
                field.setIntV(((Integer)val).intValue());
                break;
            }
            case INT64: {
                field.setLongV(((Long)val).longValue());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(((Double)val).doubleValue());
                break;
            }
            case BOOLEAN: {
                field.setBoolV(((Boolean)val).booleanValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type" + columnType);
            }
        }
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    protected int getDevicesNum(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return IoTDB.metaManager.getDevicesNum(path, isPrefixMatch);
    }

    private int getStorageGroupNum(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return IoTDB.metaManager.getStorageGroupNum(path, isPrefixMatch);
    }

    protected int getPathsNum(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesCount(path, isPrefixMatch);
    }

    protected int getNodesNumInGivenLevel(PartialPath path, int level, boolean isPrefixMatch) throws MetadataException {
        return IoTDB.metaManager.getNodesCountInGivenLevel(path, level, isPrefixMatch);
    }

    protected List<MeasurementPath> getPathsName(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getMeasurementPaths(path);
    }

    protected List<PartialPath> getNodesList(PartialPath schemaPattern, int level) throws MetadataException {
        return IoTDB.metaManager.getNodesListInGivenLevel(schemaPattern, level);
    }

    private Map<PartialPath, Integer> getTimeseriesCountGroupByLevel(CountPlan countPlan) throws MetadataException {
        return IoTDB.metaManager.getMeasurementCountGroupByLevel(countPlan.getPath(), countPlan.getLevel(), countPlan.isPrefixMatch());
    }

    private QueryDataSet processCountTimeSeries(CountPlan countPlan) throws MetadataException {
        int num = this.getPathsNum(countPlan.getPath(), countPlan.isPrefixMatch());
        return this.createSingleDataSet("count", TSDataType.INT32, num);
    }

    private QueryDataSet processShowDevices(ShowDevicesPlan showDevicesPlan) throws MetadataException {
        return new ShowDevicesDataSet(showDevicesPlan);
    }

    private QueryDataSet processShowChildPaths(ShowChildPathsPlan showChildPathsPlan) throws MetadataException {
        Set<String> childPathsList = this.getPathNextChildren(showChildPathsPlan.getPath(), showChildPathsPlan.getLimit(), showChildPathsPlan.getOffset());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.TEXT));
        for (String s : childPathsList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getPathNextChildren(PartialPath path, int limit, int offset) throws MetadataException {
        return IoTDB.metaManager.getChildNodePathInNextLevel(path, limit, offset);
    }

    private QueryDataSet processShowChildNodes(ShowChildNodesPlan showChildNodesPlan) throws MetadataException {
        Set<String> childNodesList = this.getNodeNextChildren(showChildNodesPlan.getPath(), showChildNodesPlan.getLimit(), showChildNodesPlan.getOffset());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child nodes", false)), Collections.singletonList(TSDataType.TEXT));
        for (String s : childNodesList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getNodeNextChildren(PartialPath path, int limit, int offset) throws MetadataException {
        return IoTDB.metaManager.getChildNodeNameInNextLevel(path, limit, offset);
    }

    protected List<PartialPath> getStorageGroupNames(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return IoTDB.metaManager.getMatchedStorageGroups(path, isPrefixMatch);
    }

    private QueryDataSet processShowStorageGroup(ShowStorageGroupPlan showStorageGroupPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("storage group", false)), Collections.singletonList(TSDataType.TEXT));
        List<PartialPath> storageGroupList = this.getStorageGroupNames(showStorageGroupPlan.getPath(), showStorageGroupPlan.isPrefixMatch());
        this.addToDataSet((Collection<PartialPath>)storageGroupList, listDataSet);
        return listDataSet;
    }

    private void addToDataSet(Collection<PartialPath> paths, ListDataSet dataSet) {
        for (PartialPath s : paths) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s.getFullPath()));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private QueryDataSet processShowLockInfo(ShowLockInfoPlan showLockInfoPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("storage group", false), new PartialPath("lock holder", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        try {
            List<PartialPath> storageGroupList = this.getStorageGroupNames(showLockInfoPlan.getPath(), showLockInfoPlan.isPrefixMatch());
            List<String> lockHolderList = StorageEngine.getInstance().getLockInfo(storageGroupList);
            this.addLockInfoToDataSet(storageGroupList, lockHolderList, listDataSet);
        }
        catch (StorageEngineException e) {
            throw new MetadataException(e);
        }
        return listDataSet;
    }

    private void addLockInfoToDataSet(List<PartialPath> paths, List<String> lockHolderList, ListDataSet dataSet) {
        for (int i = 0; i < paths.size(); ++i) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(paths.get(i).getFullPath()));
            record.addField(field);
            field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(lockHolderList.get(i)));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private QueryDataSet processShowTimeseries(ShowTimeSeriesPlan showTimeSeriesPlan, QueryContext context) throws MetadataException {
        return new ShowTimeseriesDataSet(showTimeSeriesPlan, context);
    }

    protected List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return IoTDB.metaManager.getAllStorageGroupNodes();
    }

    private QueryDataSet processShowTTLQuery(ShowTTLPlan showTTLPlan) {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("storage group", false), new PartialPath("ttl(ms)", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT64));
        HashSet<PartialPath> selectedSgs = new HashSet<PartialPath>(showTTLPlan.getStorageGroups());
        List<IStorageGroupMNode> storageGroups = this.getAllStorageGroupNodes();
        int timestamp = 0;
        for (IStorageGroupMNode mNode : storageGroups) {
            Field ttl;
            PartialPath sgName = mNode.getPartialPath();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName)) continue;
            RowRecord rowRecord = new RowRecord((long)timestamp++);
            Field sg = new Field(TSDataType.TEXT);
            sg.setBinaryV(new Binary(sgName.getFullPath()));
            if (mNode.getDataTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(mNode.getDataTTL());
            } else {
                ttl = null;
            }
            rowRecord.addField(sg);
            rowRecord.addField(ttl);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private QueryDataSet processShowVersion() {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("        version", false)), Collections.singletonList(TSDataType.TEXT));
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(IoTDBConstant.VERSION));
        RowRecord rowRecord = new RowRecord(0L);
        rowRecord.addField(field);
        singleDataSet.setRecord(rowRecord);
        return singleDataSet;
    }

    private QueryDataSet processShowFlushTaskInfo() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("                             item", false), new PartialPath("value", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        int timestamp = 0;
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "total number of flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getTotalTasks()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "number of working flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWorkingTasksNumber()));
        this.addRowRecordForShowQuery(listDataSet, timestamp, "number of waiting flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWaitingTasksNumber()));
        return listDataSet;
    }

    private QueryDataSet processShowFunctions(ShowFunctionsPlan showPlan) throws QueryProcessException {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("function name", false), new PartialPath("function type", false), new PartialPath("class name (UDF)", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        this.appendUDFs(listDataSet, showPlan);
        this.appendNativeFunctions(listDataSet, showPlan);
        listDataSet.sort((r1, r2) -> String.CASE_INSENSITIVE_ORDER.compare(((Field)r1.getFields().get(0)).getStringValue(), ((Field)r2.getFields().get(0)).getStringValue()));
        return listDataSet;
    }

    private void appendUDFs(ListDataSet listDataSet, ShowFunctionsPlan showPlan) throws QueryProcessException {
        for (UDFRegistrationInformation info : UDFRegistrationService.getInstance().getRegistrationInformation()) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)info.getFunctionName()), TSDataType.TEXT);
            String functionType = "";
            try {
                if (info.isBuiltin()) {
                    if (info.isUDTF()) {
                        functionType = "built-in UDTF";
                    } else if (info.isUDAF()) {
                        functionType = "built-in UDAF";
                    }
                } else if (info.isUDTF()) {
                    functionType = "external UDTF";
                } else if (info.isUDAF()) {
                    functionType = "external UDAF";
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new QueryProcessException(e.toString());
            }
            rowRecord.addField((Object)Binary.valueOf((String)functionType), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)info.getClassName()), TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }

    private QueryDataSet processShowContinuousQueries() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("cq name", false), new PartialPath("every interval", false), new PartialPath("for interval", false), new PartialPath("boundary", false), new PartialPath("query sql", false), new PartialPath("target path", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT64, TSDataType.INT64, TSDataType.INT64, TSDataType.TEXT, TSDataType.TEXT));
        List<ShowContinuousQueriesResult> continuousQueriesList = ContinuousQueryService.getInstance().getShowContinuousQueriesResultList();
        for (ShowContinuousQueriesResult result : continuousQueriesList) {
            RowRecord record = new RowRecord(0L);
            record.addField((Object)Binary.valueOf((String)result.getContinuousQueryName()), TSDataType.TEXT);
            record.addField((Object)result.getEveryInterval(), TSDataType.INT64);
            record.addField((Object)result.getForInterval(), TSDataType.INT64);
            record.addField((Object)result.getBoundary(), TSDataType.INT64);
            record.addField((Object)Binary.valueOf((String)result.getQuerySql()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)result.getTargetPath().getFullPath()), TSDataType.TEXT);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processShowSchemaTemplates() {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("template name", false)), Collections.singletonList(TSDataType.TEXT));
        Set<String> allTemplates = IoTDB.metaManager.getAllTemplates();
        for (String templateName : allTemplates) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)templateName), TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private QueryDataSet processShowNodesInSchemaTemplate(ShowNodesInTemplatePlan showPlan) throws QueryProcessException {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("child nodes", false), new PartialPath("dataType", false), new PartialPath("encoding", false), new PartialPath("compression", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        try {
            List<Pair<String, IMeasurementSchema>> measurements = IoTDB.metaManager.getSchemasInTemplate(showPlan.getTemplateName(), "");
            for (Pair<String, IMeasurementSchema> measurement : measurements) {
                RowRecord rowRecord = new RowRecord(0L);
                rowRecord.addField((Object)Binary.valueOf((String)((String)measurement.left)), TSDataType.TEXT);
                IMeasurementSchema measurementSchema = (IMeasurementSchema)measurement.right;
                rowRecord.addField((Object)Binary.valueOf((String)measurementSchema.getType().toString()), TSDataType.TEXT);
                rowRecord.addField((Object)Binary.valueOf((String)measurementSchema.getEncodingType().toString()), TSDataType.TEXT);
                rowRecord.addField((Object)Binary.valueOf((String)measurementSchema.getCompressor().toString()), TSDataType.TEXT);
                listDataSet.putRecord(rowRecord);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return listDataSet;
    }

    private QueryDataSet processShowPathsUsingSchemaTemplate(ShowPathsUsingTemplatePlan showPlan) throws QueryProcessException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.TEXT));
        try {
            Set<String> paths = IoTDB.metaManager.getPathsUsingTemplate(showPlan.getTemplateName());
            for (String path : paths) {
                RowRecord rowRecord = new RowRecord(0L);
                rowRecord.addField((Object)Binary.valueOf((String)path), TSDataType.TEXT);
                listDataSet.putRecord(rowRecord);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return listDataSet;
    }

    private QueryDataSet processShowPathsSetSchemaTemplate(ShowPathsSetTemplatePlan showPlan) throws QueryProcessException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.TEXT));
        try {
            Set<String> paths = IoTDB.metaManager.getPathsSetTemplate(showPlan.getTemplateName());
            for (String path : paths) {
                RowRecord rowRecord = new RowRecord(0L);
                rowRecord.addField((Object)Binary.valueOf((String)path), TSDataType.TEXT);
                listDataSet.putRecord(rowRecord);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return listDataSet;
    }

    private void appendNativeFunctions(ListDataSet listDataSet, ShowFunctionsPlan showPlan) {
        Binary functionType = Binary.valueOf((String)"native");
        Binary className = Binary.valueOf((String)"");
        for (String functionName : SQLConstant.getNativeFunctionNames()) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)functionName.toUpperCase()), TSDataType.TEXT);
            rowRecord.addField((Object)functionType, TSDataType.TEXT);
            rowRecord.addField((Object)className, TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }

    private QueryDataSet processShowTriggers() {
        return TriggerRegistrationService.getInstance().show();
    }

    private QueryDataSet processShowArchiving(ShowArchivingPlan showArchivingPlan) {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("task id", false), new PartialPath("submit time", false), new PartialPath("storage group", false), new PartialPath("status", false), new PartialPath("start time", false), new PartialPath("expire time(ms)", false), new PartialPath("target directory", false)), Arrays.asList(TSDataType.INT64, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT64, TSDataType.TEXT));
        HashSet<PartialPath> selectedSgs = new HashSet<PartialPath>(showArchivingPlan.getStorageGroups());
        List<ArchivingTask> archivingTaskList = StorageEngine.getInstance().getArchivingManager().getArchivingTasks();
        int timestamp = 0;
        for (ArchivingTask task : archivingTaskList) {
            Field startTime;
            Field ttl;
            PartialPath sgName = task.getStorageGroup();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName) || !showArchivingPlan.isShowAll() && !task.isActive()) continue;
            RowRecord rowRecord = new RowRecord((long)timestamp++);
            Field taskId = new Field(TSDataType.INT64);
            Field submitTime = new Field(TSDataType.TEXT);
            Field sg = new Field(TSDataType.TEXT);
            Field status = new Field(TSDataType.TEXT);
            Field targetDir = new Field(TSDataType.TEXT);
            taskId.setLongV(task.getTaskId());
            sg.setBinaryV(new Binary(sgName.getFullPath()));
            status.setBinaryV(new Binary(task.getStatus().name()));
            targetDir.setBinaryV(new Binary(task.getTargetDir().getPath()));
            if (task.getTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(task.getTTL());
            } else {
                ttl = null;
            }
            ZonedDateTime submitDateTime = DateTimeUtils.convertMillsecondToZonedDateTime(task.getSubmitTime());
            String submitTimeStr = DateTimeUtils.ISO_OFFSET_DATE_TIME_WITH_MS.format(submitDateTime);
            submitTime.setBinaryV(new Binary(submitTimeStr));
            if (task.getStartTime() != Long.MAX_VALUE) {
                ZonedDateTime startDate = DateTimeUtils.convertMillsecondToZonedDateTime(task.getStartTime());
                String startTimeStr = DateTimeUtils.ISO_OFFSET_DATE_TIME_WITH_MS.format(startDate);
                startTime = new Field(TSDataType.TEXT);
                startTime.setBinaryV(new Binary(startTimeStr));
            } else {
                startTime = null;
            }
            rowRecord.addField(taskId);
            rowRecord.addField(submitTime);
            rowRecord.addField(sg);
            rowRecord.addField(status);
            rowRecord.addField(startTime);
            rowRecord.addField(ttl);
            rowRecord.addField(targetDir);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private void addRowRecordForShowQuery(ListDataSet listDataSet, int timestamp, String item, String value) {
        RowRecord rowRecord = new RowRecord((long)timestamp);
        Field itemField = new Field(TSDataType.TEXT);
        itemField.setBinaryV(new Binary(item));
        Field valueField = new Field(TSDataType.TEXT);
        valueField.setBinaryV(new Binary(value));
        rowRecord.addField(itemField);
        rowRecord.addField(valueField);
        listDataSet.putRecord(rowRecord);
    }

    @Override
    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        if (enableAuditLog) {
            AuditLogger.log(String.format("delete data from %s in [%s,%s]", deletePlan.getPaths(), deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime()), AuditLogOperation.DML);
        }
        for (PartialPath path : deletePlan.getPaths()) {
            this.delete(path, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime(), deletePlan.getIndex(), deletePlan.getPartitionFilter());
        }
    }

    private void operateLoadFiles(OperateFilePlan plan) throws QueryProcessException {
        File file = plan.getFile();
        if (!file.exists()) {
            throw new QueryProcessException(String.format("File path '%s' doesn't exists.", file.getPath()));
        }
        if (enableAuditLog) {
            AuditLogger.log(String.format("load files from %s ", file.getPath()), AuditLogOperation.DDL);
        }
        if (file.isDirectory()) {
            this.loadDir(file, plan);
        } else {
            this.loadFile(file, plan);
        }
    }

    private void loadDir(File curFile, OperateFilePlan plan) throws QueryProcessException {
        File[] files = curFile.listFiles();
        long[] establishTime = new long[files.length];
        ArrayList<Integer> tsfiles = new ArrayList<Integer>();
        ArrayList<String> failedFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            String fileName;
            File file = files[i];
            if (file.isDirectory() || !(fileName = file.getName()).endsWith(".tsfile")) continue;
            establishTime[i] = Long.parseLong(fileName.split("-")[0]);
            tsfiles.add(i);
        }
        Collections.sort(tsfiles, (o1, o2) -> {
            if (establishTime[o1] == establishTime[o2]) {
                return 0;
            }
            return establishTime[o1] < establishTime[o2] ? -1 : 1;
        });
        for (Integer i : tsfiles) {
            try {
                this.loadFile(files[i], plan);
            }
            catch (QueryProcessException e) {
                logger.error("{}, skip load {}.", (Object)e.getMessage(), (Object)files[i].getAbsolutePath());
                failedFiles.add(files[i].getAbsolutePath());
            }
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            this.loadDir(file, plan);
        }
        if (failedFiles.size() > 0) {
            throw new QueryProcessException(String.format("Fail to load TsFile %s", String.join((CharSequence)",", failedFiles)));
        }
    }

    private void loadFile(File file, OperateFilePlan plan) throws QueryProcessException {
        if (!file.getName().endsWith(".tsfile")) {
            return;
        }
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        try {
            RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(file);
            if (restorableTsFileIOWriter.hasCrashed()) {
                restorableTsFileIOWriter.close();
                throw new QueryProcessException(String.format("Cannot load file %s because the file has crashed.", file.getAbsolutePath()));
            }
            HashMap<Path, IMeasurementSchema> schemaMap = new HashMap<Path, IMeasurementSchema>();
            ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                if (reader.selfCheck(schemaMap, chunkGroupMetadataList, false) != 0L) {
                    throw new QueryProcessException(String.format("Cannot load file %s because the file has crashed.", file.getAbsolutePath()));
                }
                if (plan.getVerifyMetadata()) {
                    this.loadNewTsFileVerifyMetadata(reader);
                }
            }
            catch (IOException e) {
                logger.warn("can not get timeseries metadata from {}.", (Object)file.getAbsoluteFile());
                throw new QueryProcessException(e.getMessage());
            }
            FileLoaderUtils.checkTsFileResource(tsFileResource);
            if (UpgradeUtils.isNeedUpgrade(tsFileResource)) {
                throw new QueryProcessException(String.format("Cannot load file %s because the file's version is old which needs to be upgraded.", file.getAbsolutePath()));
            }
            if (plan.isAutoCreateSchema()) {
                this.createSchemaAutomatically(chunkGroupMetadataList, schemaMap, plan.getSgLevel());
            }
            ArrayList<TsFileResource> splitResources = new ArrayList<TsFileResource>();
            if (tsFileResource.isSpanMultiTimePartitions()) {
                logger.info("try to split the tsFile={} du to it spans multi partitions", (Object)tsFileResource.getTsFile().getPath());
                TsFileRewriteTool.rewriteTsFile(tsFileResource, splitResources);
                tsFileResource.writeLock();
                tsFileResource.removeModFile();
                tsFileResource.writeUnlock();
                logger.info("after split, the old tsFile was split to {} new tsFiles", (Object)splitResources.size());
            }
            if (splitResources.isEmpty()) {
                splitResources.add(tsFileResource);
            }
            for (TsFileResource resource : splitResources) {
                StorageEngine.getInstance().loadNewTsFile(resource);
            }
        }
        catch (Exception e) {
            logger.error("fail to load file {}", (Object)file.getName(), (Object)e);
            throw new QueryProcessException(String.format("Cannot load file %s because %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    private void loadNewTsFileVerifyMetadata(TsFileSequenceReader tsFileSequenceReader) throws MetadataException, QueryProcessException, IOException {
        Map metadataSet = tsFileSequenceReader.getAllTimeseriesMetadata(false);
        for (Map.Entry entry : metadataSet.entrySet()) {
            String deviceId = (String)entry.getKey();
            PartialPath devicePath = new PartialPath(deviceId);
            if (!IoTDB.metaManager.isPathExist(devicePath)) continue;
            boolean isAlignedInIoTDB = IoTDB.metaManager.getDeviceNode(devicePath).getAsEntityMNode().isAligned();
            boolean isAlignedInTsFile = false;
            for (TimeseriesMetadata metadata : (List)entry.getValue()) {
                TSDataType dataType;
                if ("".equals(metadata.getMeasurementId())) {
                    isAlignedInTsFile = true;
                    continue;
                }
                PartialPath fullPath = new PartialPath(deviceId + "." + metadata.getMeasurementId());
                if (!IoTDB.metaManager.isPathExist(fullPath) || (dataType = IoTDB.metaManager.getSeriesType(fullPath)) == metadata.getTSDataType()) continue;
                throw new QueryProcessException(String.format("%s is %s in the loading TsFile but is %s in IoTDB.", fullPath.getFullPath(), metadata.getTSDataType().name(), dataType.name()));
            }
            if (isAlignedInIoTDB == isAlignedInTsFile) continue;
            throw new QueryProcessException(String.format("%s is%s aligned in the loading TsFile but is%s aligned in IoTDB.", devicePath.getFullPath(), isAlignedInTsFile ? "" : " not", isAlignedInIoTDB ? "" : " not"));
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void createSchemaAutomatically(List<ChunkGroupMetadata> chunkGroupMetadataList, Map<Path, IMeasurementSchema> knownSchemas, int sgLevel) throws MetadataException {
        if (chunkGroupMetadataList.isEmpty()) {
            return;
        }
        HashSet<PartialPath> registeredSeries = new HashSet<PartialPath>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            PartialPath devicePath;
            ArrayList<IMeasurementSchema> needRegisterSchema;
            ArrayList<PartialPath> needRegisterSeries;
            HashSet<String> existSeriesSet;
            boolean isAligned;
            block11: {
                String device = chunkGroupMetadata.getDevice();
                isAligned = false;
                existSeriesSet = new HashSet<String>();
                needRegisterSeries = new ArrayList<PartialPath>();
                needRegisterSchema = new ArrayList<IMeasurementSchema>();
                devicePath = new PartialPath(device);
                PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(devicePath, sgLevel);
                try {
                    IoTDB.metaManager.setStorageGroup(storageGroupPath);
                }
                catch (StorageGroupAlreadySetException alreadySetException) {
                    if (alreadySetException.getStorageGroupPath().equals(storageGroupPath.getFullPath())) break block11;
                    throw alreadySetException;
                }
            }
            for (PartialPath path : IoTDB.metaManager.getMeasurementPaths(devicePath, true)) {
                existSeriesSet.add(path.getMeasurement());
                existSeriesSet.add(path.getMeasurementAlias());
            }
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                if ("".equals(chunkMetadata.getMeasurementUid())) {
                    isAligned = true;
                    continue;
                }
                PartialPath series = new PartialPath(chunkGroupMetadata.getDevice() + "." + chunkMetadata.getMeasurementUid());
                if (registeredSeries.contains(series)) continue;
                registeredSeries.add(series);
                IMeasurementSchema schema = knownSchemas.get(new Path(series.getDevice(), series.getMeasurement()));
                if (schema == null) {
                    throw new MetadataException(String.format("Can not get the schema of measurement [%s]", chunkMetadata.getMeasurementUid()));
                }
                if (existSeriesSet.contains(chunkMetadata.getMeasurementUid())) continue;
                needRegisterSeries.add(series);
                needRegisterSchema.add(schema);
            }
            int size = needRegisterSeries.size();
            if (size == 0) continue;
            if (isAligned) {
                ArrayList<String> measurements = new ArrayList<String>();
                ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
                ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
                for (int i = 0; i < size; ++i) {
                    IMeasurementSchema schema = (IMeasurementSchema)needRegisterSchema.get(i);
                    measurements.add(((PartialPath)needRegisterSeries.get(i)).getMeasurement());
                    dataTypes.add(schema.getType());
                    encodings.add(schema.getEncodingType());
                    compressors.add(schema.getCompressor());
                }
                IoTDB.metaManager.createAlignedTimeSeries(devicePath, measurements, dataTypes, encodings, compressors);
                continue;
            }
            for (int i = 0; i < size; ++i) {
                IMeasurementSchema schema = (IMeasurementSchema)needRegisterSchema.get(i);
                IoTDB.metaManager.createTimeseries((PartialPath)needRegisterSeries.get(i), schema.getType(), schema.getEncodingType(), schema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    private void operateRemoveFile(OperateFilePlan plan) throws QueryProcessException {
        try {
            if (!plan.getFile().exists() || !StorageEngine.getInstance().deleteTsfile(plan.getFile())) {
                throw new QueryProcessException(String.format("File '%s' doesn't exist.", plan.getFile().getAbsolutePath()));
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("remove file from %s ", plan.getFile().getAbsolutePath()), AuditLogOperation.DDL);
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot remove file because %s", e.getMessage()));
        }
    }

    private void operateUnloadFile(OperateFilePlan plan) throws QueryProcessException {
        if (!plan.getTargetDir().exists() || !plan.getTargetDir().isDirectory()) {
            throw new QueryProcessException(String.format("Target dir '%s' is invalid.", plan.getTargetDir().getAbsolutePath()));
        }
        try {
            if (!plan.getFile().exists() || !StorageEngine.getInstance().unloadTsfile(plan.getFile(), plan.getTargetDir())) {
                throw new QueryProcessException(String.format("File '%s' doesn't exist.", plan.getFile().getAbsolutePath()));
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("unload file from %s ", plan.getFile().getAbsolutePath()), AuditLogOperation.DDL);
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot unload file '%s' to target directory '%s' because %s", plan.getFile().getAbsolutePath(), plan.getTargetDir().getPath(), e.getMessage()));
        }
    }

    private void operateTTL(SetTTLPlan plan) throws QueryProcessException {
        try {
            List<PartialPath> storageGroupPaths = IoTDB.metaManager.getMatchedStorageGroups(plan.getStorageGroup(), plan.isPrefixMatch());
            for (PartialPath storagePath : storageGroupPaths) {
                IoTDB.metaManager.setTTL(storagePath, plan.getDataTTL());
                StorageEngine.getInstance().setTTL(storagePath, plan.getDataTTL());
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    private void operateSetArchiving(SetArchivingPlan plan) throws QueryProcessException {
        if (plan.getTargetDir() == null) {
            boolean success = StorageEngine.getInstance().operateArchiving(ArchivingOperate.ArchivingOperateType.CANCEL, plan.getTaskId(), plan.getStorageGroup());
            if (!success) {
                throw new QueryProcessException("Fail to cancel archiving task.");
            }
        } else {
            List<PartialPath> storageGroupPaths;
            try {
                storageGroupPaths = IoTDB.metaManager.getMatchedStorageGroups(plan.getStorageGroup(), plan.isPrefixMatch());
            }
            catch (MetadataException e) {
                throw new QueryProcessException(e);
            }
            ArrayList<String> failedStorageGroups = new ArrayList<String>();
            for (PartialPath storagePath : storageGroupPaths) {
                boolean success = StorageEngine.getInstance().setArchiving(storagePath, plan.getTargetDir(), plan.getTTL(), plan.getStartTime());
                if (success) continue;
                failedStorageGroups.add(storagePath.getFullPath());
            }
            if (!failedStorageGroups.isEmpty()) {
                throw new QueryProcessException(String.format("Fail to set archiving tasks for %s", String.join((CharSequence)", ", failedStorageGroups)));
            }
        }
    }

    private void operatePauseArchiving(PauseArchivingPlan plan) throws QueryProcessException {
        boolean success = plan.isPause() ? StorageEngine.getInstance().operateArchiving(ArchivingOperate.ArchivingOperateType.PAUSE, plan.getTaskId(), plan.getStorageGroup()) : StorageEngine.getInstance().operateArchiving(ArchivingOperate.ArchivingOperateType.RESUME, plan.getTaskId(), plan.getStorageGroup());
        if (!success) {
            throw new QueryProcessException("Fail to operate archiving task.");
        }
    }

    @Override
    public void update(PartialPath path, long startTime, long endTime, String value) {
        throw new UnsupportedOperationException("update is not supported now");
    }

    @Override
    public void delete(PartialPath path, long startTime, long endTime, long planIndex, VirtualStorageGroupProcessor.TimePartitionFilter timePartitionFilter) throws QueryProcessException {
        try {
            StorageEngine.getInstance().delete(path, startTime, endTime, planIndex, timePartitionFilter);
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException(e);
        }
    }

    private void checkFailedMeasurments(InsertPlan plan) throws PathNotExistException, StorageEngineException {
        List<String> failedPaths = plan.getFailedMeasurements();
        List<Exception> exceptions = plan.getFailedExceptions();
        boolean isPathNotExistException = true;
        Iterator<Exception> iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            Exception e;
            Throwable curException = e = iterator.next();
            while (curException.getCause() != null) {
                curException = curException.getCause();
            }
            if (curException instanceof PathNotExistException) continue;
            isPathNotExistException = false;
            break;
        }
        if (isPathNotExistException) {
            throw new PathNotExistException(failedPaths);
        }
        throw new StorageEngineException(INSERT_MEASUREMENTS_FAILED_MESSAGE + plan.getFailedMeasurements() + (!exceptions.isEmpty() ? " caused by " + exceptions.get(0).getMessage() : ""));
    }

    @Override
    public void insert(InsertRowsOfOneDevicePlan insertRowsOfOneDevicePlan) throws QueryProcessException {
        if (insertRowsOfOneDevicePlan.getRowPlans().length == 0) {
            return;
        }
        try {
            StorageEngine.getInstance().insert(insertRowsOfOneDevicePlan);
            ArrayList<String> notExistedPaths = null;
            ArrayList<String> failedMeasurements = null;
            Throwable exception = null;
            for (InsertRowPlan plan : insertRowsOfOneDevicePlan.getRowPlans()) {
                if (plan.getFailedMeasurements() == null) continue;
                if (notExistedPaths == null) {
                    notExistedPaths = new ArrayList<String>();
                    failedMeasurements = new ArrayList<String>();
                }
                List<String> failedPaths = plan.getFailedMeasurements();
                List<Exception> exceptions = plan.getFailedExceptions();
                boolean isPathNotExistException = true;
                for (Exception e : exceptions) {
                    exception = e;
                    Throwable curException = e;
                    while (curException.getCause() != null) {
                        curException = curException.getCause();
                    }
                    if (curException instanceof PathNotExistException) continue;
                    isPathNotExistException = false;
                    break;
                }
                if (isPathNotExistException) {
                    notExistedPaths.addAll(failedPaths);
                    continue;
                }
                failedMeasurements.addAll(plan.getFailedMeasurements());
            }
            if (notExistedPaths != null && !notExistedPaths.isEmpty()) {
                throw new PathNotExistException((List<String>)notExistedPaths);
            }
            if (notExistedPaths != null && !failedMeasurements.isEmpty()) {
                throw new StorageEngineException("failed to insert points " + failedMeasurements + (exception != null ? " caused by " + exception.getMessage() : ""));
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    @Override
    public void insert(InsertRowsPlan plan) throws QueryProcessException {
        for (int i = 0; i < plan.getInsertRowPlanList().size(); ++i) {
            if (plan.getResults().containsKey(i) || plan.isExecuted(i)) continue;
            try {
                this.insert(plan.getInsertRowPlanList().get(i));
                continue;
            }
            catch (QueryProcessException e) {
                plan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!plan.getResults().isEmpty()) {
            throw new BatchProcessException(plan.getFailingStatus());
        }
    }

    @Override
    public void insert(InsertRowPlan insertRowPlan) throws QueryProcessException {
        try {
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            if (insertRowPlan.getDataTypes()[0] == null) {
                for (int i = 0; i < insertRowPlan.getDataTypes().length; ++i) {
                    insertRowPlan.getDataTypes()[i] = TypeInferenceUtils.getPredictedDataType(insertRowPlan.getValues()[i], insertRowPlan.isNeedInferType());
                }
            }
            if (!insertRowPlan.getDevicePath().getFullPath().startsWith("root.__system") && enableAuditLog) {
                AuditLogger.log(String.format("insert into %s , paths: %s,time: %s ", insertRowPlan.getDevicePath(), insertRowPlan.getPaths(), insertRowPlan.getTime()), AuditLogOperation.DML, insertRowPlan.isNativeInsertApi());
            }
            StorageEngine.getInstance().insert(insertRowPlan);
            if (insertRowPlan.getFailedMeasurements() != null) {
                this.checkFailedMeasurments(insertRowPlan);
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public void insertTablet(InsertMultiTabletPlan insertMultiTabletPlan) throws QueryProcessException {
        if (enableAuditLog) {
            AuditLogger.log(String.format("insert into %s,paths:%s,time start: %s,time end: %s ", insertMultiTabletPlan.getDevicePath(), insertMultiTabletPlan.getPaths(), insertMultiTabletPlan.getMinTime(), insertMultiTabletPlan.getMaxTime()), AuditLogOperation.DML, insertMultiTabletPlan.isNativeInsertApi());
        }
        if (insertMultiTabletPlan.isEnableMultiThreading()) {
            this.insertTabletParallel(insertMultiTabletPlan);
        } else {
            this.insertTabletSerial(insertMultiTabletPlan);
        }
    }

    private void insertTabletSerial(InsertMultiTabletPlan insertMultiTabletPlan) throws BatchProcessException {
        for (int i = 0; i < insertMultiTabletPlan.getInsertTabletPlanList().size(); ++i) {
            if (insertMultiTabletPlan.getResults().containsKey(i) || insertMultiTabletPlan.isExecuted(i)) continue;
            try {
                this.insertTablet(insertMultiTabletPlan.getInsertTabletPlanList().get(i));
                continue;
            }
            catch (QueryProcessException e) {
                insertMultiTabletPlan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!insertMultiTabletPlan.getResults().isEmpty()) {
            throw new BatchProcessException(insertMultiTabletPlan.getFailingStatus());
        }
    }

    private void insertTabletParallel(InsertMultiTabletPlan insertMultiTabletPlan) throws BatchProcessException {
        this.updateInsertTabletsPool(insertMultiTabletPlan.getDifferentStorageGroupsCount());
        List<InsertTabletPlan> planList = insertMultiTabletPlan.getInsertTabletPlanList();
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        Map<Integer, TSStatus> results = insertMultiTabletPlan.getResults();
        ArrayList<InsertTabletPlan> runPlanList = new ArrayList<InsertTabletPlan>();
        HashMap<Integer, Integer> runIndexToRealIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < planList.size(); ++i) {
            if (results.containsKey(i) || insertMultiTabletPlan.isExecuted(i)) continue;
            runPlanList.add(planList.get(i));
            runIndexToRealIndex.put(runPlanList.size() - 1, i);
        }
        for (InsertTabletPlan plan : runPlanList) {
            Future<Object> f = this.insertionPool.submit(() -> {
                this.insertTablet(plan);
                return null;
            });
            futureList.add(f);
        }
        for (int i = 0; i < futureList.size(); ++i) {
            try {
                ((Future)futureList.get(i)).get();
                continue;
            }
            catch (Exception e) {
                if (e.getCause() instanceof QueryProcessException) {
                    QueryProcessException qe = (QueryProcessException)e.getCause();
                    results.put((Integer)runIndexToRealIndex.get(i), RpcUtils.getStatus((int)qe.getErrorCode(), (String)qe.getMessage()));
                    continue;
                }
                results.put((Integer)runIndexToRealIndex.get(i), RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
            }
        }
        if (!results.isEmpty()) {
            throw new BatchProcessException(insertMultiTabletPlan.getFailingStatus());
        }
    }

    private void updateInsertTabletsPool(int sgSize) {
        int updateCoreSize = Math.min(sgSize, Runtime.getRuntime().availableProcessors() / 2);
        if (this.insertionPool == null || this.insertionPool.isTerminated()) {
            this.insertionPool = (ThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool(updateCoreSize, ThreadName.INSERTION_SERVICE.getName());
        } else if (this.insertionPool.getCorePoolSize() > updateCoreSize) {
            this.insertionPool.setCorePoolSize(updateCoreSize);
            this.insertionPool.setMaximumPoolSize(updateCoreSize);
        } else if (this.insertionPool.getCorePoolSize() < updateCoreSize) {
            this.insertionPool.setMaximumPoolSize(updateCoreSize);
            this.insertionPool.setCorePoolSize(updateCoreSize);
        }
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan) throws QueryProcessException {
        if (insertTabletPlan.getRowCount() == 0) {
            return;
        }
        try {
            insertTabletPlan.setMeasurementMNodes(new IMeasurementMNode[insertTabletPlan.getMeasurements().length]);
            if (enableAuditLog) {
                AuditLogger.log(String.format("insert into %s , paths: %s , time start: %s ,time end: %s ", insertTabletPlan.getDevicePath(), insertTabletPlan.getPaths(), insertTabletPlan.getTimes()[0], insertTabletPlan.getTimes()[insertTabletPlan.getTimes().length - 1]), AuditLogOperation.DML, insertTabletPlan.isNativeInsertApi());
            }
            StorageEngine.getInstance().insertTablet(insertTabletPlan);
            if (insertTabletPlan.getFailedMeasurements() != null) {
                this.checkFailedMeasurments(insertTabletPlan);
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private boolean operateAuthor(AuthorPlan author) throws QueryProcessException {
        AuthorOperator.AuthorType authorType = author.getAuthorType();
        String userName = author.getUserName();
        String roleName = author.getRoleName();
        String password = author.getPassword();
        String newPassword = author.getNewPassword();
        Set<Integer> permissions = author.getPermissions();
        PartialPath nodeName = author.getNodeName();
        try {
            switch (authorType) {
                case UPDATE_USER: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CREATE_USER: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CREATE_ROLE: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DROP_USER: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DROP_ROLE: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GRANT_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_USER: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_USER_ROLE: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case REVOKE_USER: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_USER_ROLE: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage(), true);
        }
        return true;
    }

    private boolean operateWatermarkEmbedding(List<String> users, boolean useWatermark) throws QueryProcessException {
        try {
            for (String user : users) {
                this.authorizer.setUserUseWaterMark(user, useWatermark);
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean createTimeSeries(CreateTimeSeriesPlan createTimeSeriesPlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.createTimeseries(createTimeSeriesPlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create time series %s", createTimeSeriesPlan.getPaths()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean createAlignedTimeSeries(CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create aligned time series %s", createAlignedTimeSeriesPlan.getPaths()), AuditLogOperation.DDL);
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean createMultiTimeSeries(CreateMultiTimeSeriesPlan multiPlan) throws BatchProcessException {
        int dataTypeIdx = 0;
        for (int i = 0; i < multiPlan.getPaths().size(); ++i) {
            if (multiPlan.getResults().containsKey(i) || multiPlan.isExecuted(i)) continue;
            PartialPath path = multiPlan.getPaths().get(i);
            String measurement = path.getMeasurement();
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(multiPlan.getPaths().get(i), multiPlan.getDataTypes().get(i), multiPlan.getEncodings().get(i), multiPlan.getCompressors().get(i), multiPlan.getProps() == null ? null : multiPlan.getProps().get(i), multiPlan.getTags() == null ? null : multiPlan.getTags().get(i), multiPlan.getAttributes() == null ? null : multiPlan.getAttributes().get(i), multiPlan.getAlias() == null ? null : multiPlan.getAlias().get(i));
            ++dataTypeIdx;
            try {
                this.createTimeSeries(plan);
                continue;
            }
            catch (QueryProcessException e) {
                multiPlan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!multiPlan.getResults().isEmpty()) {
            throw new BatchProcessException(multiPlan.getFailingStatus());
        }
        return true;
    }

    protected boolean deleteTimeSeries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws QueryProcessException {
        if (enableAuditLog) {
            AuditLogger.log(String.format("delete time series %s", deleteTimeSeriesPlan.getPaths()), AuditLogOperation.DDL);
        }
        List<PartialPath> deletePathList = deleteTimeSeriesPlan.getPaths();
        for (int i = 0; i < deletePathList.size(); ++i) {
            PartialPath path = deletePathList.get(i);
            try {
                String failed;
                StorageEngine.getInstance().deleteTimeseries(path, deleteTimeSeriesPlan.getIndex(), deleteTimeSeriesPlan.getPartitionFilter());
                if (deleteTimeSeriesPlan.isPrefixMatch()) {
                    StorageEngine.getInstance().deleteTimeseries(path.concatNode("**"), deleteTimeSeriesPlan.getIndex(), deleteTimeSeriesPlan.getPartitionFilter());
                }
                if ((failed = IoTDB.metaManager.deleteTimeseries(path, deleteTimeSeriesPlan.isPrefixMatch())) == null) continue;
                deleteTimeSeriesPlan.getResults().put(i, RpcUtils.getStatus((TSStatusCode)TSStatusCode.NODE_DELETE_FAILED_ERROR, (String)failed));
                continue;
            }
            catch (StorageEngineException | MetadataException e) {
                deleteTimeSeriesPlan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!deleteTimeSeriesPlan.getResults().isEmpty()) {
            throw new BatchProcessException(deleteTimeSeriesPlan.getFailingStatus());
        }
        return true;
    }

    private boolean alterTimeSeries(AlterTimeSeriesPlan alterTimeSeriesPlan) throws QueryProcessException {
        PartialPath path = alterTimeSeriesPlan.getPath();
        Map<String, String> alterMap = alterTimeSeriesPlan.getAlterMap();
        if (enableAuditLog) {
            AuditLogger.log(String.format("alter time series %s,alter type:%s", new Object[]{alterTimeSeriesPlan.getPaths(), alterTimeSeriesPlan.getAlterType()}), AuditLogOperation.DDL);
        }
        try {
            switch (alterTimeSeriesPlan.getAlterType()) {
                case RENAME: {
                    String beforeName = alterMap.keySet().iterator().next();
                    String currentName = alterMap.get(beforeName);
                    IoTDB.metaManager.renameTagOrAttributeKey(beforeName, currentName, path);
                    break;
                }
                case SET: {
                    IoTDB.metaManager.setTagsOrAttributesValue(alterMap, path);
                    break;
                }
                case DROP: {
                    IoTDB.metaManager.dropTagsOrAttributes(alterMap.keySet(), path);
                    break;
                }
                case ADD_TAGS: {
                    IoTDB.metaManager.addTags(alterMap, path);
                    break;
                }
                case ADD_ATTRIBUTES: {
                    IoTDB.metaManager.addAttributes(alterMap, path);
                    break;
                }
                case UPSERT: {
                    IoTDB.metaManager.upsertTagsAndAttributes(alterTimeSeriesPlan.getAlias(), alterTimeSeriesPlan.getTagsMap(), alterTimeSeriesPlan.getAttributesMap(), path);
                }
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(String.format("Something went wrong while read/write the [%s]'s tag/attribute info.", path.getFullPath()));
        }
        return true;
    }

    public boolean setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) throws QueryProcessException {
        if (enableAuditLog) {
            AuditLogger.log(String.format("set storage group to %s", setStorageGroupPlan.getPaths()), AuditLogOperation.DDL);
        }
        PartialPath path = setStorageGroupPlan.getPath();
        try {
            IoTDB.metaManager.setStorageGroup(path);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected boolean deleteStorageGroups(DeleteStorageGroupPlan deleteStorageGroupPlan) throws QueryProcessException {
        if (enableAuditLog) {
            AuditLogger.log(String.format("set storage group to %s", deleteStorageGroupPlan.getPaths()), AuditLogOperation.DDL);
        }
        ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
        try {
            for (PartialPath storageGroupPath : deleteStorageGroupPlan.getPaths()) {
                List<PartialPath> allRelatedStorageGroupPath = IoTDB.metaManager.getMatchedStorageGroups(storageGroupPath, deleteStorageGroupPlan.isPrefixMatch());
                if (allRelatedStorageGroupPath.isEmpty()) {
                    throw new PathNotExistException(storageGroupPath.getFullPath(), true);
                }
                for (PartialPath path : allRelatedStorageGroupPath) {
                    StorageEngine.getInstance().deleteStorageGroup(path);
                    deletePathList.add(path);
                }
            }
            IoTDB.metaManager.deleteStorageGroups(deletePathList);
            PlanExecutor.operateClearCache();
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected QueryDataSet processAuthorQuery(AuthorPlan plan) throws QueryProcessException {
        ListDataSet dataSet;
        AuthorOperator.AuthorType authorType = plan.getAuthorType();
        String userName = plan.getUserName();
        String roleName = plan.getRoleName();
        PartialPath path = plan.getNodeName();
        try {
            switch (authorType) {
                case LIST_ROLE: {
                    dataSet = this.executeListRole(plan);
                    break;
                }
                case LIST_USER: {
                    dataSet = this.executeListUser(plan);
                    break;
                }
                case LIST_ROLE_USERS: {
                    dataSet = this.executeListRoleUsers(roleName);
                    break;
                }
                case LIST_USER_ROLES: {
                    dataSet = this.executeListUserRoles(userName);
                    break;
                }
                case LIST_ROLE_PRIVILEGE: {
                    dataSet = this.executeListRolePrivileges(roleName, path);
                    break;
                }
                case LIST_USER_PRIVILEGE: {
                    dataSet = this.executeListUserPrivileges(userName, path);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return dataSet;
    }

    private ListDataSet executeListRole(AuthorPlan plan) throws AuthException {
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("role", false)), Collections.singletonList(TSDataType.TEXT));
        boolean hasListRolePrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.emptyList(), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListRolePrivilege) {
            return dataSet;
        }
        List<String> roleList = this.authorizer.listAllRoles();
        this.addToDataSet(roleList, dataSet);
        return dataSet;
    }

    private void addToDataSet(List<String> strResults, ListDataSet dataSet) {
        int index = 0;
        for (String role : strResults) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(role));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private ListDataSet executeListUser(AuthorPlan plan) throws AuthException {
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("user", false)), Collections.singletonList(TSDataType.TEXT));
        boolean hasListUserPrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.singletonList(plan.getNodeName()), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListUserPrivilege) {
            return dataSet;
        }
        List<String> userList = this.authorizer.listAllUsers();
        this.addToDataSet(userList, dataSet);
        return dataSet;
    }

    private ListDataSet executeListRoleUsers(String roleName) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role == null) {
            throw new AuthException("No such role : " + roleName);
        }
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("user", false)), Collections.singletonList(TSDataType.TEXT));
        List<String> userList = this.authorizer.listAllUsers();
        int index = 0;
        for (String userN : userList) {
            User userObj = this.authorizer.getUser(userN);
            if (userObj == null || !userObj.hasRole(roleName)) continue;
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(userN));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUserRoles(String userName) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user != null) {
            ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("role", false)), Collections.singletonList(TSDataType.TEXT));
            int index = 0;
            for (String roleN : user.getRoleList()) {
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(roleN));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such user : " + userName);
    }

    private ListDataSet executeListRolePrivileges(String roleName, PartialPath path) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role != null) {
            ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new PartialPath("privilege", false));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such role : " + roleName);
    }

    private ListDataSet executeListUserPrivileges(String userName, PartialPath path) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user == null) {
            throw new AuthException("No such user : " + userName);
        }
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        int index = 0;
        if (IoTDBDescriptor.getInstance().getConfig().getAdminName().equals(userName)) {
            headerList.add(new PartialPath("privilege", false));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                RowRecord record = new RowRecord((long)index++);
                Field privilegeF = new Field(TSDataType.TEXT);
                privilegeF.setBinaryV(new Binary(privilegeType.toString()));
                record.addField(privilegeF);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        headerList.add(new PartialPath("role", false));
        headerList.add(new PartialPath("privilege", false));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
            if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
            RowRecord record = new RowRecord((long)index++);
            Field roleF = new Field(TSDataType.TEXT);
            roleF.setBinaryV(new Binary(""));
            record.addField(roleF);
            Field privilegeF = new Field(TSDataType.TEXT);
            privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
            record.addField(privilegeF);
            dataSet.putRecord(record);
        }
        for (String roleN : user.getRoleList()) {
            Role role = this.authorizer.getRole(roleN);
            if (role == null) continue;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field roleF = new Field(TSDataType.TEXT);
                roleF.setBinaryV(new Binary(roleN));
                record.addField(roleF);
                Field privilegeF = new Field(TSDataType.TEXT);
                privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(privilegeF);
                dataSet.putRecord(record);
            }
        }
        return dataSet;
    }

    protected void loadConfiguration(LoadConfigurationPlan plan) throws QueryProcessException {
        IoTDBDescriptor.getInstance().loadHotModifiedProps();
    }

    private boolean processShowQueryResource() {
        DEBUG_LOGGER.info(String.format("**********%s**********\n\n", new Date()));
        FileReaderManager.getInstance().writeFileReferenceInfo();
        QueryResourceManager.getInstance().writeQueryFileInfo();
        DEBUG_LOGGER.info("\n****************************************************\n\n");
        return true;
    }

    private QueryDataSet processShowQueryProcesslist() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("queryId", false), new PartialPath("statement", false)), Arrays.asList(TSDataType.INT64, TSDataType.TEXT));
        QueryTimeManager queryTimeManager = QueryTimeManager.getInstance();
        for (Map.Entry<Long, QueryContext> context : queryTimeManager.getQueryContextMap().entrySet()) {
            RowRecord record = new RowRecord(context.getValue().getStartTime());
            record.addField((Object)context.getKey(), TSDataType.INT64);
            record.addField((Object)new Binary(context.getValue().getStatement()), TSDataType.TEXT);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (IoTDB.metaManager.isStorageGroup(storageGroup)) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }

    private void settle(SettlePlan plan) throws StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support file settle");
        }
        if (!SettleService.getINSTANCE().isRecoverFinish()) {
            throw new StorageEngineException("Existing sg that is not ready, please try later.");
        }
        PartialPath sgPath = null;
        try {
            ArrayList<TsFileResource> seqResourcesToBeSettled = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unseqResourcesToBeSettled = new ArrayList<TsFileResource>();
            ArrayList<String> tsFilePaths = new ArrayList<String>();
            if (plan.isSgPath()) {
                sgPath = plan.getSgPath();
            } else {
                String tsFilePath = plan.getTsFilePath();
                if (new File(tsFilePath).isDirectory()) {
                    throw new WriteProcessException("The file should not be a directory.");
                }
                if (!new File(tsFilePath).exists()) {
                    throw new WriteProcessException("The tsFile " + tsFilePath + " is not existed.");
                }
                sgPath = SettleService.getINSTANCE().getSGByFilePath(tsFilePath);
                tsFilePaths.add(tsFilePath);
            }
            StorageEngine.getInstance().getResourcesToBeSettled(sgPath, seqResourcesToBeSettled, unseqResourcesToBeSettled, tsFilePaths);
            SettleService.getINSTANCE().startSettling(seqResourcesToBeSettled, unseqResourcesToBeSettled);
            StorageEngine.getInstance().setSettling(sgPath, false);
        }
        catch (WriteProcessException e) {
            if (sgPath != null) {
                StorageEngine.getInstance().setSettling(sgPath, false);
            }
            throw new StorageEngineException(e.getMessage());
        }
    }
}

