/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.path.PartialPath;

public abstract class StorageGroupCollector<T>
extends CollectorTraverser<T> {
    protected boolean collectInternal = false;

    public StorageGroupCollector(IMNode startNode, PartialPath path) throws MetadataException {
        super(startNode, path);
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        if (node.isStorageGroup()) {
            if (this.collectInternal) {
                this.collectStorageGroup(node.getAsStorageGroupMNode());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        if (node.isStorageGroup()) {
            this.collectStorageGroup(node.getAsStorageGroupMNode());
            return true;
        }
        return false;
    }

    protected abstract void collectStorageGroup(IStorageGroupMNode var1);

    public void setCollectInternal(boolean collectInternal) {
        this.collectInternal = collectInternal;
    }
}

