/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.cache;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.common.cache.Cache;

public abstract class LRUCache<K, T>
implements Cache<K, T> {
    protected Map<K, T> cache;

    public LRUCache(final int cacheSize) {
        this.cache = new LinkedHashMap<K, T>(cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    @Override
    public synchronized T get(K key) throws IOException {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        T value = this.loadObjectByKey(key);
        if (value != null) {
            this.cache.put(key, value);
        }
        return value;
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized void put(K key, T value) {
        this.cache.put(key, value);
    }

    protected abstract T loadObjectByKey(K var1) throws IOException;

    public synchronized void removeItem(K key) {
        this.cache.remove(key);
    }
}

