/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestLogRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridLogCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.LOG);
    private static final int DEFAULT_FROM = 0;
    private static final int DEFAULT_TO = 1;

    public GridLogCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        File logFile;
        int to;
        int from;
        GridRestLogRequest req0;
        assert (req != null);
        if (req.command() != GridRestCommand.LOG) return new GridFinishedFuture<GridRestResponse>();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling log REST request: " + req);
        }
        if ((req0 = (GridRestLogRequest)req).from() < -1 || req0.to() < -1) {
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "One of the request parameters is invalid [from=" + req0.from() + ", to=" + req0.to() + "]"));
        }
        if (req0.from() != -1) {
            if (req0.to() == -1) {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Request parameter 'to' is not set."));
            }
            from = req0.from();
        } else {
            from = 0;
        }
        if (req0.to() != -1) {
            if (req0.from() == -1) {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Request parameter 'from' is not set."));
            }
            to = req0.to();
        } else {
            to = 1;
        }
        if (from >= to) {
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Request parameter 'from' must be less than 'to'."));
        }
        try {
            if (req0.path() != null) {
                if (this.log.fileName() != null) {
                    if (!req0.path().equals(this.log.fileName())) {
                        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Request parameter 'path' must contain a path to valid log file."));
                    }
                    logFile = new File(req0.path());
                } else {
                    if (!req0.path().startsWith(this.ctx.config().getIgniteHome())) return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Request parameter 'path' must contain a path to valid log file."));
                    logFile = new File(req0.path());
                }
            } else {
                logFile = this.log.fileName() == null ? new File(this.ctx.config().getIgniteHome() + "/work/log/ignite.log") : new File(this.log.fileName());
            }
        }
        catch (InvalidPathException e) {
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Incorrect path to a log file [msg=" + e.getMessage() + "]"));
        }
        try {
            String content = this.readLog(from, to, logFile);
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(content));
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, e.getMessage()));
        }
    }

    private String readLog(int from, int to, File logFile) throws IgniteCheckedException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line;
            for (int start = 0; start <= to && (line = reader.readLine()) != null; ++start) {
                if (start < from) continue;
                content.append(line);
            }
            if (content.length() == 0) {
                throw new IgniteCheckedException("Request parameter 'from' and 'to' are for lines that do not exist in log file.");
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
        return content.toString();
    }
}

