/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

class PlatformLock
extends PlatformAbstractTarget {
    private static final int OP_LOCK = 1;
    private static final int OP_TRY_LOCK = 2;
    private static final int OP_UNLOCK = 3;
    private static final int OP_REMOVE = 4;
    private static final int OP_IS_BROKEN = 5;
    private static final int OP_IS_LOCKED = 6;
    private static final int OP_IS_REMOVED = 7;
    private final IgniteLock lock;

    PlatformLock(PlatformContext ctx, IgniteLock lock) {
        super(ctx);
        this.lock = lock;
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                this.lock.lock();
                return 1L;
            }
            case 2: {
                boolean locked = val < 0L ? this.lock.tryLock() : this.lock.tryLock(val, TimeUnit.MILLISECONDS);
                return locked ? 1L : 0L;
            }
            case 3: {
                this.lock.unlock();
                return 1L;
            }
            case 4: {
                this.lock.close();
                return 1L;
            }
            case 5: {
                return this.lock.isBroken() ? 1L : 0L;
            }
            case 6: {
                return this.lock.isLocked() ? 1L : 0L;
            }
            case 7: {
                return this.lock.removed() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }
}

