/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.DumpBytecodeVisitor;
import com.facebook.presto.bytecode.ParameterizedType;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public final class BytecodeUtils {
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class);

    private BytecodeUtils() {
    }

    public static ParameterizedType makeClassName(String baseName, Optional<String> suffix) {
        String className = baseName + "_" + suffix.orElseGet(() -> Instant.now().atZone(ZoneOffset.UTC).format(TIMESTAMP_FORMAT)) + "_" + CLASS_ID.incrementAndGet();
        String javaClassName = BytecodeUtils.toJavaIdentifierString(className);
        return ParameterizedType.typeFromJavaClassName("com.facebook.presto.$gen." + javaClassName);
    }

    public static ParameterizedType makeClassName(String baseName) {
        return BytecodeUtils.makeClassName(baseName, Optional.empty());
    }

    public static String toJavaIdentifierString(String className) {
        return className.codePoints().mapToObj(c -> Character.isJavaIdentifierPart(c) ? c : 95).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String dumpBytecodeTree(ClassDefinition classDefinition) {
        StringWriter writer = new StringWriter();
        new DumpBytecodeVisitor(writer).visitClass(classDefinition);
        return writer.toString();
    }

    public static void checkArgument(boolean condition, String errMsg, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errMsg, params));
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }

    public static String repeat(String string, int count) {
        int n;
        Objects.requireNonNull(string);
        if (count <= 1) {
            BytecodeUtils.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }
}

