/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.yaml;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

@Internal
final class ConstructIsoTimestampString
extends AbstractConstruct {
    private static final Pattern TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:(Z)|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
    private static final Pattern YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");

    ConstructIsoTimestampString() {
    }

    public Object construct(Node node) {
        ScalarNode scalar = (ScalarNode)node;
        String nodeValue = scalar.getValue();
        return ConstructIsoTimestampString.parse(nodeValue);
    }

    @NonNull
    static Temporal parse(String nodeValue) {
        Matcher match = YMD_REGEXP.matcher(nodeValue);
        if (match.matches()) {
            String yearS = match.group(1);
            String monthS = match.group(2);
            String dayS = match.group(3);
            return LocalDate.of(Integer.parseInt(yearS), Integer.parseInt(monthS), Integer.parseInt(dayS));
        }
        match = TIMESTAMP_REGEXP.matcher(nodeValue);
        if (!match.matches()) {
            throw new YAMLException("Unexpected timestamp: " + nodeValue);
        }
        String yearS = match.group(1);
        String monthS = match.group(2);
        String dayS = match.group(3);
        String hourS = match.group(4);
        String minS = match.group(5);
        String seconds = match.group(6);
        String millis = match.group(7);
        if (millis != null) {
            seconds = seconds + "." + millis;
        }
        double fractions = Double.parseDouble(seconds);
        int secS = (int)Math.round(Math.floor(fractions));
        int nsec = (int)Math.round((fractions - (double)secS) * 1.0E9);
        LocalDateTime ldt = LocalDateTime.of(Integer.parseInt(yearS), Integer.parseInt(monthS), Integer.parseInt(dayS), Integer.parseInt(hourS), Integer.parseInt(minS), secS, nsec);
        String timezonehS = match.group(9);
        String timezonemS = match.group(10);
        if (timezonehS != null) {
            ZoneOffset offset = timezonemS == null ? ZoneOffset.ofHours(Integer.parseInt(timezonehS)) : ZoneOffset.ofHoursMinutes(Integer.parseInt(timezonehS), Integer.parseInt(timezonemS));
            return ldt.atOffset(offset);
        }
        if (match.group(8) != null) {
            return ldt.atOffset(ZoneOffset.UTC);
        }
        return ldt;
    }
}

