/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicaRequestBuilder;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicaRequestSerializer;

public class WriteIntentSwitchReplicaRequestImpl
implements WriteIntentSwitchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private WriteIntentSwitchReplicaRequestImpl(boolean commit, HybridTimestamp commitTimestamp, ReplicationGroupIdMessage groupId, HybridTimestamp timestamp, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.groupId = groupId;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return WriteIntentSwitchReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(WriteIntentSwitchReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteIntentSwitchReplicaRequestImpl otherMessage = (WriteIntentSwitchReplicaRequestImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.commitTimestamp, this.groupId, this.timestamp, this.txId);
        return result;
    }

    public WriteIntentSwitchReplicaRequestImpl clone() {
        try {
            return (WriteIntentSwitchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static WriteIntentSwitchReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements WriteIntentSwitchReplicaRequestBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private ReplicationGroupIdMessage groupId;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public WriteIntentSwitchReplicaRequest build() {
            return new WriteIntentSwitchReplicaRequestImpl(this.commit, this.commitTimestamp, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

