/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessage;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessagesFactory;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverReplicaMessage;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.LeaderElectionListener;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.client.TopologyAwareRaftGroupService;
import org.apache.ignite.internal.replicator.Member;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicaResult;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.apache.ignite.network.ClusterNode;

public class ReplicaImpl
implements Replica {
    private static final IgniteLogger LOG = Loggers.forClass(ReplicaManager.class);
    private static final PlacementDriverMessagesFactory PLACEMENT_DRIVER_MESSAGES_FACTORY = new PlacementDriverMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final ReplicationGroupId replicaGrpId;
    private final ReplicaListener listener;
    private final PendingComparableValuesTracker<Long, Void> storageIndexTracker;
    private final TopologyAwareRaftGroupService raftClient;
    private final ClusterNode localNode;
    private final CompletableFuture<AtomicReference<ClusterNode>> leaderFuture = new CompletableFuture();
    private final AtomicReference<ClusterNode> leaderRef = new AtomicReference();
    private volatile HybridTimestamp leaseExpirationTime;
    private final ExecutorService executor;
    private final PlacementDriver placementDriver;
    private final ClockService clockService;
    private final BiFunction<ReplicationGroupId, HybridTimestamp, Boolean> replicaReservationClosure;
    private final Function<ReplicationGroupId, CompletableFuture<byte[]>> getPendingAssignmentsSupplier;
    private LeaderElectionListener onLeaderElectedFailoverCallback;
    private final FailureManager failureManager;

    public ReplicaImpl(ReplicationGroupId replicaGrpId, ReplicaListener listener, PendingComparableValuesTracker<Long, Void> storageIndexTracker, ClusterNode localNode, ExecutorService executor, PlacementDriver placementDriver, ClockService clockService, BiFunction<ReplicationGroupId, HybridTimestamp, Boolean> replicaReservationClosure, Function<ReplicationGroupId, CompletableFuture<byte[]>> getPendingAssignmentsSupplier, FailureManager failureManager) {
        this.replicaGrpId = replicaGrpId;
        this.listener = listener;
        this.storageIndexTracker = storageIndexTracker;
        this.raftClient = this.raftClient();
        this.localNode = localNode;
        this.executor = executor;
        this.placementDriver = placementDriver;
        this.clockService = clockService;
        this.replicaReservationClosure = replicaReservationClosure;
        this.getPendingAssignmentsSupplier = getPendingAssignmentsSupplier;
        this.failureManager = failureManager;
        this.raftClient.subscribeLeader(this::onLeaderElected);
        placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this::registerFailoverCallback);
        placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this::unregisterFailoverCallback);
    }

    @Override
    public ReplicaListener listener() {
        return this.listener;
    }

    @Override
    public final TopologyAwareRaftGroupService raftClient() {
        return (TopologyAwareRaftGroupService)this.listener.raftClient();
    }

    @Override
    public CompletableFuture<ReplicaResult> processRequest(ReplicaRequest request, UUID senderId) {
        assert (this.replicaGrpId.equals((Object)request.groupId().asReplicationGroupId())) : IgniteStringFormatter.format((String)"Partition mismatch: request does not match the replica [reqReplicaGrpId={}, replicaGrpId={}]", (Object[])new Object[]{request.groupId(), this.replicaGrpId});
        return this.listener.invoke(request, senderId);
    }

    @Override
    public ReplicationGroupId groupId() {
        return this.replicaGrpId;
    }

    private void onLeaderElected(ClusterNode clusterNode, long term) {
        this.leaderRef.set(clusterNode);
        if (!this.leaderFuture.isDone()) {
            this.leaderFuture.complete(this.leaderRef);
        }
    }

    private CompletableFuture<ClusterNode> leaderFuture() {
        return this.leaderFuture.thenApply(AtomicReference::get);
    }

    @Override
    public CompletableFuture<? extends NetworkMessage> processPlacementDriverMessage(PlacementDriverReplicaMessage msg) {
        if (msg instanceof LeaseGrantedMessage) {
            return this.processLeaseGrantedMessage((LeaseGrantedMessage)msg).handle((v, e) -> {
                if (e != null) {
                    Throwable ex = ExceptionUtils.unwrapCause((Throwable)e);
                    if (!(ex instanceof NodeStoppingException) && !(ex instanceof TrackerClosedException)) {
                        LOG.warn("Failed to process the lease granted message [msg={}].", ex, new Object[]{msg});
                    }
                    return PLACEMENT_DRIVER_MESSAGES_FACTORY.leaseGrantedMessageResponse().accepted(false).build();
                }
                return v;
            });
        }
        return CompletableFuture.failedFuture((Throwable)((Object)new AssertionError((Object)("Unknown message type, msg=" + String.valueOf(msg)))));
    }

    private CompletableFuture<LeaseGrantedMessageResponse> processLeaseGrantedMessage(LeaseGrantedMessage msg) {
        LOG.info("Received LeaseGrantedMessage for replica [groupId={}, leaseStartTime={}, force={}].", new Object[]{this.groupId(), msg.leaseStartTime(), msg.force()});
        return this.placementDriver.previousPrimaryExpired(this.groupId()).thenCompose(unused -> this.leaderFuture().thenCompose(leader -> {
            HybridTimestamp leaseExpirationTime = this.leaseExpirationTime;
            if (leaseExpirationTime != null) assert (this.clockService.after(msg.leaseExpirationTime(), leaseExpirationTime)) : "Invalid lease expiration time in message, msg=" + String.valueOf(msg);
            if (msg.force()) {
                return ((CompletableFuture)this.waitForActualState(msg.leaseStartTime(), msg.leaseExpirationTime().getPhysical()).thenCompose(v -> this.sendPrimaryReplicaChangeToReplicationGroup(msg.leaseStartTime().longValue(), this.localNode.id(), this.localNode.name()))).thenCompose(v -> {
                    CompletableFuture<LeaseGrantedMessageResponse> respFut = this.acceptLease(msg.leaseStartTime(), msg.leaseExpirationTime());
                    if (leader.equals((Object)this.localNode)) {
                        return respFut;
                    }
                    return this.raftClient.transferLeadership(new Peer(this.localNode.name())).thenCompose(ignored -> respFut);
                });
            }
            if (leader.equals((Object)this.localNode)) {
                return ((CompletableFuture)this.waitForActualState(msg.leaseStartTime(), msg.leaseExpirationTime().getPhysical()).thenCompose(v -> this.sendPrimaryReplicaChangeToReplicationGroup(msg.leaseStartTime().longValue(), this.localNode.id(), this.localNode.name()))).thenCompose(v -> this.acceptLease(msg.leaseStartTime(), msg.leaseExpirationTime()));
            }
            return this.proposeLeaseRedirect((ClusterNode)leader);
        }));
    }

    private CompletableFuture<Void> sendPrimaryReplicaChangeToReplicationGroup(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        PrimaryReplicaChangeCommand cmd = REPLICA_MESSAGES_FACTORY.primaryReplicaChangeCommand().leaseStartTime(leaseStartTime).primaryReplicaNodeId(primaryReplicaNodeId).primaryReplicaNodeName(primaryReplicaNodeName).build();
        return this.raftClient.run((Command)cmd);
    }

    private CompletableFuture<LeaseGrantedMessageResponse> acceptLease(HybridTimestamp leaseStartTime, HybridTimestamp leaseExpirationTime) {
        LOG.info("Lease accepted [group=" + String.valueOf(this.groupId()) + ", leaseStartTime=" + String.valueOf(leaseStartTime) + "].", new Object[0]);
        this.leaseExpirationTime = leaseExpirationTime;
        LeaseGrantedMessageResponse resp = PLACEMENT_DRIVER_MESSAGES_FACTORY.leaseGrantedMessageResponse().accepted(true).build();
        return CompletableFuture.completedFuture(resp);
    }

    private CompletableFuture<LeaseGrantedMessageResponse> proposeLeaseRedirect(ClusterNode groupLeader) {
        LOG.info("Proposing lease redirection [groupId={}, proposed node={}].", new Object[]{this.groupId(), groupLeader});
        LeaseGrantedMessageResponse resp = PLACEMENT_DRIVER_MESSAGES_FACTORY.leaseGrantedMessageResponse().accepted(false).redirectProposal(groupLeader.name()).build();
        return CompletableFuture.completedFuture(resp);
    }

    private CompletableFuture<Void> waitForActualState(HybridTimestamp startTime, long expirationTime) {
        LOG.info("Waiting for actual storage state, group=" + String.valueOf(this.groupId()), new Object[0]);
        if (!this.replicaReservationClosure.apply(this.groupId(), startTime).booleanValue()) {
            throw new IllegalStateException("Replica reservation failed [groupId=" + String.valueOf(this.groupId()) + ", leaseStartTime=" + String.valueOf(startTime) + "].");
        }
        long timeout = expirationTime - System.currentTimeMillis();
        if (timeout <= 0L) {
            return CompletableFuture.failedFuture(new TimeoutException());
        }
        return IgniteUtils.retryOperationUntilSuccess(this.raftClient::readIndex, e -> System.currentTimeMillis() > expirationTime, (Executor)this.executor).orTimeout(timeout, TimeUnit.MILLISECONDS).thenCompose(arg_0 -> this.storageIndexTracker.waitFor(arg_0));
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        this.placementDriver.removeListener((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this::registerFailoverCallback);
        this.placementDriver.removeListener((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this::unregisterFailoverCallback);
        this.listener.onShutdown();
        return this.raftClient.unsubscribeLeader().thenAccept(v -> this.raftClient.shutdown());
    }

    @Override
    public void updatePeersAndLearners(PeersAndLearners peersAndLearners) {
        this.raftClient.updateConfiguration(peersAndLearners);
    }

    @Override
    public CompletableFuture<Void> createSnapshotOn(Member targetMember) {
        Peer peer = targetMember.isVotingMember() ? new Peer(targetMember.consistentId(), 0) : new Peer(targetMember.consistentId(), 1);
        return this.raftClient.snapshot(peer);
    }

    @Override
    public CompletableFuture<Void> transferLeadershipTo(String targetConsistentId) {
        return this.raftClient.transferLeadership(new Peer(targetConsistentId));
    }

    private CompletableFuture<Boolean> registerFailoverCallback(PrimaryReplicaEventParameters parameters) {
        if (!parameters.leaseholderId().equals(this.localNode.id()) || !this.replicaGrpId.equals((Object)parameters.groupId())) {
            return CompletableFutures.falseCompletedFuture();
        }
        assert (this.onLeaderElectedFailoverCallback == null) : IgniteStringFormatter.format((String)"We already have failover subscription [thisGrpId={}, thisNode={}, givenExpiredPrimaryId={}, givenExpiredPrimaryNode={}", (Object[])new Object[]{this.replicaGrpId, this.localNode.name(), parameters.groupId(), parameters.leaseholder()});
        this.onLeaderElectedFailoverCallback = (leaderNode, term) -> this.changePeersAndLearnersAsyncIfPendingExists(term);
        return ((CompletableFuture)this.raftClient.subscribeLeader(this.onLeaderElectedFailoverCallback).exceptionally(e -> {
            LOG.error("Rebalance failover subscription on elected primary replica failed [groupId=" + String.valueOf(this.replicaGrpId) + "].", e);
            this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            return null;
        })).thenApply(v -> false);
    }

    private void changePeersAndLearnersAsyncIfPendingExists(long term) {
        ((CompletableFuture)((CompletableFuture)this.getPendingAssignmentsSupplier.apply(this.replicaGrpId).exceptionally(e -> {
            LOG.error("Couldn't fetch pending assignments for rebalance failover [groupId={}, term={}].", e, new Object[]{this.replicaGrpId, term});
            return null;
        })).thenCompose(pendingsBytes -> {
            if (pendingsBytes == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            PeersAndLearners newConfiguration = PeersAndLearners.fromAssignments((Collection)Assignments.fromBytes((byte[])pendingsBytes).nodes());
            LOG.info("New leader elected. Going to apply new configuration [tablePartitionId={}, peers={}, learners={}]", new Object[]{this.replicaGrpId, newConfiguration.peers(), newConfiguration.learners()});
            return this.raftClient.changePeersAndLearnersAsync(newConfiguration, term);
        })).exceptionally(e -> {
            LOG.error("Failover ChangePeersAndLearners failed [groupId={}, term={}].", e, new Object[]{this.replicaGrpId, term});
            return null;
        });
    }

    private CompletableFuture<Boolean> unregisterFailoverCallback(PrimaryReplicaEventParameters parameters) {
        if (!parameters.leaseholderId().equals(this.localNode.id()) || !this.replicaGrpId.equals((Object)parameters.groupId())) {
            return CompletableFutures.falseCompletedFuture();
        }
        if (this.onLeaderElectedFailoverCallback == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        assert (this.onLeaderElectedFailoverCallback != null) : IgniteStringFormatter.format((String)"We have no failover subscription [thisGrpId={}, thisNode={}, givenExpiredPrimaryId={}, givenExpiredPrimaryNode={}", (Object[])new Object[]{this.replicaGrpId, this.localNode.name(), parameters.groupId(), parameters.leaseholder()});
        this.raftClient.unsubscribeLeader(this.onLeaderElectedFailoverCallback);
        this.onLeaderElectedFailoverCallback = null;
        return CompletableFutures.falseCompletedFuture();
    }
}

