/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.task.MapReduceTask;
import org.apache.ignite.compute.task.TaskExecutionContext;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.internal.compute.loader.JobClassLoader;
import org.apache.ignite.internal.compute.message.DeploymentUnitMsg;
import org.apache.ignite.internal.compute.message.ExecuteResponse;
import org.apache.ignite.internal.compute.message.JobCancelResponse;
import org.apache.ignite.internal.compute.message.JobChangePriorityResponse;
import org.apache.ignite.internal.compute.message.JobResultResponse;
import org.apache.ignite.internal.compute.message.JobStateResponse;
import org.apache.ignite.internal.compute.message.JobStatesResponse;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.DataStreamerReceiver;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class ComputeUtils {
    private static final ComputeMessagesFactory MESSAGES_FACTORY = new ComputeMessagesFactory();

    public static <T, R> ComputeJob<T, R> instantiateJob(Class<? extends ComputeJob<T, R>> computeJobClass) {
        if (!ComputeJob.class.isAssignableFrom(computeJobClass)) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "'" + computeJobClass.getName() + "' does not implement ComputeJob interface");
        }
        try {
            Constructor<ComputeJob<T, R>> constructor = computeJobClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "Cannot instantiate job", (Throwable)e);
        }
    }

    public static <T, R> Class<ComputeJob<T, R>> jobClass(JobClassLoader jobClassLoader, String jobClassName) {
        try {
            return Class.forName(jobClassName, true, jobClassLoader);
        }
        catch (ClassNotFoundException e) {
            String message = "Cannot load job class by name '" + jobClassName + "'";
            if (jobClassLoader.units().isEmpty()) {
                throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, message + ". Deployment units list is empty.", (Throwable)e);
            }
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, message, (Throwable)e);
        }
    }

    public static <I, M, T, R> MapReduceTask<I, M, T, R> instantiateTask(Class<? extends MapReduceTask<I, M, T, R>> taskClass) {
        if (!MapReduceTask.class.isAssignableFrom(taskClass)) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "'" + taskClass.getName() + "' does not implement ComputeTask interface");
        }
        try {
            Constructor<MapReduceTask<I, M, T, R>> constructor = taskClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "Cannot instantiate task", (Throwable)e);
        }
    }

    public static <I, M, T, R> Class<MapReduceTask<I, M, T, R>> taskClass(ClassLoader taskClassLoader, String taskClassName) {
        try {
            return Class.forName(taskClassName, true, taskClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "Cannot load task class by name '" + taskClassName + "'", (Throwable)e);
        }
    }

    public static <T, R, A> DataStreamerReceiver<T, R, A> instantiateReceiver(Class<? extends DataStreamerReceiver<T, R, A>> recvClass) {
        if (!DataStreamerReceiver.class.isAssignableFrom(recvClass)) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "'" + recvClass.getName() + "' does not implement DataStreamerReceiver interface");
        }
        try {
            Constructor<DataStreamerReceiver<T, R, A>> constructor = recvClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "Cannot instantiate streamer receiver", (Throwable)e);
        }
    }

    public static <T, R, A> Class<DataStreamerReceiver<T, R, A>> receiverClass(ClassLoader classLoader, String className) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_INITIALIZATION_ERR, "Cannot load receiver class by name '" + className + "'", (Throwable)e);
        }
    }

    public static DeploymentUnitMsg toDeploymentUnitMsg(DeploymentUnit unit) {
        return MESSAGES_FACTORY.deploymentUnitMsg().name(unit.name()).version(unit.version().toString()).build();
    }

    public static CompletableFuture<UUID> jobIdFromExecuteResponse(ExecuteResponse executeResponse) {
        Throwable throwable = executeResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(executeResponse.jobId());
    }

    public static CompletableFuture<ComputeJobDataHolder> resultFromJobResultResponse(JobResultResponse jobResultResponse) {
        Throwable throwable = jobResultResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(jobResultResponse.result());
    }

    public static CompletableFuture<Collection<JobState>> statesFromJobStatesResponse(JobStatesResponse jobStatesResponse) {
        Throwable throwable = jobStatesResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(jobStatesResponse.states());
    }

    public static CompletableFuture<@Nullable JobState> stateFromJobStateResponse(JobStateResponse jobStateResponse) {
        Throwable throwable = jobStateResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(jobStateResponse.state());
    }

    public static CompletableFuture<@Nullable Boolean> cancelFromJobCancelResponse(JobCancelResponse jobCancelResponse) {
        Throwable throwable = jobCancelResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(jobCancelResponse.result());
    }

    public static CompletableFuture<@Nullable Boolean> changePriorityFromJobChangePriorityResponse(JobChangePriorityResponse jobChangePriorityResponse) {
        Throwable throwable = jobChangePriorityResponse.throwable();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(jobChangePriorityResponse.result());
    }

    public static List<DeploymentUnit> toDeploymentUnit(List<DeploymentUnitMsg> unitMsgs) {
        return unitMsgs.stream().map(it -> new DeploymentUnit(it.name(), Version.parseVersion((String)it.version()))).collect(Collectors.toList());
    }

    public static <R> CompletableFuture<R> convertToComputeFuture(CompletableFuture<R> origin) {
        return origin.handle((res, err) -> {
            if (err != null) {
                throw new CompletionException(ComputeUtils.mapToComputeException(ExceptionUtils.unwrapCause((Throwable)err)));
            }
            return res;
        });
    }

    private static Throwable mapToComputeException(Throwable origin) {
        if (origin instanceof IgniteException || origin instanceof IgniteCheckedException) {
            return origin;
        }
        return new ComputeException(ErrorGroups.Compute.COMPUTE_JOB_FAILED_ERR, "Job execution failed: " + String.valueOf(origin), origin);
    }

    @Nullable
    public static <T> T unmarshalOrNotIfNull(@Nullable Marshaller<T, byte[]> marshaller, @Nullable Object input, @Nullable Class<?> pojoType) {
        if (input == null) {
            return null;
        }
        if (input instanceof ComputeJobDataHolder) {
            return (T)SharedComputeUtils.unmarshalArgOrResult((ComputeJobDataHolder)((ComputeJobDataHolder)input), marshaller, pojoType);
        }
        if (marshaller == null) {
            if (input instanceof Tuple && pojoType != null && pojoType != Tuple.class) {
                return (T)SharedComputeUtils.unmarshalPojo(pojoType, (Tuple)((Tuple)input));
            }
            return (T)input;
        }
        if (input instanceof byte[]) {
            try {
                return (T)marshaller.unmarshal((Object)((byte[])input));
            }
            catch (Exception ex) {
                throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Exception in user-defined marshaller: " + ex.getMessage(), (Throwable)ex);
            }
        }
        throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Marshaller is defined, expected argument type: `byte[]`, actual: `" + String.valueOf(input.getClass()) + "`.If you want to use default marshalling strategy, then you should not define your marshaller in the job. If you would like to use your own marshaller, then double-check that both of them are defined in the client and in the server.");
    }

    @Nullable
    public static <T, R> Class<?> getJobExecuteArgumentType(Class<? extends ComputeJob<T, R>> jobClass) {
        for (Method method : jobClass.getDeclaredMethods()) {
            if (method.getParameterCount() != 2 || method.getParameterTypes()[0] != JobExecutionContext.class || method.getParameterTypes()[1] == Object.class || method.getReturnType() != CompletableFuture.class || !"executeAsync".equals(method.getName())) continue;
            return method.getParameterTypes()[1];
        }
        return null;
    }

    @Nullable
    public static <I, M, T, R> Class<?> getTaskSplitArgumentType(Class<? extends MapReduceTask<I, M, T, R>> taskClass) {
        for (Method method : taskClass.getDeclaredMethods()) {
            if (method.getParameterCount() != 2 || method.getParameterTypes()[0] != TaskExecutionContext.class || method.getParameterTypes()[1] == Object.class || method.getReturnType() != CompletableFuture.class || !"splitAsync".equals(method.getName())) continue;
            return method.getParameterTypes()[1];
        }
        return null;
    }
}

