/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.lease.LeaseInfoSerializer;
import org.apache.ignite.internal.storage.rocksdb.GarbageCollector;
import org.apache.ignite.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite.internal.storage.rocksdb.RocksDbTableStorage;
import org.apache.ignite.internal.storage.rocksdb.ThreadLocalState;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.AbstractWriteBatch;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

public class RocksDbMvPartitionStorage
implements MvPartitionStorage {
    private static final ThreadLocal<ByteBuffer> HEAP_COMMITTED_DATA_ID_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final ThreadLocal<ByteBuffer> HEAP_DATA_ID_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(22).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final ThreadLocal<ByteBuffer> DIRECT_DATA_ID_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final ThreadLocal<ByteBuffer> TX_STATE_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(46).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private final RocksDbTableStorage tableStorage;
    private final int partitionId;
    private final int tableId;
    private final RocksDB db;
    private final PartitionDataHelper helper;
    private final GarbageCollector gc;
    private final ColumnFamilyHandle meta;
    private final ReadOptions readOpts = new ReadOptions();
    private final byte[] lastAppliedIndexAndTermKey;
    private final byte[] lastGroupConfigKey;
    private final byte[] leaseKey;
    private final byte[] estimatedSizeKey;
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private volatile long leaseStartTime;
    private volatile UUID primaryReplicaNodeId;
    private volatile String primaryReplicaNodeName;
    private volatile byte @Nullable [] lastGroupConfig;
    private volatile long estimatedSize;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);

    public RocksDbMvPartitionStorage(RocksDbTableStorage tableStorage, int partitionId) {
        this.tableStorage = tableStorage;
        this.partitionId = partitionId;
        this.tableId = tableStorage.getTableId();
        this.db = tableStorage.db();
        this.meta = tableStorage.metaCfHandle();
        int tableId = tableStorage.getTableId();
        this.helper = new PartitionDataHelper(tableId, partitionId, tableStorage.partitionCfHandle(), tableStorage.dataCfHandle());
        this.gc = new GarbageCollector(this.helper, this.db, this.readOpts, tableStorage.gcQueueHandle());
        this.lastAppliedIndexAndTermKey = RocksDbStorageUtils.createKey(RocksDbMetaStorage.PARTITION_META_PREFIX, tableId, partitionId);
        this.lastGroupConfigKey = RocksDbStorageUtils.createKey(RocksDbMetaStorage.PARTITION_CONF_PREFIX, tableId, partitionId);
        this.leaseKey = RocksDbStorageUtils.createKey(RocksDbMetaStorage.LEASE_PREFIX, tableId, partitionId);
        this.estimatedSizeKey = RocksDbStorageUtils.createKey(RocksDbMetaStorage.ESTIMATED_SIZE_PREFIX, tableId, partitionId);
        try {
            byte[] indexAndTerm = this.db.get(this.meta, this.readOpts, this.lastAppliedIndexAndTermKey);
            ByteBuffer buf = indexAndTerm == null ? null : ByteBuffer.wrap(indexAndTerm).order(ByteOrder.LITTLE_ENDIAN);
            this.lastAppliedIndex = buf == null ? 0L : buf.getLong();
            this.lastAppliedTerm = buf == null ? 0L : buf.getLong();
            this.lastGroupConfig = this.db.get(this.meta, this.readOpts, this.lastGroupConfigKey);
            byte[] leaseBytes = this.db.get(this.meta, this.readOpts, this.leaseKey);
            if (leaseBytes == null) {
                this.leaseStartTime = HybridTimestamp.MIN_VALUE.longValue();
            } else {
                LeaseInfo leaseInfo = (LeaseInfo)VersionedSerialization.fromBytes((byte[])leaseBytes, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
                this.leaseStartTime = leaseInfo.leaseStartTime();
                this.primaryReplicaNodeId = leaseInfo.primaryReplicaNodeId();
                this.primaryReplicaNodeName = leaseInfo.primaryReplicaNodeName();
            }
            byte[] estimatedSizeBytes = this.db.get(this.meta, this.readOpts, this.estimatedSizeKey);
            this.estimatedSize = estimatedSizeBytes == null ? 0L : ByteUtils.bytesToLong((byte[])estimatedSizeBytes);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(e);
        }
    }

    public PartitionDataHelper helper() {
        return this.helper;
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        ThreadLocalState existingState = PartitionDataHelper.THREAD_LOCAL_STATE.get();
        if (existingState != null) {
            return (V)closure.execute((MvPartitionStorage.Locker)existingState.locker);
        }
        return (V)this.busy(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> this.tableStorage.awaitFlush(trigger));
    }

    public int partitionId() {
        return this.partitionId;
    }

    public long lastAppliedIndex() {
        return this.busy(() -> {
            ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
            return state == null ? this.lastAppliedIndex : state.pendingAppliedIndex;
        });
    }

    public long lastAppliedTerm() {
        return this.busy(() -> {
            ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
            return state == null ? this.lastAppliedTerm : state.pendingAppliedTerm;
        });
    }

    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            try {
                this.savePendingLastApplied((AbstractWriteBatch)PartitionDataHelper.requireWriteBatch(), lastAppliedIndex, lastAppliedTerm);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException(e);
            }
        });
    }

    private void savePendingLastApplied(AbstractWriteBatch writeBatch, long lastAppliedIndex, long lastAppliedTerm) throws RocksDBException {
        writeBatch.put(this.meta, this.lastAppliedIndexAndTermKey, RocksDbMvPartitionStorage.longPairToBytes(lastAppliedIndex, lastAppliedTerm));
        ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
        if (state != null) {
            state.pendingAppliedIndex = lastAppliedIndex;
            state.pendingAppliedTerm = lastAppliedTerm;
        }
    }

    private static byte[] longPairToBytes(long index, long term) {
        ByteBuffer buf = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(index);
        buf.putLong(term);
        return buf.array();
    }

    public byte @Nullable [] committedGroupConfiguration() {
        byte[] array = this.busy(() -> {
            ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
            return state == null ? this.lastGroupConfig : state.pendingGroupConfig;
        });
        return array == null ? null : (byte[])array.clone();
    }

    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            try {
                this.saveGroupConfiguration((AbstractWriteBatch)PartitionDataHelper.requireWriteBatch(), config);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException(e);
            }
        });
    }

    private void saveGroupConfiguration(AbstractWriteBatch writeBatch, byte[] config) throws RocksDBException {
        writeBatch.put(this.meta, this.lastGroupConfigKey, config);
        ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
        if (state != null) {
            state.pendingGroupConfig = (byte[])config.clone();
        }
    }

    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        return this.busy(() -> {
            WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
            assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
            try {
                byte[] uncommittedDataIdKey = this.createUncommittedDataIdKey(rowId);
                byte[] previousTxState = writeBatch.getFromBatchAndDB(this.db, this.helper.partCf, this.readOpts, uncommittedDataIdKey);
                if (previousTxState != null) {
                    ByteBuffer previousTxStateBuffer = ByteBuffer.wrap(previousTxState);
                    RocksDbMvPartitionStorage.validateTxId(previousTxStateBuffer, txId);
                    ByteBuffer dataId = RocksDbMvPartitionStorage.readDataIdFromTxState(previousTxStateBuffer);
                    byte[] payloadKey = this.helper.createPayloadKey(dataId);
                    BinaryRow previousRow = null;
                    boolean isOldValueTombstone = PartitionDataHelper.isTombstone(dataId);
                    if (!isOldValueTombstone) {
                        byte[] previousRowBytes = writeBatch.getFromBatchAndDB(this.db, this.helper.dataCf, this.readOpts, payloadKey);
                        previousRow = PartitionDataHelper.deserializeRow(previousRowBytes);
                    }
                    if (isOldValueTombstone ^ row == null) {
                        PartitionDataHelper.setFirstBit(previousTxState, 23, row == null);
                        writeBatch.put(this.helper.partCf, uncommittedDataIdKey, previousTxState);
                    }
                    if (row != null) {
                        writeBatch.put(this.helper.dataCf, payloadKey, RocksDbMvPartitionStorage.serializeBinaryRow(row));
                    }
                    return previousRow;
                }
                ByteBuffer txState = RocksDbMvPartitionStorage.createTxState(rowId, txId, commitTableId, commitPartitionId, row == null);
                ByteBuffer dataId = RocksDbMvPartitionStorage.readDataIdFromTxState(txState);
                writeBatch.put(this.helper.partCf, uncommittedDataIdKey, txState.array());
                if (row != null) {
                    writeBatch.put(this.helper.dataCf, this.helper.createPayloadKey(dataId), RocksDbMvPartitionStorage.serializeBinaryRow(row));
                }
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Failed to update a row in storage: " + this.createStorageInfo(), e);
            }
        });
    }

    private static ByteBuffer createDataId(RowId rowId, HybridTimestamp txTimestamp, boolean isTombstone) {
        ByteBuffer buffer = ByteBuffer.allocate(24).order(RocksDbStorageUtils.KEY_BYTE_ORDER);
        RocksDbMvPartitionStorage.putDataId(buffer, rowId, txTimestamp, isTombstone);
        return buffer.rewind();
    }

    private static ByteBuffer createTxState(RowId rowId, UUID txId, int commitTableId, int commitPartitionId, boolean isTombstone) {
        ByteBuffer buffer = TX_STATE_BUFFER.get().clear();
        RocksDbMvPartitionStorage.putDataId(buffer, rowId, TransactionIds.beginTimestamp((UUID)txId), isTombstone);
        return buffer.putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).putInt(commitTableId).putShort((short)commitPartitionId).rewind();
    }

    private static void putDataId(ByteBuffer buffer, RowId rowId, HybridTimestamp txTimestamp, boolean isTombstone) {
        long timestamp = txTimestamp.longValue();
        long timestampWithTombstoneFlag = timestamp << 1 | (long)(isTombstone ? 1 : 0);
        buffer.putLong(rowId.mostSignificantBits()).putLong(rowId.leastSignificantBits()).putLong(timestampWithTombstoneFlag);
    }

    private static ByteBuffer readDataIdFromTxState(ByteBuffer txState) {
        int prevLimit = txState.limit();
        ByteBuffer dataId = txState.limit(24).slice().order(RocksDbStorageUtils.KEY_BYTE_ORDER);
        txState.position(txState.position() + 24).limit(prevLimit);
        return dataId;
    }

    private static byte[] serializeBinaryRow(BinaryRow row) {
        return ByteBuffer.allocate(2 + row.tupleSliceLength()).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putShort((short)row.schemaVersion()).put(row.tupleSlice()).array();
    }

    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
            assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
            byte[] uncommittedDataIdKey = this.createUncommittedDataIdKey(rowId);
            try {
                byte[] dataIdWithTxState = writeBatch.getFromBatchAndDB(this.db, this.helper.partCf, this.readOpts, uncommittedDataIdKey);
                if (dataIdWithTxState == null) {
                    return null;
                }
                ByteBuffer dataId = RocksDbMvPartitionStorage.readDataIdFromTxState(ByteBuffer.wrap(dataIdWithTxState));
                byte[] payloadKey = this.helper.createPayloadKey(dataId);
                BinaryRow row = null;
                if (!PartitionDataHelper.isTombstone(dataId)) {
                    byte[] rowBytes = writeBatch.getFromBatchAndDB(this.db, this.helper.dataCf, this.readOpts, payloadKey);
                    row = PartitionDataHelper.deserializeRow(rowBytes);
                }
                writeBatch.delete(this.helper.partCf, uncommittedDataIdKey);
                writeBatch.delete(this.helper.dataCf, payloadKey);
                return row;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Failed to roll back insert/update", e);
            }
        });
    }

    private static boolean rowIsLocked(RowId rowId) {
        ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
        return state != null && state.locker.isLocked(rowId);
    }

    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        this.busy(() -> {
            WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
            assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
            byte[] dataIdKey = this.createCommittedDataIdKey(rowId, timestamp);
            byte[] uncommittedDataIdKey = Arrays.copyOf(dataIdKey, 22);
            try {
                byte[] txState = writeBatch.getFromBatchAndDB(this.db, this.helper.partCf, this.readOpts, uncommittedDataIdKey);
                if (txState == null) {
                    return null;
                }
                byte[] dataId = Arrays.copyOf(txState, 24);
                boolean isNewValueTombstone = PartitionDataHelper.isTombstone(dataId);
                GarbageCollector.AddResult addResult = this.gc.tryAddToGcQueue(writeBatch, rowId, timestamp, isNewValueTombstone);
                writeBatch.delete(this.helper.partCf, uncommittedDataIdKey);
                if (isNewValueTombstone && addResult != GarbageCollector.AddResult.WAS_VALUE) {
                    return null;
                }
                writeBatch.put(this.helper.partCf, dataIdKey, dataId);
                RocksDbMvPartitionStorage.updateEstimatedSize(isNewValueTombstone, addResult);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Failed to commit row into storage", e);
            }
        });
    }

    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        this.busy(() -> {
            WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
            assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
            boolean isNewValueTombstone = row == null;
            try {
                GarbageCollector.AddResult addResult = this.gc.tryAddToGcQueue(writeBatch, rowId, commitTimestamp, isNewValueTombstone);
                if (isNewValueTombstone && addResult != GarbageCollector.AddResult.WAS_VALUE) {
                    return null;
                }
                byte[] dataIdKey = this.createCommittedDataIdKey(rowId, commitTimestamp);
                ByteBuffer dataId = RocksDbMvPartitionStorage.createDataId(rowId, commitTimestamp, isNewValueTombstone);
                writeBatch.put(this.helper.partCf, dataIdKey, dataId.array());
                if (row != null) {
                    writeBatch.put(this.helper.dataCf, this.helper.createPayloadKey(dataId), RocksDbMvPartitionStorage.serializeBinaryRow(row));
                }
                RocksDbMvPartitionStorage.updateEstimatedSize(isNewValueTombstone, addResult);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Failed to update a row in storage: " + this.createStorageInfo(), e);
            }
        });
    }

    private static void updateEstimatedSize(boolean isNewValueTombstone, GarbageCollector.AddResult gcQueueAddResult) throws RocksDBException {
        if (isNewValueTombstone) {
            if (gcQueueAddResult == GarbageCollector.AddResult.WAS_VALUE) {
                ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
                --state.pendingEstimatedSizeDiff;
            }
        } else if (gcQueueAddResult != GarbageCollector.AddResult.WAS_VALUE) {
            ThreadLocalState state = PartitionDataHelper.THREAD_LOCAL_STATE.get();
            ++state.pendingEstimatedSizeDiff;
        }
    }

    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            if (rowId.partitionId() != this.partitionId) {
                throw new IllegalArgumentException(String.format("RowId partition [%d] is not equal to storage partition [%d].", rowId.partitionId(), this.partitionId));
            }
            try (RocksIterator baseIterator = this.db.newIterator(this.helper.partCf, this.helper.upperBoundReadOpts);){
                ReadResult readResult;
                block17: {
                    RocksIterator seekIterator;
                    block15: {
                        ReadResult readResult2;
                        block16: {
                            seekIterator = PartitionDataHelper.wrapIterator(baseIterator, this.helper.partCf);
                            try {
                                if (!RocksDbMvPartitionStorage.lookingForLatestVersions(timestamp)) break block15;
                                readResult2 = this.readLatestVersion(rowId, seekIterator);
                                if (seekIterator == null) break block16;
                            }
                            catch (Throwable throwable) {
                                if (seekIterator != null) {
                                    try {
                                        seekIterator.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            seekIterator.close();
                        }
                        return readResult2;
                    }
                    readResult = this.readByTimestamp(seekIterator, rowId, timestamp);
                    if (seekIterator == null) break block17;
                    seekIterator.close();
                }
                return readResult;
            }
        });
    }

    private static boolean lookingForLatestVersions(HybridTimestamp timestamp) {
        return timestamp == HybridTimestamp.MAX_VALUE;
    }

    private ReadResult readLatestVersion(RowId rowId, RocksIterator seekIterator) {
        ByteBuffer dataIdKeyPrefix = this.prepareDirectDataIdKeyBuf(rowId).position(0).limit(22);
        seekIterator.seek(dataIdKeyPrefix);
        if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
            return ReadResult.empty((RowId)rowId);
        }
        ByteBuffer dataIdKey = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        int keyLength = seekIterator.key(dataIdKey);
        dataIdKey.position(0).limit(keyLength);
        if (!RocksDbMvPartitionStorage.matches(rowId, dataIdKey)) {
            return ReadResult.empty((RowId)rowId);
        }
        boolean isWriteIntent = keyLength == 22;
        ByteBuffer valueBytes = ByteBuffer.wrap(seekIterator.value());
        return this.readResultFromKeyAndValue(isWriteIntent, dataIdKey, valueBytes);
    }

    private ReadResult readResultFromKeyAndValue(boolean isWriteIntent, ByteBuffer dataIdKey, ByteBuffer valueBytes) {
        RowId rowId = this.getRowId(dataIdKey);
        if (!isWriteIntent) {
            return this.wrapCommittedValue(rowId, valueBytes, PartitionDataHelper.readTimestampDesc(dataIdKey));
        }
        return this.wrapUncommittedValue(rowId, valueBytes, null);
    }

    private ReadResult readByTimestamp(RocksIterator seekIterator, RowId rowId, HybridTimestamp timestamp) {
        byte[] committedDataIdKey = this.createCommittedDataIdKey(rowId, timestamp);
        seekIterator.seek(committedDataIdKey);
        return this.handleReadByTimestampIterator(seekIterator, rowId, timestamp, committedDataIdKey);
    }

    private ReadResult handleReadByTimestampIterator(RocksIterator seekIterator, RowId rowId, HybridTimestamp timestamp, byte[] committedDataIdKey) {
        boolean isWriteIntent;
        ByteBuffer foundKeyBuf = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        int keyLength = 0;
        if (!RocksDbMvPartitionStorage.invalid(seekIterator)) {
            keyLength = seekIterator.key(foundKeyBuf);
        }
        if (RocksDbMvPartitionStorage.invalid(seekIterator) || !RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
            boolean isWriteIntent2;
            seekIterator.seek(Arrays.copyOf(committedDataIdKey, 22));
            if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
                return ReadResult.empty((RowId)rowId);
            }
            foundKeyBuf.clear();
            keyLength = seekIterator.key(foundKeyBuf);
            if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
                return ReadResult.empty((RowId)rowId);
            }
            boolean bl = isWriteIntent2 = keyLength == 22;
            if (isWriteIntent2) {
                ByteBuffer valueBytes = ByteBuffer.wrap(seekIterator.value());
                seekIterator.next();
                if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
                    return this.wrapUncommittedValue(rowId, valueBytes, null);
                }
                foundKeyBuf.clear();
                seekIterator.key(foundKeyBuf);
                if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
                    return this.wrapUncommittedValue(rowId, valueBytes, null);
                }
            }
            return ReadResult.empty((RowId)rowId);
        }
        assert (keyLength == 30);
        HybridTimestamp rowTimestamp = PartitionDataHelper.readTimestampDesc(foundKeyBuf);
        ByteBuffer valueBytes = ByteBuffer.wrap(seekIterator.value());
        if (rowTimestamp.equals((Object)timestamp)) {
            return this.wrapCommittedValue(rowId, valueBytes, rowTimestamp);
        }
        seekIterator.prev();
        if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
            return this.wrapCommittedValue(rowId, valueBytes, rowTimestamp);
        }
        foundKeyBuf.clear();
        keyLength = seekIterator.key(foundKeyBuf);
        if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
            return this.wrapCommittedValue(rowId, valueBytes, rowTimestamp);
        }
        boolean bl = isWriteIntent = keyLength == 22;
        if (isWriteIntent) {
            return this.wrapUncommittedValue(rowId, ByteBuffer.wrap(seekIterator.value()), rowTimestamp);
        }
        return this.wrapCommittedValue(rowId, valueBytes, PartitionDataHelper.readTimestampDesc(foundKeyBuf));
    }

    private static boolean matches(RowId rowId, ByteBuffer dataIdKey) {
        dataIdKey.position(6);
        return rowId.mostSignificantBits() == RocksDbStorageUtils.normalize(dataIdKey.getLong()) && rowId.leastSignificantBits() == RocksDbStorageUtils.normalize(dataIdKey.getLong());
    }

    public Cursor<ReadResult> scanVersions(final RowId rowId) throws StorageException {
        return (Cursor)this.busy(() -> {
            assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            ByteBuffer prefix = this.prepareDirectDataIdKeyBuf(rowId).position(0).limit(22);
            final ReadOptions options = new ReadOptions().setPrefixSameAsStart(true);
            RocksIterator it = this.db.newIterator(this.helper.partCf, options);
            it = PartitionDataHelper.wrapIterator(it, this.helper.partCf);
            it.seek(prefix);
            return new RocksIteratorAdapter<ReadResult>(it){

                protected ReadResult decodeEntry(byte[] key, byte[] value) {
                    int keyLength = key.length;
                    boolean isWriteIntent = keyLength == 22;
                    return RocksDbMvPartitionStorage.this.readResultFromKeyAndValue(isWriteIntent, ByteBuffer.wrap(key).order(RocksDbStorageUtils.KEY_BYTE_ORDER), ByteBuffer.wrap(value));
                }

                public boolean hasNext() {
                    return RocksDbMvPartitionStorage.this.busy(() -> {
                        assert (RocksDbMvPartitionStorage.rowIsLocked(rowId)) : "rowId=" + String.valueOf(rowId) + ", " + RocksDbMvPartitionStorage.this.createStorageInfo();
                        try {
                            return super.hasNext();
                        }
                        catch (IgniteInternalException e) {
                            if (e.getCause() instanceof RocksDBException) {
                                throw new IgniteRocksDbException("Failed to read entry", (RocksDBException)e.getCause());
                            }
                            throw e;
                        }
                    });
                }

                public ReadResult next() {
                    return RocksDbMvPartitionStorage.this.busy(() -> {
                        assert (RocksDbMvPartitionStorage.rowIsLocked(rowId)) : "rowId=" + String.valueOf(rowId) + ", " + RocksDbMvPartitionStorage.this.createStorageInfo();
                        return (ReadResult)super.next();
                    });
                }

                public void close() {
                    assert (RocksDbMvPartitionStorage.rowIsLocked(rowId));
                    super.close();
                    RocksUtils.closeAll((AbstractNativeReference[])new AbstractNativeReference[]{options});
                }
            };
        });
    }

    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        Objects.requireNonNull(timestamp, "timestamp is null");
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            if (RocksDbMvPartitionStorage.lookingForLatestVersions(timestamp)) {
                return new ScanLatestVersionsCursor();
            }
            return new ScanByTimestampCursor(timestamp);
        });
    }

    private static void setKeyBuffer(ByteBuffer keyBuf, RowId rowId, @Nullable HybridTimestamp timestamp) {
        keyBuf.putLong(6, RocksDbStorageUtils.normalize(rowId.mostSignificantBits()));
        keyBuf.putLong(14, RocksDbStorageUtils.normalize(rowId.leastSignificantBits()));
        if (timestamp != null) {
            PartitionDataHelper.putTimestampDesc(keyBuf.position(22), timestamp);
        }
        keyBuf.rewind();
    }

    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            ByteBuffer keyBuf = this.prepareDirectDataIdKeyBuf(lowerBound).position(0).limit(22);
            try (RocksIterator it = this.db.newIterator(this.helper.partCf, this.helper.scanReadOpts);){
                it.seek(keyBuf);
                if (!it.isValid()) {
                    it.status();
                    RowId rowId2 = null;
                    return rowId2;
                }
                keyBuf.rewind();
                it.key(keyBuf);
                RowId rowId = this.getRowId(keyBuf);
                return rowId;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Error finding closest Row ID", e);
            }
        });
    }

    private static void incrementRowId(ByteBuffer buf) {
        long lsb = 1L + buf.getLong(14);
        buf.putLong(14, lsb);
        if (lsb != 0L) {
            return;
        }
        long msb = 1L + buf.getLong(6);
        buf.putLong(6, msb);
        if (msb != 0L) {
            return;
        }
        short partitionId = (short)(1 + buf.getShort(0));
        assert (partitionId != 0);
        buf.putShort(0, partitionId);
        buf.rewind();
    }

    private RowId getRowId(ByteBuffer keyBuffer) {
        return this.helper.getRowId(keyBuffer, 6);
    }

    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.busy(() -> {
            if (leaseStartTime <= this.leaseStartTime) {
                return null;
            }
            this.saveLease((AbstractWriteBatch)PartitionDataHelper.requireWriteBatch(), leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
            return null;
        });
    }

    private void saveLease(AbstractWriteBatch writeBatch, long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        LeaseInfo leaseInfo = new LeaseInfo(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
        byte[] bytes = VersionedSerialization.toBytes((Object)leaseInfo, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
        try {
            writeBatch.put(this.meta, this.leaseKey, bytes);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(e);
        }
        this.leaseStartTime = leaseStartTime;
        this.primaryReplicaNodeId = primaryReplicaNodeId;
        this.primaryReplicaNodeName = primaryReplicaNodeName;
    }

    public long leaseStartTime() {
        return this.busy(() -> this.leaseStartTime);
    }

    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.busy(() -> this.primaryReplicaNodeId);
    }

    @Nullable
    public String primaryReplicaNodeName() {
        return this.busy(() -> this.primaryReplicaNodeName);
    }

    void destroyData(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.delete(this.meta, this.lastAppliedIndexAndTermKey);
        writeBatch.delete(this.meta, this.lastGroupConfigKey);
        writeBatch.delete(this.meta, this.leaseKey);
        writeBatch.deleteRange(this.helper.partCf, this.helper.partitionStartPrefix(), this.helper.partitionEndPrefix());
        writeBatch.deleteRange(this.helper.dataCf, this.helper.partitionStartPrefix(), this.helper.partitionEndPrefix());
        this.gc.deleteQueue(writeBatch);
    }

    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        WriteBatchWithIndex batch = PartitionDataHelper.requireWriteBatch();
        StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
        return this.gc.peek(batch, lowWatermark);
    }

    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        WriteBatchWithIndex batch = PartitionDataHelper.requireWriteBatch();
        StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
        try {
            return this.gc.vacuum(batch, entry);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException("Failed to collect garbage: " + this.createStorageInfo(), e);
        }
    }

    public long estimatedSize() {
        return this.estimatedSize;
    }

    public void close() {
        this.transitionToDestroyedOrClosedState(StorageState.CLOSED);
    }

    private void transitionToDestroyedOrClosedState(StorageState targetState) {
        if (!StorageUtils.transitionToTerminalState((StorageState)targetState, this.state)) {
            return;
        }
        this.busyLock.block();
        this.readOpts.close();
        this.helper.close();
    }

    public void transitionToDestroyedState() {
        this.transitionToDestroyedOrClosedState(StorageState.DESTROYED);
    }

    private byte[] createUncommittedDataIdKey(RowId rowId) {
        ByteBuffer uncommittedDataIdKeyBuf = HEAP_DATA_ID_KEY_BUFFER.get().clear();
        this.writeRowPrefix(uncommittedDataIdKeyBuf, rowId);
        return uncommittedDataIdKeyBuf.array();
    }

    private byte[] createCommittedDataIdKey(RowId rowId, HybridTimestamp timestamp) {
        ByteBuffer keyBuf = HEAP_COMMITTED_DATA_ID_KEY_BUFFER.get().clear();
        this.helper.putCommittedDataIdKey(keyBuf, rowId, timestamp);
        return keyBuf.array();
    }

    private ByteBuffer prepareDirectDataIdKeyBuf(RowId rowId) {
        ByteBuffer keyBuf = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        this.writeRowPrefix(keyBuf, rowId);
        return keyBuf;
    }

    private void writeRowPrefix(ByteBuffer buffer, RowId rowId) {
        assert (buffer.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        assert (rowId.partitionId() == this.partitionId) : rowId;
        buffer.putInt(this.tableStorage.getTableId());
        buffer.putShort((short)rowId.partitionId());
        this.helper.putRowId(buffer, rowId);
    }

    private static void validateTxId(ByteBuffer dataIdWithTxState, UUID txId) {
        dataIdWithTxState.position(24);
        long msb = dataIdWithTxState.getLong();
        long lsb = dataIdWithTxState.getLong();
        dataIdWithTxState.rewind();
        if (txId.getMostSignificantBits() != msb || txId.getLeastSignificantBits() != lsb) {
            throw new TxIdMismatchException(txId, new UUID(msb, lsb));
        }
    }

    static boolean invalid(RocksIterator it) {
        boolean invalid;
        boolean bl = invalid = !it.isValid();
        if (invalid) {
            try {
                it.status();
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Failed to read data from storage", e);
            }
        }
        return invalid;
    }

    private ReadResult wrapUncommittedValue(RowId rowId, ByteBuffer transactionState, @Nullable HybridTimestamp newestCommitTs) {
        assert (transactionState.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        ByteBuffer dataId = RocksDbMvPartitionStorage.readDataIdFromTxState(transactionState);
        UUID txId = new UUID(transactionState.getLong(), transactionState.getLong());
        int commitTableId = transactionState.getInt();
        int commitPartitionId = Short.toUnsignedInt(transactionState.getShort());
        transactionState.rewind();
        BinaryRow row = this.readRowByDataId(dataId);
        return ReadResult.createFromWriteIntent((RowId)rowId, (BinaryRow)row, (UUID)txId, (int)commitTableId, (int)commitPartitionId, (HybridTimestamp)newestCommitTs);
    }

    private ReadResult wrapCommittedValue(RowId rowId, ByteBuffer dataId, HybridTimestamp rowCommitTimestamp) {
        return ReadResult.createFromCommitted((RowId)rowId, (BinaryRow)this.readRowByDataId(dataId), (HybridTimestamp)rowCommitTimestamp);
    }

    @Nullable
    private BinaryRow readRowByDataId(ByteBuffer dataId) {
        if (PartitionDataHelper.isTombstone(dataId)) {
            return null;
        }
        try {
            byte[] payloadKey = this.helper.createPayloadKey(dataId);
            byte[] rowBytes = PartitionDataHelper.getFromBatchAndDb(this.db, this.helper.dataCf, this.readOpts, payloadKey);
            return rowBytes == null ? null : PartitionDataHelper.deserializeRow(rowBytes);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(e);
        }
    }

    private <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    String createStorageInfo() {
        return IgniteStringFormatter.format((String)"tableId={}, partitionId={}", (Object[])new Object[]{this.tableStorage.getTableId(), this.partitionId});
    }

    void startRebalance(WriteBatch writeBatch) {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.clearStorage(writeBatch, -1L, -1L);
        }
        catch (RocksDBException e) {
            throw new StorageRebalanceException("Error when trying to start rebalancing storage: " + this.createStorageInfo(), (Throwable)e);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    void abortRebalance(WriteBatch writeBatch) {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        try {
            this.clearStorage(writeBatch, 0L, 0L);
        }
        catch (RocksDBException e) {
            throw new StorageRebalanceException("Error when trying to abort rebalancing storage: " + this.createStorageInfo(), (Throwable)e);
        }
    }

    void finishRebalance(WriteBatch writeBatch, MvPartitionMeta partitionMeta) {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        try {
            this.saveLastApplied(writeBatch, partitionMeta.lastAppliedIndex(), partitionMeta.lastAppliedTerm());
            this.saveGroupConfigurationOnRebalance(writeBatch, partitionMeta.groupConfig());
            if (partitionMeta.primaryReplicaNodeId() != null) {
                assert (partitionMeta.primaryReplicaNodeName() != null);
                this.updateLeaseOnRebalance(writeBatch, partitionMeta.leaseStartTime(), partitionMeta.primaryReplicaNodeId(), partitionMeta.primaryReplicaNodeName());
            }
        }
        catch (RocksDBException e) {
            throw new StorageRebalanceException("Error when trying to abort rebalancing storage: " + this.createStorageInfo(), (Throwable)e);
        }
    }

    private void clearStorage(WriteBatch writeBatch, long lastAppliedIndex, long lastAppliedTerm) throws RocksDBException {
        this.saveLastApplied(writeBatch, lastAppliedIndex, lastAppliedTerm);
        this.lastGroupConfig = null;
        this.estimatedSize = 0L;
        writeBatch.delete(this.meta, this.lastGroupConfigKey);
        writeBatch.delete(this.meta, this.leaseKey);
        writeBatch.delete(this.meta, this.estimatedSizeKey);
        writeBatch.deleteRange(this.helper.partCf, this.helper.partitionStartPrefix(), this.helper.partitionEndPrefix());
        writeBatch.deleteRange(this.helper.dataCf, this.helper.partitionStartPrefix(), this.helper.partitionEndPrefix());
        this.gc.deleteQueue(writeBatch);
    }

    private void saveLastApplied(WriteBatch writeBatch, long lastAppliedIndex, long lastAppliedTerm) throws RocksDBException {
        this.savePendingLastApplied((AbstractWriteBatch)writeBatch, lastAppliedIndex, lastAppliedTerm);
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
    }

    private void saveGroupConfigurationOnRebalance(WriteBatch writeBatch, byte[] config) throws RocksDBException {
        this.saveGroupConfiguration((AbstractWriteBatch)writeBatch, config);
        this.lastGroupConfig = (byte[])config.clone();
    }

    private void updateLeaseOnRebalance(WriteBatch writeBatch, long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.saveLease((AbstractWriteBatch)writeBatch, leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
        this.leaseStartTime = leaseStartTime;
        this.primaryReplicaNodeId = primaryReplicaNodeId;
        this.primaryReplicaNodeName = primaryReplicaNodeName;
    }

    void startCleanup(WriteBatch writeBatch) throws RocksDBException {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        this.clearStorage(writeBatch, 0L, 0L);
    }

    void finishCleanup() {
        if (this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE)) {
            this.busyLock.unblock();
        }
    }

    private final class ScanLatestVersionsCursor
    extends BasePartitionTimestampCursor {
        private ScanLatestVersionsCursor() {
        }

        @Override
        public boolean hasNextBusy() {
            RowId rowId;
            ReadResult readResult;
            if (this.next != null) {
                return true;
            }
            if (this.currentRowId != null) {
                RocksDbMvPartitionStorage.setKeyBuffer(this.seekKeyBuf, this.currentRowId, null);
                RocksDbMvPartitionStorage.incrementRowId(this.seekKeyBuf);
            }
            this.currentRowId = null;
            ByteBuffer currentKeyBuffer = DIRECT_DATA_ID_KEY_BUFFER.get();
            do {
                this.it.seek(Arrays.copyOf(this.seekKeyBuf.array(), 22));
                if (RocksDbMvPartitionStorage.invalid(this.it)) {
                    return false;
                }
                int keyLength = this.it.key(currentKeyBuffer.clear());
                currentKeyBuffer.position(0).limit(keyLength);
                boolean isWriteIntent = keyLength == 22;
                rowId = RocksDbMvPartitionStorage.this.getRowId(currentKeyBuffer);
                this.seekKeyBuf.putLong(6, RocksDbStorageUtils.normalize(rowId.mostSignificantBits()));
                this.seekKeyBuf.putLong(14, RocksDbStorageUtils.normalize(rowId.leastSignificantBits()));
                RocksDbMvPartitionStorage.incrementRowId(this.seekKeyBuf);
                byte[] valueBytes = this.it.value();
                HybridTimestamp nextCommitTimestamp = null;
                if (isWriteIntent) {
                    ByteBuffer key;
                    this.it.next();
                    if (!RocksDbMvPartitionStorage.invalid(this.it) && RocksDbMvPartitionStorage.matches(rowId, key = ByteBuffer.wrap(this.it.key()).order(RocksDbStorageUtils.KEY_BYTE_ORDER))) {
                        nextCommitTimestamp = PartitionDataHelper.readTimestampDesc(key);
                    }
                }
                assert (valueBytes != null);
                ByteBuffer valueBuffer = ByteBuffer.wrap(valueBytes);
                ReadResult readResult2 = readResult = isWriteIntent ? RocksDbMvPartitionStorage.this.wrapUncommittedValue(rowId, valueBuffer, nextCommitTimestamp) : RocksDbMvPartitionStorage.this.wrapCommittedValue(rowId, valueBuffer, PartitionDataHelper.readTimestampDesc(currentKeyBuffer));
            } while (readResult.isEmpty() && !readResult.isWriteIntent());
            this.next = readResult;
            this.currentRowId = rowId;
            return true;
        }
    }

    private final class ScanByTimestampCursor
    extends BasePartitionTimestampCursor {
        private final HybridTimestamp timestamp;

        private ScanByTimestampCursor(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public boolean hasNextBusy() {
            ReadResult readResult;
            RowId rowId;
            if (this.next != null) {
                return true;
            }
            if (this.currentRowId != null) {
                RocksDbMvPartitionStorage.setKeyBuffer(this.seekKeyBuf, this.currentRowId, this.timestamp);
                RocksDbMvPartitionStorage.incrementRowId(this.seekKeyBuf);
            }
            this.currentRowId = null;
            ByteBuffer directBuffer = DIRECT_DATA_ID_KEY_BUFFER.get();
            while (true) {
                this.it.seek(Arrays.copyOf(this.seekKeyBuf.array(), 22));
                if (RocksDbMvPartitionStorage.invalid(this.it)) {
                    return false;
                }
                this.it.key(directBuffer.clear());
                rowId = RocksDbMvPartitionStorage.this.getRowId(directBuffer);
                RocksDbMvPartitionStorage.setKeyBuffer(this.seekKeyBuf, rowId, this.timestamp);
                this.it.seek(this.seekKeyBuf.array());
                readResult = RocksDbMvPartitionStorage.this.handleReadByTimestampIterator(this.it, rowId, this.timestamp, this.seekKeyBuf.array());
                if (!readResult.isEmpty() || readResult.isWriteIntent()) break;
                RocksDbMvPartitionStorage.incrementRowId(this.seekKeyBuf);
            }
            this.next = readResult;
            this.currentRowId = rowId;
            return true;
        }
    }

    private abstract class BasePartitionTimestampCursor
    implements PartitionTimestampCursor {
        protected final RocksIterator it;
        final ByteBuffer seekKeyBuf;
        RowId currentRowId;
        protected ReadResult next;

        private BasePartitionTimestampCursor() {
            this.it = RocksDbMvPartitionStorage.this.db.newIterator(RocksDbMvPartitionStorage.this.helper.partCf, RocksDbMvPartitionStorage.this.helper.scanReadOpts);
            this.seekKeyBuf = ByteBuffer.allocate(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(RocksDbMvPartitionStorage.this.tableId).putShort((short)RocksDbMvPartitionStorage.this.partitionId);
        }

        protected abstract boolean hasNextBusy();

        public boolean hasNext() {
            return RocksDbMvPartitionStorage.this.busy(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)RocksDbMvPartitionStorage.this.state.get(), RocksDbMvPartitionStorage.this::createStorageInfo);
                return this.hasNextBusy();
            });
        }

        @Nullable
        public BinaryRow committed(HybridTimestamp timestamp) {
            return RocksDbMvPartitionStorage.this.busy(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)RocksDbMvPartitionStorage.this.state.get(), RocksDbMvPartitionStorage.this::createStorageInfo);
                Objects.requireNonNull(timestamp, "timestamp is null");
                if (this.currentRowId == null) {
                    throw new IllegalStateException("currentRowId is null");
                }
                RocksDbMvPartitionStorage.setKeyBuffer(this.seekKeyBuf, this.currentRowId, timestamp);
                this.it.seek(this.seekKeyBuf.array());
                ReadResult readResult = RocksDbMvPartitionStorage.this.handleReadByTimestampIterator(this.it, this.currentRowId, timestamp, this.seekKeyBuf.array());
                if (readResult.isEmpty()) {
                    return null;
                }
                return readResult.binaryRow();
            });
        }

        public final ReadResult next() {
            return RocksDbMvPartitionStorage.this.busy(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)RocksDbMvPartitionStorage.this.state.get(), RocksDbMvPartitionStorage.this::createStorageInfo);
                if (!this.hasNextBusy()) {
                    throw new NoSuchElementException();
                }
                ReadResult res = this.next;
                this.next = null;
                return res;
            });
        }

        public final void close() {
            this.it.close();
        }
    }
}

