/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.requests.cluster.ClientClusterGetNodesRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.NodeNotFoundException;
import org.apache.ignite.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class ClientComputeExecuteRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteComputeInternal compute, ClusterService cluster, NotificationSender notificationSender) {
        Set<ClusterNode> candidates = ClientComputeExecuteRequest.unpackCandidateNodes(in, cluster);
        List deploymentUnits = in.unpackDeploymentUnits();
        String jobClassName = in.unpackString();
        JobExecutionOptions options = JobExecutionOptions.builder().priority(in.unpackInt()).maxRetries(in.unpackInt()).build();
        ComputeJobDataHolder arg = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller((ClientMessageUnpacker)in);
        JobExecution execution = compute.executeAsyncWithFailover(candidates, deploymentUnits, jobClassName, options, arg, null);
        ClientComputeExecuteRequest.sendResultAndState(CompletableFuture.completedFuture(execution), notificationSender);
        return execution.idAsync().thenAccept(jobId -> ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node()));
    }

    private static Set<ClusterNode> unpackCandidateNodes(ClientMessageUnpacker in, ClusterService cluster) {
        int size = in.unpackInt();
        if (size < 1) {
            throw new IllegalArgumentException("nodes must not be empty.");
        }
        HashSet<String> nodeNames = new HashSet<String>(size);
        HashSet<ClusterNode> nodes = new HashSet<ClusterNode>(size);
        for (int i = 0; i < size; ++i) {
            String nodeName = in.unpackString();
            nodeNames.add(nodeName);
            ClusterNode node = cluster.topologyService().getByConsistentId(nodeName);
            if (node == null) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            throw new NodeNotFoundException(nodeNames);
        }
        return nodes;
    }

    static CompletableFuture<ComputeJobDataHolder> sendResultAndState(CompletableFuture<JobExecution<ComputeJobDataHolder>> executionFut, NotificationSender notificationSender) {
        return executionFut.thenCompose(execution -> execution.resultAsync().whenComplete((val, err) -> execution.stateAsync().whenComplete((state, errState) -> notificationSender.sendNotification(w -> {
            Marshaller marshaller = ClientComputeExecuteRequest.extractMarshaller((JobExecution<ComputeJobDataHolder>)execution);
            ClientComputeJobPacker.packJobResult((Object)val, marshaller, (ClientMessagePacker)w);
            ClientComputeGetStateRequest.packJobState(w, state);
        }, (Throwable)err))));
    }

    static void packSubmitResult(ClientMessagePacker out, UUID jobId, ClusterNode node) {
        out.packUuid(jobId);
        ClientClusterGetNodesRequest.packClusterNode(node, out);
    }

    @Nullable
    private static <T> Marshaller<T, byte[]> extractMarshaller(JobExecution<ComputeJobDataHolder> e) {
        if (e instanceof MarshallerProvider) {
            return ((MarshallerProvider)e).resultMarshaller();
        }
        return null;
    }
}

