/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.BoundedPriorityQueue;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class SortNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private int requested;
    private int waiting;
    private boolean inLoop;
    private final PriorityQueue<RowT> rows;
    private final int limit;
    private List<RowT> reversed;

    public SortNode(ExecutionContext<RowT> ctx, Comparator<RowT> comp, @Nullable Supplier<Integer> offset, @Nullable Supplier<Integer> fetch) {
        super(ctx);
        assert (fetch == null || fetch.get() >= 0);
        assert (offset == null || offset.get() >= 0);
        int n = fetch == null ? -1 : (this.limit = fetch.get() + (offset == null ? 0 : offset.get()));
        this.rows = this.limit < 1 ? new PriorityQueue<RowT>(comp) : new BoundedPriorityQueue(this.limit, comp == null ? Comparator.reverseOrder() : comp.reversed());
    }

    public SortNode(ExecutionContext<RowT> ctx, Comparator<RowT> comp) {
        this(ctx, comp, null, null);
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.rows.clear();
        if (this.reversed != null) {
            this.reversed.clear();
        }
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        this.checkState();
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        } else if (!this.inLoop) {
            this.context().execute(this::flush, this::onError);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.reversed == null || this.reversed.isEmpty());
        this.checkState();
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.flush();
    }

    private void flush() throws Exception {
        if (this.isClosed()) {
            return;
        }
        assert (this.waiting == -1);
        int processed = 0;
        this.inLoop = true;
        try {
            if (this.limit > 0 && !this.rows.isEmpty()) {
                if (this.reversed == null) {
                    this.reversed = new ArrayList<RowT>(this.rows.size());
                }
                while (!this.rows.isEmpty()) {
                    this.reversed.add(this.rows.poll());
                    if (++processed < 512) continue;
                    this.context().execute(this::flush, this::onError);
                    return;
                }
                processed = 0;
            }
            while (this.requested > 0 && !(this.reversed != null ? this.reversed.isEmpty() : this.rows.isEmpty())) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.reversed == null ? this.rows.poll() : this.reversed.remove(this.reversed.size() - 1));
                if (++processed < 512 || this.requested <= 0) continue;
                this.context().execute(this::flush, this::onError);
                return;
            }
            if (this.reversed == null ? this.rows.isEmpty() : this.reversed.isEmpty()) {
                if (this.requested > 0) {
                    this.downstream().end();
                }
                this.requested = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
    }
}

