/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.message.TransactionMetaMessage;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateCoordinatorRequest;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class TransactionStateResolver {
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final ClusterNodeResolver clusterNodeResolver;
    private final PlacementDriverHelper placementDriverHelper;
    private final Map<UUID, CompletableFuture<TransactionMeta>> txStateFutures = new ConcurrentHashMap<UUID, CompletableFuture<TransactionMeta>>();
    private final TxManager txManager;
    private final ClockService clockService;
    private final MessagingService messagingService;
    private final TxMessageSender txMessageSender;

    public TransactionStateResolver(TxManager txManager, ClockService clockService, ClusterNodeResolver clusterNodeResolver, MessagingService messagingService, PlacementDriver placementDriver, TxMessageSender txMessageSender) {
        this.txManager = txManager;
        this.clockService = clockService;
        this.clusterNodeResolver = clusterNodeResolver;
        this.messagingService = messagingService;
        this.placementDriverHelper = new PlacementDriverHelper(placementDriver, clockService);
        this.txMessageSender = txMessageSender;
    }

    public void start() {
        this.messagingService.addMessageHandler(TxMessageGroup.class, (msg, sender, correlationId) -> {
            if (msg instanceof TxStateCoordinatorRequest) {
                TxStateCoordinatorRequest req = (TxStateCoordinatorRequest)msg;
                this.processTxStateRequest(req).thenAccept(txStateMeta -> {
                    TxStateResponse response = TX_MESSAGES_FACTORY.txStateResponse().txStateMeta(TransactionStateResolver.toTransactionMetaMessage(txStateMeta)).timestamp(this.clockService.now()).build();
                    this.messagingService.respond(sender, (NetworkMessage)response, correlationId.longValue());
                });
            }
        });
    }

    public CompletableFuture<TransactionMeta> resolveTxState(UUID txId, TablePartitionId commitGrpId, @Nullable HybridTimestamp timestamp) {
        TxStateMeta localMeta = this.txManager.stateMeta(txId);
        if (localMeta != null && TxState.isFinalState((TxState)localMeta.txState())) {
            return CompletableFuture.completedFuture(localMeta);
        }
        CompletableFuture future = this.txStateFutures.compute(txId, (k, v) -> {
            if (v == null) {
                v = new CompletableFuture<TransactionMeta>();
                this.resolveDistributiveTxState(txId, localMeta, commitGrpId, timestamp, (CompletableFuture<TransactionMeta>)v);
            }
            return v;
        });
        future.whenComplete((v, e) -> this.txStateFutures.remove(txId));
        return future;
    }

    private void resolveDistributiveTxState(UUID txId, @Nullable TxStateMeta localMeta, TablePartitionId commitGrpId, @Nullable HybridTimestamp timestamp, CompletableFuture<TransactionMeta> txMetaFuture) {
        HybridTimestamp timestamp0;
        assert (localMeta == null || !TxState.isFinalState((TxState)localMeta.txState())) : "Unexpected tx meta [txId" + String.valueOf(txId) + ", meta=" + String.valueOf(localMeta) + "]";
        HybridTimestamp hybridTimestamp = timestamp0 = timestamp == null ? HybridTimestamp.MIN_VALUE : timestamp;
        if (localMeta == null) {
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, txMetaFuture);
        } else if (localMeta.txState() == TxState.PENDING) {
            this.resolveTxStateFromTxCoordinator(txId, localMeta.txCoordinatorId(), commitGrpId, timestamp0, txMetaFuture);
        } else if (localMeta.txState() == TxState.FINISHING) {
            assert (localMeta instanceof TxStateMetaFinishing);
            ((TxStateMetaFinishing)localMeta).txFinishFuture().whenComplete((v, e) -> {
                if (e == null) {
                    txMetaFuture.complete((TransactionMeta)v);
                } else {
                    txMetaFuture.completeExceptionally((Throwable)e);
                }
            });
        } else {
            assert (localMeta.txState() == TxState.ABANDONED) : "Unexpected transaction state [txId=" + String.valueOf(txId) + ", txStateMeta=" + String.valueOf(localMeta) + "]";
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, txMetaFuture);
        }
    }

    private void resolveTxStateFromTxCoordinator(UUID txId, @Nullable UUID coordinatorId, TablePartitionId commitGrpId, HybridTimestamp timestamp, CompletableFuture<TransactionMeta> txMetaFuture) {
        ClusterNode coordinator;
        this.updateLocalTxMapAfterDistributedStateResolved(txId, txMetaFuture);
        ClusterNode clusterNode = coordinator = coordinatorId == null ? null : this.clusterNodeResolver.getById(coordinatorId);
        if (coordinator == null) {
            this.markAbandoned(txId);
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, txMetaFuture);
        } else {
            this.txMessageSender.resolveTxStateFromCoordinator(coordinator.name(), txId, timestamp).whenComplete((response, e) -> {
                if (e == null) {
                    txMetaFuture.complete(TransactionStateResolver.asTransactionMeta(response.txStateMeta()));
                } else {
                    this.resolveTxStateFromCommitPartition(txId, commitGrpId, txMetaFuture);
                }
            });
        }
    }

    private void resolveTxStateFromCommitPartition(UUID txId, TablePartitionId commitGrpId, CompletableFuture<TransactionMeta> txMetaFuture) {
        this.updateLocalTxMapAfterDistributedStateResolved(txId, txMetaFuture);
        this.sendAndRetry(txMetaFuture, commitGrpId, txId);
    }

    private void markAbandoned(UUID txId) {
        this.txManager.updateTxMeta(txId, stateMeta -> stateMeta != null ? stateMeta.abandoned() : null);
    }

    private void updateLocalTxMapAfterDistributedStateResolved(UUID txId, CompletableFuture<TransactionMeta> future) {
        future.thenAccept(txMeta -> {
            if (txMeta instanceof TxStateMeta) {
                this.txManager.updateTxMeta(txId, old -> (TxStateMeta)txMeta);
            }
        });
    }

    private void sendAndRetry(CompletableFuture<TransactionMeta> resFut, TablePartitionId replicaGrp, UUID txId) {
        ((CompletableFuture)this.placementDriverHelper.awaitPrimaryReplicaWithExceptionHandling(replicaGrp).thenCompose(replicaMeta -> this.txMessageSender.resolveTxStateFromCommitPartition(replicaMeta.getLeaseholder(), txId, replicaGrp, Long.valueOf(replicaMeta.getStartTime().longValue())))).whenComplete((txMeta, e) -> {
            if (e == null) {
                assert (txMeta != null) : "Tx State response is null";
                resFut.complete((TransactionMeta)txMeta);
            } else if (e instanceof PrimaryReplicaMissException) {
                this.sendAndRetry(resFut, replicaGrp, txId);
            } else {
                resFut.completeExceptionally((Throwable)e);
            }
        });
    }

    private CompletableFuture<@Nullable TransactionMeta> processTxStateRequest(TxStateCoordinatorRequest request) {
        this.clockService.updateClock(request.readTimestamp());
        UUID txId = request.txId();
        TxStateMeta txStateMeta = this.txManager.stateMeta(txId);
        if (txStateMeta != null && txStateMeta.txState() == TxState.FINISHING) {
            assert (txStateMeta instanceof TxStateMetaFinishing);
            TxStateMetaFinishing txStateMetaFinishing = (TxStateMetaFinishing)txStateMeta;
            return txStateMetaFinishing.txFinishFuture();
        }
        return CompletableFuture.completedFuture(txStateMeta);
    }

    @Nullable
    private static TransactionMetaMessage toTransactionMetaMessage(@Nullable TransactionMeta transactionMeta) {
        return transactionMeta == null ? null : transactionMeta.toTransactionMetaMessage(REPLICA_MESSAGES_FACTORY, TX_MESSAGES_FACTORY);
    }

    @Nullable
    private static TransactionMeta asTransactionMeta(@Nullable TransactionMetaMessage transactionMetaMessage) {
        return transactionMetaMessage == null ? null : transactionMetaMessage.asTransactionMeta();
    }
}

