/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.network.TimedBinaryRow;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.configuration.StorageUpdateConfiguration;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite.internal.table.distributed.raft.PartitionDataStorage;
import org.apache.ignite.internal.table.distributed.replicator.PendingRows;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class StorageUpdateHandler {
    private final int partitionId;
    private final PartitionDataStorage storage;
    private final IndexUpdateHandler indexUpdateHandler;
    private final PendingRows pendingRows = new PendingRows();
    private final StorageUpdateConfiguration storageUpdateConfiguration;

    public StorageUpdateHandler(int partitionId, PartitionDataStorage storage, IndexUpdateHandler indexUpdateHandler, StorageUpdateConfiguration storageUpdateConfiguration) {
        this.partitionId = partitionId;
        this.storage = storage;
        this.indexUpdateHandler = indexUpdateHandler;
        this.storageUpdateConfiguration = storageUpdateConfiguration;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public void handleUpdate(UUID txId, UUID rowUuid, TablePartitionId commitPartitionId, @Nullable BinaryRow row, boolean trackWriteIntent, @Nullable Runnable onApplication, @Nullable HybridTimestamp commitTs, @Nullable HybridTimestamp lastCommitTs, @Nullable List<Integer> indexIds) {
        this.storage.runConsistently(locker -> {
            int commitTblId = commitPartitionId.tableId();
            int commitPartId = commitPartitionId.partitionId();
            RowId rowId = new RowId(this.partitionId, rowUuid);
            this.tryProcessRow(locker, commitTblId, commitPartId, rowId, txId, row, lastCommitTs, commitTs, false, indexIds);
            if (trackWriteIntent) {
                this.pendingRows.addPendingRowId(txId, rowId);
            }
            if (onApplication != null) {
                onApplication.run();
            }
            return null;
        });
    }

    private boolean tryProcessRow(MvPartitionStorage.Locker locker, int commitTblId, int commitPartId, RowId rowId, UUID txId, @Nullable BinaryRow row, @Nullable HybridTimestamp lastCommitTs, @Nullable HybridTimestamp commitTs, boolean useTryLock, @Nullable List<Integer> indexIds) {
        if (useTryLock) {
            if (!locker.tryLock(rowId)) {
                return false;
            }
        } else {
            locker.lock(rowId);
        }
        this.performStorageCleanupIfNeeded(txId, rowId, lastCommitTs, indexIds);
        if (commitTs != null) {
            this.storage.addWriteCommitted(rowId, row, commitTs);
        } else {
            BinaryRow oldRow = this.storage.addWrite(rowId, row, txId, commitTblId, commitPartId);
            if (oldRow != null) {
                assert (commitTs == null) : String.format("Expecting explicit txn: [txId=%s]", txId);
                this.tryRemovePreviousWritesIndex(rowId, oldRow, indexIds);
            }
        }
        this.indexUpdateHandler.addToIndexes(row, rowId, indexIds);
        return true;
    }

    public void handleUpdateAll(UUID txId, Map<UUID, TimedBinaryRow> rowsToUpdate, TablePartitionId commitPartitionId, boolean trackWriteIntent, @Nullable Runnable onApplication, @Nullable HybridTimestamp commitTs, @Nullable List<Integer> indexIds) {
        if (CollectionUtils.nullOrEmpty(rowsToUpdate)) {
            return;
        }
        int commitTblId = commitPartitionId.tableId();
        int commitPartId = commitPartitionId.partitionId();
        Iterator<Map.Entry<UUID, TimedBinaryRow>> it = rowsToUpdate.entrySet().iterator();
        Map.Entry<UUID, TimedBinaryRow> lastUnprocessedEntry = it.next();
        while (lastUnprocessedEntry != null) {
            lastUnprocessedEntry = this.processEntriesUntilBatchLimit(lastUnprocessedEntry, txId, trackWriteIntent, commitTs, commitTblId, commitPartId, it, onApplication, (Integer)this.storageUpdateConfiguration.batchByteLength().value(), indexIds);
        }
    }

    private Map.Entry<UUID, TimedBinaryRow> processEntriesUntilBatchLimit(Map.Entry<UUID, TimedBinaryRow> lastUnprocessedEntry, UUID txId, boolean trackWriteIntent, @Nullable HybridTimestamp commitTs, int commitTblId, int commitPartId, Iterator<Map.Entry<UUID, TimedBinaryRow>> it, @Nullable Runnable onApplication, int maxBatchLength, @Nullable List<Integer> indexIds) {
        return (Map.Entry)this.storage.runConsistently(locker -> {
            ArrayList<RowId> processedRowIds = new ArrayList<RowId>();
            int batchLength = 0;
            Map.Entry entryToProcess = lastUnprocessedEntry;
            while (entryToProcess != null) {
                boolean rowProcessed;
                BinaryRow row;
                RowId rowId = new RowId(this.partitionId, (UUID)entryToProcess.getKey());
                BinaryRow binaryRow = row = entryToProcess.getValue() == null ? null : ((TimedBinaryRow)entryToProcess.getValue()).binaryRow();
                if (row != null) {
                    batchLength += row.tupleSliceLength();
                }
                if (!processedRowIds.isEmpty() && batchLength > maxBatchLength || !(rowProcessed = this.tryProcessRow(locker, commitTblId, commitPartId, rowId, txId, row, entryToProcess.getValue() == null ? null : ((TimedBinaryRow)entryToProcess.getValue()).commitTimestamp(), commitTs, !processedRowIds.isEmpty(), indexIds))) break;
                entryToProcess = it.hasNext() ? (Map.Entry)it.next() : null;
                processedRowIds.add(rowId);
            }
            if (trackWriteIntent) {
                this.pendingRows.addPendingRowIds(txId, processedRowIds);
            }
            if (entryToProcess == null && onApplication != null) {
                onApplication.run();
            }
            return entryToProcess;
        });
    }

    private void performStorageCleanupIfNeeded(UUID txId, RowId rowId, @Nullable HybridTimestamp lastCommitTs, @Nullable List<Integer> indexIds) {
        if (lastCommitTs == null) {
            return;
        }
        try (Cursor<ReadResult> cursor = this.storage.scanVersions(rowId);){
            if (!cursor.hasNext()) {
                return;
            }
            ReadResult item = (ReadResult)cursor.next();
            if (item.isWriteIntent() && !txId.equals(item.transactionId())) {
                if (!cursor.hasNext()) {
                    this.performCommitWrite(item.transactionId(), Set.of(rowId), lastCommitTs);
                    return;
                }
                ReadResult committedItem = (ReadResult)cursor.next();
                assert (!committedItem.isWriteIntent()) : "Cannot have more than one write intent per row";
                assert (lastCommitTs.compareTo(committedItem.commitTimestamp()) >= 0) : "Primary commit timestamp " + String.valueOf(lastCommitTs) + " is earlier than local commit timestamp " + String.valueOf(committedItem.commitTimestamp());
                if (lastCommitTs.compareTo(committedItem.commitTimestamp()) > 0) {
                    this.performCommitWrite(item.transactionId(), Set.of(rowId), lastCommitTs);
                } else {
                    this.performAbortWrite(item.transactionId(), Set.of(rowId), indexIds);
                }
            }
        }
    }

    private void tryRemovePreviousWritesIndex(RowId rowId, BinaryRow previousRow, @Nullable List<Integer> indexIds) {
        try (Cursor<ReadResult> cursor = this.storage.scanVersions(rowId);){
            if (!cursor.hasNext()) {
                return;
            }
            this.indexUpdateHandler.tryRemoveFromIndexes(previousRow, rowId, cursor, indexIds);
        }
    }

    public void handleWriteIntentRead(UUID txId, RowId rowId) {
        this.pendingRows.addPendingRowId(txId, rowId);
    }

    public void switchWriteIntents(UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp, @Nullable List<Integer> indexIds) {
        this.switchWriteIntents(txId, commit, commitTimestamp, null, indexIds);
    }

    public void switchWriteIntents(UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp, @Nullable Runnable onApplication, @Nullable List<Integer> indexIds) {
        Set<RowId> pendingRowIds = this.pendingRows.removePendingRowIds(txId);
        if (!pendingRowIds.isEmpty() || onApplication != null) {
            this.storage.runConsistently(locker -> {
                pendingRowIds.forEach(arg_0 -> ((MvPartitionStorage.Locker)locker).lock(arg_0));
                if (commit) {
                    this.performCommitWrite(txId, pendingRowIds, commitTimestamp);
                } else {
                    this.performAbortWrite(txId, pendingRowIds, indexIds);
                }
                if (onApplication != null) {
                    onApplication.run();
                }
                return null;
            });
        }
    }

    private void performCommitWrite(UUID txId, Set<RowId> pendingRowIds, HybridTimestamp commitTimestamp) {
        assert (commitTimestamp != null) : "Commit timestamp is null";
        ArrayList<RowId> rowIds = new ArrayList<RowId>();
        for (RowId pendingRowId : pendingRowIds) {
            ReadResult result = this.storage.getStorage().read(pendingRowId, HybridTimestamp.MAX_VALUE);
            if (!result.isWriteIntent() || !txId.equals(result.transactionId())) continue;
            rowIds.add(pendingRowId);
        }
        rowIds.forEach(rowId -> this.storage.commitWrite((RowId)rowId, commitTimestamp));
    }

    private void performAbortWrite(UUID txId, Set<RowId> pendingRowIds, @Nullable List<Integer> indexIds) {
        ArrayList<RowId> rowIds = new ArrayList<RowId>();
        for (RowId rowId : pendingRowIds) {
            Cursor<ReadResult> cursor = this.storage.scanVersions(rowId);
            try {
                ReadResult item;
                if (!cursor.hasNext() || !(item = (ReadResult)cursor.next()).isWriteIntent() || !txId.equals(item.transactionId())) continue;
                rowIds.add(rowId);
                BinaryRow rowToRemove = item.binaryRow();
                if (rowToRemove == null) continue;
                this.indexUpdateHandler.tryRemoveFromIndexes(rowToRemove, rowId, cursor, indexIds);
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
        rowIds.forEach(this.storage::abortWrite);
    }

    public IndexUpdateHandler getIndexUpdateHandler() {
        return this.indexUpdateHandler;
    }
}

