/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.deprecated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import picocli.CommandLine;

public class Table {
    private final int indent;
    private final CommandLine.Help.ColorScheme cs;
    private final Collection<Row> data = new ArrayList<Row>();
    private int[] lengths;

    public Table(int indent, CommandLine.Help.ColorScheme cs) {
        if (indent < 0) {
            throw new IllegalArgumentException("Indent can't be negative.");
        }
        this.indent = indent;
        this.cs = cs;
    }

    public void addRow(Object ... items) {
        if (this.lengths == null) {
            this.lengths = new int[items.length];
        } else if (items.length != this.lengths.length) {
            throw new IllegalArgumentException("Wrong number of items.");
        }
        CommandLine.Help.Ansi.Text[] row = new CommandLine.Help.Ansi.Text[items.length];
        for (int i = 0; i < items.length; ++i) {
            CommandLine.Help.Ansi.Text text;
            Object item = items[i];
            row[i] = text = item instanceof CommandLine.Help.Ansi.Text ? (CommandLine.Help.Ansi.Text)item : this.cs.text(item.toString());
            this.lengths[i] = Math.max(this.lengths[i], text.getCJKAdjustedLength());
        }
        this.data.add(new DataRow(row));
    }

    public void addSection(Object title) {
        CommandLine.Help.Ansi.Text text = title instanceof CommandLine.Help.Ansi.Text ? (CommandLine.Help.Ansi.Text)title : this.cs.text(title.toString());
        this.data.add(new SectionTitle(text));
    }

    public String toString() {
        if (this.data.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Row row : this.data) {
            this.appendLine(sb);
            this.appendRow(sb, row);
        }
        this.appendLine(sb);
        return sb.toString().stripTrailing();
    }

    private void appendLine(StringBuilder sb) {
        sb.append(" ".repeat(this.indent));
        for (int length : this.lengths) {
            sb.append('+').append("-".repeat(length + 2));
        }
        sb.append("+\n");
    }

    private void appendRow(StringBuilder sb, Row row) {
        sb.append(" ".repeat(this.indent)).append(row.render()).append('\n');
    }

    private class SectionTitle
    implements Row {
        private final CommandLine.Help.Ansi.Text title;

        SectionTitle(CommandLine.Help.Ansi.Text title) {
            this.title = title;
        }

        @Override
        public String render() {
            int totalLen = Arrays.stream(Table.this.lengths).sum() + 3 * (Table.this.lengths.length - 1);
            return "| " + this.title.toString() + " ".repeat(totalLen - this.title.getCJKAdjustedLength()) + " |";
        }
    }

    private class DataRow
    implements Row {
        private final CommandLine.Help.Ansi.Text[] row;

        DataRow(CommandLine.Help.Ansi.Text[] row) {
            this.row = row;
        }

        @Override
        public String render() {
            assert (this.row.length == Table.this.lengths.length);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.row.length; ++i) {
                CommandLine.Help.Ansi.Text item = this.row[i];
                sb.append("| ").append(item.toString()).append(" ".repeat(Table.this.lengths[i] + 1 - item.getCJKAdjustedLength()));
            }
            sb.append("|");
            return sb.toString();
        }
    }

    private static interface Row {
        public String render();
    }
}

