/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception.handler;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.client.IgniteClientConnectionException;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.apache.ignite.lang.IgniteException;

public class SqlExceptionHandler
implements ExceptionHandler<SQLException> {
    private static final IgniteLogger LOG = Loggers.forClass(SqlExceptionHandler.class);
    public static final String PARSING_ERROR_MESSAGE = "SQL query parsing error";
    public static final String INVALID_PARAMETER_MESSAGE = "Invalid parameter value";
    public static final String CLIENT_CONNECTION_FAILED_MESSAGE = "Connection failed";
    public static final String CONNECTION_BROKE_MESSAGE = "Connection error";
    public static final String UNRECOGNIZED_ERROR_MESSAGE = "Unrecognized error while processing SQL query ";
    private final Map<Integer, Function<IgniteException, ErrorUiComponent.ErrorComponentBuilder>> sqlExceptionMappers = new HashMap<Integer, Function<IgniteException, ErrorUiComponent.ErrorComponentBuilder>>();

    public SqlExceptionHandler() {
        this.sqlExceptionMappers.put(ErrorGroups.Client.CONNECTION_ERR, this::connectionErrUiComponent);
        this.sqlExceptionMappers.put(ErrorGroups.Sql.QUERY_INVALID_ERR, this::invalidQueryErrUiComponent);
    }

    private ErrorUiComponent.ErrorComponentBuilder invalidQueryErrUiComponent(IgniteException e) {
        return SqlExceptionHandler.fromExWithHeader(PARSING_ERROR_MESSAGE, e.errorCode(), e.traceId(), e.getMessage());
    }

    private ErrorUiComponent.ErrorComponentBuilder unrecognizedErrComponent(IgniteException e) {
        return SqlExceptionHandler.fromExWithHeader(UNRECOGNIZED_ERROR_MESSAGE, e.errorCode(), e.traceId(), e.getMessage());
    }

    private ErrorUiComponent.ErrorComponentBuilder connectionErrUiComponent(IgniteException e) {
        if (e.getCause() instanceof IgniteClientConnectionException) {
            IgniteClientConnectionException cause = (IgniteClientConnectionException)e.getCause();
            return SqlExceptionHandler.fromExWithHeader(CLIENT_CONNECTION_FAILED_MESSAGE, cause.errorCode(), cause.traceId(), cause.getMessage());
        }
        return SqlExceptionHandler.fromExWithHeader(CLIENT_CONNECTION_FAILED_MESSAGE, e.errorCode(), e.traceId(), e.getMessage());
    }

    private static ErrorUiComponent.ErrorComponentBuilder fromExWithHeader(String header, int errorCode, UUID traceId, String message) {
        return ErrorUiComponent.builder().header(header, new UiElement[0]).errorCode(String.valueOf(errorCode)).traceId(traceId).details(ErrorGroup.extractCauseMessage((String)message), new UiElement[0]);
    }

    @Override
    public int handle(ExceptionWriter err, SQLException e) {
        Throwable unwrappedCause = ExceptionUtils.unwrapCause((Throwable)e.getCause());
        if (unwrappedCause instanceof IgniteException) {
            return this.handleIgniteException(err, (IgniteException)unwrappedCause);
        }
        if (unwrappedCause instanceof IgniteCheckedException) {
            return this.handleIgniteCheckedException(err, (IgniteCheckedException)unwrappedCause);
        }
        ErrorUiComponent.ErrorComponentBuilder errorComponentBuilder = ErrorUiComponent.builder();
        switch (e.getSQLState()) {
            case "08006": 
            case "08003": 
            case "08004": {
                errorComponentBuilder.header(CONNECTION_BROKE_MESSAGE, new UiElement[0]).verbose(ErrorGroup.extractCauseMessage((String)e.getMessage()), new UiElement[0]);
                break;
            }
            case "42000": {
                errorComponentBuilder.header(PARSING_ERROR_MESSAGE, new UiElement[0]).details(ErrorGroup.extractCauseMessage((String)e.getMessage()), new UiElement[0]);
                break;
            }
            case "22023": {
                errorComponentBuilder.header(INVALID_PARAMETER_MESSAGE, new UiElement[0]).verbose(ErrorGroup.extractCauseMessage((String)e.getMessage()), new UiElement[0]);
                break;
            }
            case "08001": {
                errorComponentBuilder.header(CLIENT_CONNECTION_FAILED_MESSAGE, new UiElement[0]).verbose(ErrorGroup.extractCauseMessage((String)e.getMessage()), new UiElement[0]);
                break;
            }
            default: {
                LOG.error("Unrecognized error", (Throwable)e);
                errorComponentBuilder.header("SQL query execution error", new UiElement[0]).details(e.getMessage(), new UiElement[0]);
            }
        }
        err.write(errorComponentBuilder.build().render());
        return 1;
    }

    private int handleIgniteException(ExceptionWriter err, IgniteException e) {
        Function<IgniteException, ErrorUiComponent.ErrorComponentBuilder> errorComponentBuilder = this.sqlExceptionMappers.getOrDefault(e.code(), this::unrecognizedErrComponent);
        String renderedError = errorComponentBuilder.apply(e).build().render();
        err.write(renderedError);
        return 1;
    }

    private int handleIgniteCheckedException(ExceptionWriter err, IgniteCheckedException e) {
        String renderedError = SqlExceptionHandler.fromExWithHeader(UNRECOGNIZED_ERROR_MESSAGE, e.errorCode(), e.traceId(), e.getMessage()).build().render();
        err.write(renderedError);
        return 1;
    }

    @Override
    public Class<SQLException> applicableException() {
        return SQLException.class;
    }
}

