/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteCustomType;
import org.apache.ignite.internal.processors.query.calcite.type.OtherType;
import org.apache.ignite.internal.processors.query.calcite.type.UuidType;
import org.jetbrains.annotations.Nullable;

public class IgniteTypeCoercion
extends TypeCoercionImpl {
    public IgniteTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        RelDataType rightType;
        SqlCall call = binding.getCall();
        if (binding.getOperandCount() != 2 || !SqlKind.BINARY_COMPARISON.contains(call.getKind())) {
            return super.binaryComparisonCoercion(binding);
        }
        SqlValidatorScope scope = binding.getScope();
        RelDataType leftType = this.validator.deriveType(scope, call.operand(0));
        if (leftType.equals(rightType = this.validator.deriveType(scope, call.operand(1)))) {
            return super.binaryComparisonCoercion(binding);
        }
        RelDataType targetType = this.factory.leastRestrictive(Arrays.asList(leftType, rightType));
        if (targetType == null || targetType.getFamily() == SqlTypeFamily.ANY) {
            return super.binaryComparisonCoercion(binding);
        }
        return this.coerceOperandsType(scope, call, targetType);
    }

    protected boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int idx, RelDataType targetType) {
        if (targetType instanceof IgniteCustomType) {
            SqlNode operand = (SqlNode)call.getOperandList().get(idx);
            RelDataType fromType = this.validator.deriveType(scope, operand);
            if (fromType == null) {
                return false;
            }
            if (SqlTypeUtil.inCharFamily((RelDataType)fromType) || targetType instanceof OtherType) {
                targetType = this.factory.createTypeWithNullability(targetType, fromType.isNullable());
                SqlCall desired = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{operand, new SqlDataTypeSpec((SqlTypeNameSpec)new SqlUserDefinedTypeNameSpec(targetType.toString(), SqlParserPos.ZERO), SqlParserPos.ZERO).withNullable(Boolean.valueOf(targetType.isNullable()))});
                call.setOperand(idx, (SqlNode)desired);
                this.updateInferredType((SqlNode)desired, targetType);
                return true;
            }
            return false;
        }
        if (RelDataTypeFactoryImpl.isJavaType((RelDataType)targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        SqlNode operand = (SqlNode)call.getOperandList().get(idx);
        Objects.requireNonNull(scope, "scope");
        if (!this.needToCast(scope, operand, targetType)) {
            return false;
        }
        RelDataType targetType1 = this.syncAttributes(this.validator.deriveType(scope, operand), targetType);
        SqlNode desired = IgniteTypeCoercion.castTo(operand, targetType1);
        call.setOperand(idx, desired);
        this.updateInferredType(desired, targetType1);
        return true;
    }

    public RelDataType commonTypeForBinaryComparison(RelDataType type1, RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1 instanceof UuidType && SqlTypeUtil.isCharacter((RelDataType)type2)) {
            return type1;
        }
        if (type2 instanceof UuidType && SqlTypeUtil.isCharacter((RelDataType)type1)) {
            return type2;
        }
        return super.commonTypeForBinaryComparison(type1, type2);
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType toType) {
        if (SqlTypeUtil.isInterval((RelDataType)toType)) {
            RelDataType fromType = this.validator.deriveType(scope, node);
            if (SqlTypeUtil.isInterval((RelDataType)fromType)) {
                return fromType.getSqlTypeName().getFamily() != toType.getSqlTypeName().getFamily();
            }
        } else if (SqlTypeUtil.isIntType((RelDataType)toType)) {
            RelDataType fromType = this.validator.deriveType(scope, node);
            if (fromType == null) {
                return false;
            }
            if (SqlTypeUtil.isIntType((RelDataType)fromType) && fromType.getSqlTypeName() != toType.getSqlTypeName()) {
                return true;
            }
        }
        return super.needToCast(scope, node, toType);
    }

    protected boolean coerceColumnType(@Nullable SqlValidatorScope scope, SqlNodeList nodeList, int idx, RelDataType targetType) {
        if (RelDataTypeFactoryImpl.isJavaType((RelDataType)targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if (idx >= nodeList.size()) {
            return true;
        }
        SqlNode node = nodeList.get(idx);
        if (node instanceof SqlIdentifier) {
            SqlIdentifier node1 = (SqlIdentifier)node;
            if (node1.isStar()) {
                return true;
            }
            if (DynamicRecordType.isDynamicStarColName((String)((String)Util.last((List)node1.names)))) {
                return false;
            }
        }
        Objects.requireNonNull(scope, "scope is needed for needToCast(scope, operand, targetType)");
        if (node instanceof SqlCall) {
            SqlCall node2 = (SqlCall)node;
            if (node2.getOperator().kind == SqlKind.AS) {
                SqlNode operand = node2.operand(0);
                if (!this.needToCast(scope, operand, targetType)) {
                    return false;
                }
                RelDataType targetType2 = this.syncAttributes(this.validator.deriveType(scope, operand), targetType);
                SqlNode casted = IgniteTypeCoercion.castTo(operand, targetType2);
                node2.setOperand(0, casted);
                this.updateInferredType(casted, targetType2);
                return true;
            }
        }
        if (!this.needToCast(scope, node, targetType)) {
            return false;
        }
        RelDataType targetType3 = this.syncAttributes(this.validator.deriveType(scope, node), targetType);
        SqlNode node3 = IgniteTypeCoercion.castTo(node, targetType3);
        nodeList.set(idx, node3);
        this.updateInferredType(node3, targetType3);
        return true;
    }

    private RelDataType syncAttributes(RelDataType fromType, RelDataType toType) {
        RelDataType syncedType = toType;
        if (fromType != null) {
            Charset charset;
            syncedType = this.factory.createTypeWithNullability(syncedType, fromType.isNullable());
            if (SqlTypeUtil.inCharOrBinaryFamilies((RelDataType)fromType) && SqlTypeUtil.inCharOrBinaryFamilies((RelDataType)toType) && (charset = fromType.getCharset()) != null && SqlTypeUtil.inCharFamily((RelDataType)syncedType)) {
                SqlCollation collation = NonNullableAccessors.getCollation((RelDataType)fromType);
                syncedType = this.factory.createTypeWithCharsetAndCollation(syncedType, charset, collation);
            }
        }
        return syncedType;
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{node, SqlTypeUtil.convertTypeToSpec((RelDataType)type).withNullable(Boolean.valueOf(type.isNullable()))});
    }
}

