/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc.vendors;

public class QueryFactory {
    public String createPersonTab() {
        return "CREATE TABLE PUBLIC.PERSON (id BIGINT PRIMARY KEY, org_id BIGINT, first_name VARCHAR(255), last_name VARCHAR(255), salary BIGINT);";
    }

    public String createOrgTab() {
        return "CREATE TABLE PUBLIC.ORGANIZATION (id BIGINT PRIMARY KEY, name VARCHAR(255));";
    }

    public String createSalaryIdx() {
        return "CREATE INDEX sal_idx ON PUBLIC.PERSON(salary);";
    }

    public String createOrgIdIdx() {
        return "CREATE INDEX org_id_idx ON PUBLIC.PERSON(org_id)";
    }

    public String dropPersonIfExist() {
        return "DROP TABLE IF EXISTS PUBLIC.PERSON;";
    }

    public String dropOrgIfExist() {
        return "DROP TABLE IF EXISTS PUBLIC.ORGANIZATION;";
    }

    public String beforeLoad() {
        return null;
    }

    public String afterLoad() {
        return null;
    }

    public String selectPersonsWithSalaryBetween() {
        return "SELECT * FROM PUBLIC.PERSON WHERE SALARY BETWEEN ? AND ?";
    }

    public String selectPersonsByPK() {
        return "SELECT * FROM PUBLIC.PERSON WHERE id = ? ;";
    }

    public String insertIntoPerson() {
        return "INSERT INTO PUBLIC.PERSON (id, org_id, first_name, last_name, salary) values (?, ?, ?, ?, ?)";
    }

    public String insertIntoOrganization() {
        return "INSERT INTO PUBLIC.ORGANIZATION (id, name) VALUES (?, ?);";
    }

    public String selectPersonsJoinOrgWhereSalary() {
        return "SELECT p.id, p.org_id, p.first_name, p.last_name, p.salary, o.name FROM PUBLIC.PERSON p INNER JOIN PUBLIC.ORGANIZATION o ON p.org_id = o.id WHERE salary BETWEEN ? AND ?;";
    }

    public String selectPersonsJoinOrgWherePersonPK() {
        return "SELECT p.id, p.org_id, p.first_name, p.last_name, p.salary, o.name FROM PUBLIC.PERSON p INNER JOIN PUBLIC.ORGANIZATION o ON p.org_id = o.id WHERE p.id = ?;";
    }

    public String selectAllPersons() {
        return "SELECT * FROM PUBLIC.PERSON;";
    }

    public String selectAllPersonsJoinOrg() {
        return "SELECT p.id, p.org_id, p.first_name, p.last_name, p.salary, o.name FROM PUBLIC.PERSON p INNER JOIN PUBLIC.ORGANIZATION o ON p.org_id = o.id;";
    }
}

