/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutAllBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final Integer PUT_MAPS_KEY = 2048;
    private static final Integer PUT_MAPS_CNT = 256;
    private Affinity<Integer> aff;
    AtomicInteger threadIdent = new AtomicInteger();
    List<Map<Integer, Map<Integer, Integer>>> batchMaps;

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.threadIdent.get() != this.batchMaps.size()) {
            throw new IgniteException("Some workers are not initialized.");
        }
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        int i;
        super.setUp(cfg);
        int threadsCnt = cfg.threads();
        this.batchMaps = new ArrayList<Map<Integer, Map<Integer, Integer>>>(threadsCnt);
        for (i = 0; i < threadsCnt; ++i) {
            this.batchMaps.add(null);
        }
        for (i = 0; i < threadsCnt; ++i) {
            for (int m = 0; m < PUT_MAPS_CNT; ++m) {
                ClusterNode node;
                TreeMap<Integer, Integer> vals = new TreeMap<Integer, Integer>();
                ClusterNode clusterNode = node = this.args.collocated() ? this.aff.mapKeyToNode((Object)IgnitePutAllBenchmark.nextRandom(this.args.range())) : null;
                while (vals.size() < this.args.batch()) {
                    int key = IgnitePutAllBenchmark.nextRandom(this.args.range());
                    if (this.args.collocated() && !this.aff.isPrimary(node, (Object)key)) continue;
                    vals.put(key, key);
                }
                Map<Integer, Map<Integer, Integer>> map = this.batchMaps.get(i);
                if (map == null) {
                    map = new HashMap<Integer, Map<Integer, Integer>>();
                    this.batchMaps.set(i, map);
                }
                map.put(m, vals);
            }
        }
        this.aff = this.ignite().affinity(this.cache().getName());
        IgniteLogger log = this.ignite().log();
        if (log.isInfoEnabled()) {
            log.info("Initialization completed, batches predefined for " + threadsCnt + "threads.");
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        if (ctx.isEmpty()) {
            int currCeil = this.threadIdent.getAndIncrement();
            Map<Integer, Map<Integer, Integer>> batches = this.batchMaps.get(currCeil);
            ctx.put(PUT_MAPS_KEY, batches);
        }
        Map batches = (Map)ctx.get(PUT_MAPS_KEY);
        Map vals = (Map)batches.get(IgnitePutAllBenchmark.nextRandom(PUT_MAPS_CNT));
        this.putData(vals);
        return true;
    }

    protected void putData(Map<Integer, Integer> vals) throws Exception {
        IgniteCache cache = this.cacheForOperation();
        cache.putAll(vals);
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("atomic");
    }
}

