/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ThreadLocalDirectByteBuffer
extends ThreadLocal<ByteBuffer> {
    private final int size;
    private final ByteOrder order;

    public ThreadLocalDirectByteBuffer() {
        this(-1);
    }

    public ThreadLocalDirectByteBuffer(int size) {
        this(size, null);
    }

    public ThreadLocalDirectByteBuffer(int size, ByteOrder order) {
        this.size = size;
        this.order = order;
    }

    @Override
    protected ByteBuffer initialValue() {
        return this.size > 0 ? this.allocateDirectBuffer(this.size) : null;
    }

    public ByteBuffer get(int capacity) {
        assert (capacity > 0) : capacity;
        ByteBuffer buf = (ByteBuffer)super.get();
        if (buf == null || buf.capacity() < capacity) {
            buf = this.allocateDirectBuffer(capacity);
            this.set(buf);
        } else {
            buf.clear();
            buf.limit(capacity);
        }
        return buf;
    }

    @Override
    public ByteBuffer get() {
        assert (this.size > 0) : this.size;
        ByteBuffer buf = (ByteBuffer)super.get();
        buf.clear();
        return buf;
    }

    protected ByteBuffer allocateDirectBuffer(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        if (this.order != null) {
            buf = buf.order(this.order);
        }
        return buf;
    }
}

