/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.reloading;

import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.Scope;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.reloading.ReloadingFeature;
import org.grails.forge.options.Options;

@Singleton
public class SpringBootDevTools
implements ReloadingFeature,
DefaultFeature {
    @Override
    public String getName() {
        return "spring-boot-devtools";
    }

    @Override
    public String getTitle() {
        return "SpringBoot Developer Tools";
    }

    @Override
    public String getDescription() {
        return "Spring Boot Devtools is a powerful tool that enhances development productivity by providing features like automatic application restarts on code changes, live reloading of static resources, and remote debugging support. It enables developers to rapidly iterate and test changes during the development process, making it a valuable asset for Spring Boot projects.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("org.springframework.boot").artifactId("spring-boot-devtools").scope(Scope.DEVELOPMENT_ONLY).build());
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return selectedFeatures.stream().noneMatch(f -> f instanceof ReloadingFeature);
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public String getDocumentation() {
        return "https://docs.spring.io/spring-boot/reference/using/devtools.html";
    }
}

