/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl.role;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.service.useradmin.Role;

public class RoleImpl
implements Serializable,
Role {
    private static final long serialVersionUID = 6403795608776837916L;
    private final Properties m_properties;
    private final String m_name;
    private final int m_type;

    public RoleImpl(String name) {
        this(0, name);
    }

    protected RoleImpl(int type, String name) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        this.m_type = type;
        this.m_name = name;
        this.m_properties = new Properties();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RoleImpl other = (RoleImpl)obj;
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        return this.m_type == other.m_type;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Dictionary getProperties() {
        return this.m_properties;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + this.m_type;
        return result;
    }

    public String toString() {
        return "Role(" + this.getName() + ")";
    }
}

