/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.dto.ListenerDTOBuilder;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.servlet.runtime.dto.FailedListenerDTO;
import org.osgi.service.servlet.runtime.dto.ListenerDTO;

public class ListenerMap<T extends EventListener> {
    private volatile List<ListenerRegistrationStatus<T>> handlers = Collections.emptyList();

    public synchronized void cleanup() {
        this.handlers = Collections.emptyList();
    }

    public synchronized void add(ListenerHandler handler, int reason) {
        ListenerRegistrationStatus status = new ListenerRegistrationStatus(handler, reason);
        ArrayList<ListenerRegistrationStatus<T>> newList = new ArrayList<ListenerRegistrationStatus<T>>(this.handlers);
        newList.add(status);
        Collections.sort(newList);
        this.handlers = newList;
    }

    public synchronized ListenerHandler remove(ListenerInfo info) {
        ArrayList<ListenerRegistrationStatus<T>> newList = new ArrayList<ListenerRegistrationStatus<T>>(this.handlers);
        Iterator i = newList.iterator();
        while (i.hasNext()) {
            ListenerRegistrationStatus status = (ListenerRegistrationStatus)i.next();
            if (!status.getHandler().getListenerInfo().equals(info)) continue;
            i.remove();
            this.handlers = newList;
            return status.getResult() == -1 ? status.getHandler() : null;
        }
        return null;
    }

    public ListenerHandler getListenerHandler(@NotNull ListenerInfo info) {
        List<ListenerRegistrationStatus<T>> list = this.handlers;
        for (ListenerRegistrationStatus<T> status : list) {
            if (!status.getHandler().getListenerInfo().equals(info)) continue;
            return status.getHandler();
        }
        return null;
    }

    public Iterable<ListenerHandler> getActiveHandlers() {
        List<ListenerRegistrationStatus<T>> list = this.handlers;
        final Iterator<ListenerRegistrationStatus<T>> iter = list.iterator();
        final Iterator<ListenerHandler> newIter = new Iterator<ListenerHandler>(){
            private ListenerHandler next;
            {
                this.peek();
            }

            private void peek() {
                ListenerRegistrationStatus status;
                this.next = null;
                if (iter.hasNext() && (status = (ListenerRegistrationStatus)iter.next()).getResult() == -1) {
                    this.next = status.getHandler();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ListenerHandler next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ListenerHandler result = this.next;
                this.peek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<ListenerHandler>(){

            @Override
            public Iterator<ListenerHandler> iterator() {
                return newIter;
            }
        };
    }

    public Iterable<T> getActiveListeners() {
        final Iterator<ListenerHandler> iter = this.getActiveHandlers().iterator();
        final Iterator newIter = new Iterator<T>(){
            private T next;
            {
                this.peek();
            }

            private void peek() {
                this.next = null;
                while (this.next == null && iter.hasNext()) {
                    ListenerHandler handler = (ListenerHandler)iter.next();
                    this.next = handler.getListener();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.peek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return newIter;
            }
        };
    }

    public void getRuntimeInfo(List<ListenerDTO> listenerDTOs, List<FailedListenerDTO> failedListenerDTOs) {
        int length = listenerDTOs.size();
        int failedLength = failedListenerDTOs.size();
        List<ListenerRegistrationStatus<T>> list = this.handlers;
        for (ListenerRegistrationStatus<T> status : list) {
            ListenerDTO dto;
            int index;
            Iterator<ListenerDTO> i;
            boolean found;
            if (status.getResult() == -1) {
                found = false;
                i = listenerDTOs.iterator();
                for (index = 0; !found && index < length; ++index) {
                    dto = i.next();
                    if (dto.serviceId != status.getHandler().getListenerInfo().getServiceId()) continue;
                    found = true;
                }
                if (found) continue;
                listenerDTOs.add(ListenerDTOBuilder.build(status.getHandler(), status.getResult()));
                continue;
            }
            found = false;
            i = failedListenerDTOs.iterator();
            for (index = 0; !found && index < failedLength; ++index) {
                dto = (FailedListenerDTO)i.next();
                if (dto.serviceId != status.getHandler().getListenerInfo().getServiceId() || dto.failureReason != status.getResult()) continue;
                found = true;
            }
            if (found) continue;
            failedListenerDTOs.add((FailedListenerDTO)ListenerDTOBuilder.build(status.getHandler(), status.getResult()));
        }
    }

    private static final class ListenerRegistrationStatus<T>
    implements Comparable<ListenerRegistrationStatus<T>> {
        private final int result;
        private final ListenerHandler handler;

        public ListenerRegistrationStatus(@NotNull ListenerHandler handler, int result) {
            this.handler = handler;
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }

        @NotNull
        public ListenerHandler getHandler() {
            return this.handler;
        }

        @Override
        public int compareTo(ListenerRegistrationStatus<T> o) {
            int result = this.result - o.result;
            if (result == 0) {
                result = this.handler.compareTo(o.handler);
            }
            return result;
        }
    }
}

