/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.DeploymentAdminConfig;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.deploymentadmin.spi.DeploymentSession;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DeploymentSessionImpl
implements DeploymentSession,
Constants {
    private final AbstractDeploymentPackage m_target;
    private final AbstractDeploymentPackage m_source;
    private final List m_commands;
    private final DeploymentAdminImpl m_admin;
    private final DeploymentAdminConfig m_config;
    private volatile Command m_currentCommand = null;
    private volatile boolean m_cancelled;

    public DeploymentSessionImpl(AbstractDeploymentPackage source, AbstractDeploymentPackage target, List commands, DeploymentAdminImpl admin, DeploymentAdminConfig config) {
        this.m_source = source;
        this.m_target = target;
        this.m_commands = commands;
        this.m_admin = admin;
        this.m_config = config;
    }

    public void call(boolean ignoreExceptions) throws DeploymentException {
        ArrayList<Command> executedCommands = new ArrayList<Command>();
        Iterator i = this.m_commands.iterator();
        while (i.hasNext()) {
            if (this.m_cancelled) {
                this.rollback(executedCommands);
                throw new DeploymentException(401);
            }
            this.m_currentCommand = (Command)i.next();
            try {
                executedCommands.add(this.m_currentCommand);
                this.m_currentCommand.execute(this);
            }
            catch (DeploymentException de) {
                if (!ignoreExceptions) {
                    this.rollback(executedCommands);
                    throw de;
                }
                this.m_admin.getLog().log(4, "Ignoring exception as requested!", (Throwable)de);
            }
        }
        i = this.m_commands.iterator();
        while (i.hasNext()) {
            ((Command)i.next()).commit(this);
        }
        this.m_currentCommand = null;
    }

    public boolean cancel() {
        this.m_cancelled = true;
        Command currentCommand = this.m_currentCommand;
        if (currentCommand != null) {
            currentCommand.cancel();
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        return this.m_admin.getBundleContext();
    }

    public DeploymentAdminConfig getConfiguration() {
        return this.m_config;
    }

    public File getDataFile(Bundle bundle) {
        File result = null;
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            throw new IllegalStateException("Could not retrieve valid bundle context from bundle " + bundle.getSymbolicName());
        }
        result = context.getDataFile("");
        if (result == null) {
            throw new IllegalStateException("Could not retrieve base directory for bundle " + bundle.getSymbolicName());
        }
        return result;
    }

    public LogService getLog() {
        return this.m_admin.getLog();
    }

    public PackageAdmin getPackageAdmin() {
        return this.m_admin.getPackageAdmin();
    }

    public AbstractDeploymentPackage getSourceAbstractDeploymentPackage() {
        return this.m_source;
    }

    public DeploymentPackage getSourceDeploymentPackage() {
        return this.m_source;
    }

    public AbstractDeploymentPackage getTargetAbstractDeploymentPackage() {
        return this.m_target;
    }

    public DeploymentPackage getTargetDeploymentPackage() {
        return this.m_target;
    }

    private void rollback(List executedCommands) {
        ListIterator i = executedCommands.listIterator(executedCommands.size());
        while (i.hasPrevious()) {
            Command command = (Command)i.previous();
            command.rollback(this);
        }
    }
}

