/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.Column;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.Join;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.PreparedStatementPartImpl;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

public class Criteria
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9001666575933085601L;
    public static final SqlEnum EQUAL = SqlEnum.EQUAL;
    public static final SqlEnum NOT_EQUAL = SqlEnum.NOT_EQUAL;
    public static final SqlEnum ALT_NOT_EQUAL = SqlEnum.ALT_NOT_EQUAL;
    public static final SqlEnum GREATER_THAN = SqlEnum.GREATER_THAN;
    public static final SqlEnum LESS_THAN = SqlEnum.LESS_THAN;
    public static final SqlEnum GREATER_EQUAL = SqlEnum.GREATER_EQUAL;
    public static final SqlEnum LESS_EQUAL = SqlEnum.LESS_EQUAL;
    public static final SqlEnum LIKE = SqlEnum.LIKE;
    public static final SqlEnum NOT_LIKE = SqlEnum.NOT_LIKE;
    public static final SqlEnum ILIKE = SqlEnum.ILIKE;
    public static final SqlEnum NOT_ILIKE = SqlEnum.NOT_ILIKE;
    public static final SqlEnum DISTINCT = SqlEnum.DISTINCT;
    public static final SqlEnum IN = SqlEnum.IN;
    public static final SqlEnum NOT_IN = SqlEnum.NOT_IN;
    public static final SqlEnum ALL = SqlEnum.ALL;
    public static final SqlEnum JOIN = SqlEnum.JOIN;
    public static final SqlEnum ISNULL = SqlEnum.ISNULL;
    public static final SqlEnum ISNOTNULL = SqlEnum.ISNOTNULL;
    public static final SqlEnum CURRENT_DATE = SqlEnum.CURRENT_DATE;
    public static final SqlEnum CURRENT_TIME = SqlEnum.CURRENT_TIME;
    public static final SqlEnum CURRENT_TIMESTAMP = SqlEnum.CURRENT_TIMESTAMP;
    public static final JoinType LEFT_JOIN = JoinType.LEFT_JOIN;
    public static final JoinType RIGHT_JOIN = JoinType.RIGHT_JOIN;
    public static final JoinType INNER_JOIN = JoinType.INNER_JOIN;
    private boolean ignoreCase = false;
    private boolean singleRecord = false;
    private final UniqueList<String> selectModifiers;
    private final UniqueColumnList selectColumns;
    private final UniqueList<OrderBy> orderByColumns;
    private final UniqueColumnList groupByColumns;
    private final UniqueList<FromElement> fromElements;
    private Criterion having = null;
    private boolean forUpdate = false;
    private Criterion topLevelCriterion;
    private final Map<String, Column> asColumns;
    private final List<Join> joins;
    private String dbName;
    private int limit = -1;
    private long offset = 0L;
    private final Map<String, Object> aliases;
    private Integer fetchSize;
    private SqlEnum setOperator;
    private final List<Criteria> setCriteriaParts;

    public Criteria() {
        this.selectModifiers = new UniqueList();
        this.selectColumns = new UniqueColumnList();
        this.orderByColumns = new UniqueList();
        this.groupByColumns = new UniqueColumnList();
        this.fromElements = new UniqueList();
        this.asColumns = new LinkedHashMap<String, Column>();
        this.joins = new ArrayList<Join>();
        this.aliases = new HashMap<String, Object>();
        this.setCriteriaParts = new ArrayList<Criteria>();
    }

    public Criteria(String dbName) {
        this();
        this.dbName = dbName;
    }

    public Criteria(Criteria toCopy) {
        this.ignoreCase = toCopy.ignoreCase;
        this.singleRecord = toCopy.singleRecord;
        this.selectModifiers = new UniqueList<String>(toCopy.selectModifiers);
        this.selectColumns = new UniqueColumnList(toCopy.selectColumns);
        this.orderByColumns = new UniqueList<OrderBy>(toCopy.orderByColumns);
        this.groupByColumns = new UniqueColumnList(toCopy.groupByColumns);
        this.fromElements = new UniqueList<FromElement>(toCopy.fromElements);
        if (toCopy.having != null) {
            this.having = new Criterion(toCopy.having);
        }
        this.forUpdate = toCopy.forUpdate;
        if (toCopy.topLevelCriterion != null) {
            this.topLevelCriterion = new Criterion(toCopy.topLevelCriterion);
        }
        this.asColumns = new HashMap<String, Column>(toCopy.asColumns);
        this.joins = new ArrayList<Join>(toCopy.joins);
        this.dbName = toCopy.dbName;
        this.limit = toCopy.limit;
        this.offset = toCopy.offset;
        this.aliases = new HashMap<String, Object>(toCopy.aliases);
        this.fetchSize = toCopy.fetchSize;
        this.setOperator = toCopy.setOperator;
        this.setCriteriaParts = new ArrayList<Criteria>(toCopy.setCriteriaParts.size());
        toCopy.setCriteriaParts.forEach(setCriteriaPart -> this.setCriteriaParts.add(new Criteria((Criteria)setCriteriaPart)));
    }

    protected void clear() {
        this.ignoreCase = false;
        this.singleRecord = false;
        this.selectModifiers.clear();
        this.selectColumns.clear();
        this.orderByColumns.clear();
        this.groupByColumns.clear();
        this.fromElements.clear();
        this.having = null;
        this.forUpdate = false;
        this.topLevelCriterion = null;
        this.asColumns.clear();
        this.joins.clear();
        this.dbName = null;
        this.limit = -1;
        this.offset = 0L;
        this.aliases.clear();
        this.fetchSize = null;
        this.setOperator = null;
        this.setCriteriaParts.clear();
    }

    public Criteria addAsColumn(String name, Column clause) {
        this.assertNoComposite();
        this.asColumns.put(name, clause);
        return this;
    }

    public Map<String, Column> getAsColumns() {
        return this.asColumns;
    }

    public Map<String, Object> getAliases() {
        return this.aliases;
    }

    public Criteria addAlias(String alias, String table) {
        this.assertNoComposite();
        this.aliases.put(alias, table);
        return this;
    }

    public Criteria addAlias(String alias, Criteria subselect) {
        this.assertNoComposite();
        this.aliases.put(alias, subselect);
        return this;
    }

    public String getTableForAlias(String alias) {
        Object aliasResolved = this.aliases.get(alias);
        if (aliasResolved == null) {
            return null;
        }
        if (aliasResolved instanceof String) {
            return (String)aliasResolved;
        }
        throw new IllegalArgumentException("The alias " + alias + " is not associated to a table but to an object of type " + alias.getClass().getName());
    }

    public Criteria getSubselectForAlias(String alias) {
        Object aliasResolved = this.aliases.get(alias);
        if (aliasResolved == null) {
            return null;
        }
        if (aliasResolved instanceof Criteria) {
            return (Criteria)aliasResolved;
        }
        throw new IllegalArgumentException("The alias " + alias + " is not associated to a subselect but to an object of type " + alias.getClass().getName());
    }

    public Criterion getTopLevelCriterion() {
        return this.topLevelCriterion;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Criteria setDbName(String dbName) {
        this.assertNoComposite();
        this.dbName = dbName;
        return this;
    }

    public Criteria addHaving(Criterion having) {
        this.assertNoComposite();
        this.having = having;
        return this;
    }

    public Criterion getHaving() {
        return this.having;
    }

    public Criteria forUpdate() {
        this.assertNoComposite();
        this.forUpdate = true;
        return this;
    }

    public Criteria setForUpdate(boolean forUpdate) {
        this.assertNoComposite();
        this.forUpdate = forUpdate;
        return this;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Criteria addJoin(Column left, Column right) {
        this.assertNoComposite();
        return this.addJoin(left, right, null);
    }

    public Criteria addJoin(Column left, Column right, JoinType joinType) {
        this.assertNoComposite();
        this.joins.add(new Join(left, right, EQUAL, joinType));
        return this;
    }

    public Criteria addJoin(Column left, Column right, SqlEnum comparison, JoinType joinType) {
        this.assertNoComposite();
        this.joins.add(new Join(left, right, comparison, joinType));
        return this;
    }

    public Criteria addJoin(String leftTable, String rightTable, Criterion joinCondition, JoinType joinType) {
        this.assertNoComposite();
        this.joins.add(new Join(new PreparedStatementPartImpl(leftTable, new Object[0]), new PreparedStatementPartImpl(rightTable, new Object[0]), joinCondition, joinType));
        return this;
    }

    public Criteria addJoin(PreparedStatementPart leftTable, PreparedStatementPart rightTable, Criterion joinCondition, JoinType joinType) {
        this.assertNoComposite();
        this.joins.add(new Join(leftTable, rightTable, joinCondition, joinType));
        return this;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Criteria setAll() {
        this.assertNoComposite();
        this.selectModifiers.add(ALL.toString());
        return this;
    }

    public Criteria setDistinct() {
        this.assertNoComposite();
        this.selectModifiers.add(DISTINCT.toString());
        return this;
    }

    public Criteria setIgnoreCase(boolean ignoreCase) {
        if (this.isComposite()) {
            this.setCriteriaParts.forEach(criteria -> criteria.setIgnoreCase(true));
        } else {
            this.ignoreCase = ignoreCase;
        }
        return this;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Criteria setSingleRecord(boolean b) {
        this.singleRecord = b;
        return this;
    }

    public boolean isSingleRecord() {
        return this.singleRecord;
    }

    public Criteria setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Criteria setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public long getOffset() {
        return this.offset;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Criteria setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Criteria addSelectColumn(Column column) {
        this.assertNoComposite();
        this.selectColumns.add(column);
        return this;
    }

    public UniqueColumnList getSelectColumns() {
        return this.selectColumns;
    }

    public UniqueList<String> getSelectModifiers() {
        return this.selectModifiers;
    }

    public Criteria addGroupByColumn(Column groupBy) {
        this.assertNoComposite();
        this.groupByColumns.add(groupBy);
        return this;
    }

    public UniqueColumnList getGroupByColumns() {
        return this.groupByColumns;
    }

    public Criteria addAscendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, false));
        return this;
    }

    public Criteria addAscendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, ignoreCase));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, false));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, ignoreCase));
        return this;
    }

    public UniqueList<OrderBy> getOrderByColumns() {
        return this.orderByColumns;
    }

    public UniqueList<FromElement> getFromElements() {
        return this.fromElements;
    }

    public Criteria addFrom(String tableName) {
        this.assertNoComposite();
        this.fromElements.add(new FromElement(tableName));
        return this;
    }

    public Criteria addFrom(FromElement fromElement) {
        this.assertNoComposite();
        this.fromElements.add(fromElement);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Criteria: ");
        try {
            Query query = SqlBuilder.buildQuery(this);
            sb.append("Current Query SQL (may not be complete or applicable): ").append(query.getDisplayString());
        }
        catch (Exception exc) {
            sb.append("Error" + exc.getMessage());
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Criteria criteria = (Criteria)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)criteria.topLevelCriterion, (Object)this.topLevelCriterion);
        equalsBuilder.append(criteria.offset, this.offset);
        equalsBuilder.append(criteria.limit, this.limit);
        equalsBuilder.append(criteria.ignoreCase, this.ignoreCase);
        equalsBuilder.append(criteria.singleRecord, this.singleRecord);
        equalsBuilder.append((Object)criteria.dbName, (Object)this.dbName);
        equalsBuilder.append(criteria.selectModifiers, this.selectModifiers);
        equalsBuilder.append((Object)criteria.selectColumns, (Object)this.selectColumns);
        equalsBuilder.append(criteria.orderByColumns, this.orderByColumns);
        equalsBuilder.append(criteria.fromElements, this.fromElements);
        equalsBuilder.append(criteria.aliases, this.aliases);
        equalsBuilder.append(criteria.asColumns, this.asColumns);
        equalsBuilder.append(criteria.joins, this.joins);
        equalsBuilder.append((Object)criteria.fetchSize, (Object)this.fetchSize);
        equalsBuilder.append((Object)criteria.setOperator, (Object)this.setOperator);
        equalsBuilder.append(criteria.setCriteriaParts, this.setCriteriaParts);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.topLevelCriterion);
        hashCodeBuilder.append(this.offset);
        hashCodeBuilder.append(this.limit);
        hashCodeBuilder.append(this.ignoreCase);
        hashCodeBuilder.append(this.singleRecord);
        hashCodeBuilder.append((Object)this.dbName);
        hashCodeBuilder.append(this.selectModifiers);
        hashCodeBuilder.append((Object)this.selectColumns);
        hashCodeBuilder.append(this.orderByColumns);
        hashCodeBuilder.append(this.fromElements);
        hashCodeBuilder.append(this.aliases);
        hashCodeBuilder.append(this.asColumns);
        hashCodeBuilder.append(this.joins);
        hashCodeBuilder.append((Object)this.fetchSize);
        hashCodeBuilder.append((Object)this.setOperator);
        hashCodeBuilder.append(this.setCriteriaParts);
        return hashCodeBuilder.toHashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Criteria and(Criterion criterion) {
        this.assertNoComposite();
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = new Criterion(criterion);
        } else {
            this.topLevelCriterion.and(new Criterion(criterion));
        }
        return this;
    }

    public Criteria and(Object lValue, Object rValue) {
        SqlEnum sqlEnum;
        if (rValue instanceof SqlEnum && (sqlEnum = (SqlEnum)rValue).getNumberOfCompareOperands() == 1) {
            return this.and(lValue, null, sqlEnum);
        }
        return this.and(lValue, rValue, EQUAL);
    }

    public Criteria and(Object lValue, Object rValue, SqlEnum comparison) {
        this.assertNoComposite();
        Criterion newCriterion = new Criterion(lValue, rValue, comparison);
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = newCriterion;
        } else {
            this.topLevelCriterion.and(newCriterion);
        }
        return this;
    }

    public Criteria andDate(Object lValue, int year, int month, int day) {
        return this.and(lValue, new GregorianCalendar(year, month, day).getTime(), EQUAL);
    }

    public Criteria andDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.and(lValue, new GregorianCalendar(year, month, day).getTime(), comparison);
    }

    public Criteria andIn(Object lValue, Object[] rValues) {
        return this.and(lValue, rValues, IN);
    }

    public Criteria andIn(Object lValue, Collection<?> rValues) {
        return this.and(lValue, rValues, IN);
    }

    public Criteria andNotIn(Object lValue, Object[] rValues) {
        return this.and(lValue, rValues, NOT_IN);
    }

    public Criteria andNotIn(Object lValue, Collection<?> rValues) {
        return this.and(lValue, rValues, NOT_IN);
    }

    public Criteria andVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria andVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria or(Criterion criterion) {
        this.assertNoComposite();
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = new Criterion(criterion);
        } else {
            this.topLevelCriterion.or(new Criterion(criterion));
        }
        return this;
    }

    public Criteria or(Object lValue, Object rValue) {
        SqlEnum sqlEnum;
        if (rValue instanceof SqlEnum && (sqlEnum = (SqlEnum)rValue).getNumberOfCompareOperands() == 1) {
            return this.or(lValue, null, sqlEnum);
        }
        return this.or(lValue, rValue, EQUAL);
    }

    public Criteria or(Object lValue, Object rValue, SqlEnum comparison) {
        this.assertNoComposite();
        Criterion newCriterion = new Criterion(lValue, rValue, comparison);
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = newCriterion;
        } else {
            this.topLevelCriterion.or(newCriterion);
        }
        return this;
    }

    public Criteria orDate(Object lValue, int year, int month, int day) {
        return this.or(lValue, new GregorianCalendar(year, month, day).getTime(), EQUAL);
    }

    public Criteria orDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.or(lValue, new GregorianCalendar(year, month, day).getTime(), comparison);
    }

    public Criteria orIn(Object lValue, Object[] rValues) {
        return this.or(lValue, rValues, IN);
    }

    public Criteria orIn(Object lValue, Collection<?> rValues) {
        return this.or(lValue, rValues, IN);
    }

    public Criteria orNotIn(Object lValue, Object[] rValues) {
        return this.or(lValue, rValues, NOT_IN);
    }

    public Criteria orNotIn(Object lValue, Collection<?> rValues) {
        return this.or(lValue, rValues, NOT_IN);
    }

    public Criteria orVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.or(criterion);
        return this;
    }

    public Criteria orVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.or(criterion);
        return this;
    }

    public Criteria where(Criterion criterion) {
        return this.and(criterion);
    }

    public Criteria where(Object lValue, Object rValue) {
        return this.and(lValue, rValue);
    }

    public Criteria where(Object lValue, Object rValue, SqlEnum comparison) {
        return this.and(lValue, rValue, comparison);
    }

    public Criteria whereDate(Object lValue, int year, int month, int day) {
        return this.andDate(lValue, year, month, day);
    }

    public Criteria whereDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.andDate(lValue, year, month, day, comparison);
    }

    public Criteria whereIn(Object lValue, Object[] rValues) {
        return this.andIn(lValue, rValues);
    }

    public Criteria whereIn(Object lValue, Collection<?> rValues) {
        return this.andIn(lValue, rValues);
    }

    public Criteria whereNotIn(Object lValue, Object[] rValues) {
        return this.andNotIn(lValue, rValues);
    }

    public Criteria whereNotIn(Object lValue, Collection<?> rValues) {
        return this.andNotIn(lValue, rValues);
    }

    public Criteria whereVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria whereVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria union(Criteria other) {
        this.appendSetOperation(other, SqlEnum.UNION);
        return this;
    }

    public Criteria unionAll(Criteria other) {
        this.appendSetOperation(other, SqlEnum.UNION_ALL);
        return this;
    }

    public Criteria intersect(Criteria other) {
        this.appendSetOperation(other, SqlEnum.INTERSECT);
        return this;
    }

    public Criteria intersectAll(Criteria other) {
        this.appendSetOperation(other, SqlEnum.INTERSECT_ALL);
        return this;
    }

    public Criteria except(Criteria other) {
        this.appendSetOperation(other, SqlEnum.EXCEPT);
        return this;
    }

    public Criteria exceptAll(Criteria other) {
        this.appendSetOperation(other, SqlEnum.EXCEPT_ALL);
        return this;
    }

    protected void appendSetOperation(Criteria other, SqlEnum setOperator) {
        if (other == null) {
            throw new NullPointerException("other must not be null");
        }
        if (setOperator == null) {
            throw new NullPointerException("setOperator must not be null");
        }
        if (this.isComposite() && this.setOperator.equals(setOperator)) {
            this.setCriteriaParts.add(other);
        } else {
            Criteria copy = new Criteria(this);
            this.clear();
            this.setCriteriaParts.add(copy);
            this.setCriteriaParts.add(other);
        }
        this.setOperator = setOperator;
    }

    public List<Criteria> getSetCriteriaParts() {
        return this.setCriteriaParts;
    }

    public SqlEnum getSetOperator() {
        return this.setOperator;
    }

    public boolean isComposite() {
        return !this.setCriteriaParts.isEmpty();
    }

    protected void assertNoComposite() {
        if (this.isComposite()) {
            throw new TorqueRuntimeException("This operation cannot be performed on a composite Criteria, which is composed of several set operations. Try to perform the operation on the single parts of this Criteria");
        }
    }
}

