/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesQuickSelectSketch;

public abstract class ArrayOfDoublesUpdatableSketch
extends ArrayOfDoublesSketch {
    final long seed_;

    ArrayOfDoublesUpdatableSketch(int numValues, long seed) {
        super(numValues);
        this.seed_ = seed;
    }

    public static ArrayOfDoublesUpdatableSketch heapify(MemorySegment seg) {
        return ArrayOfDoublesUpdatableSketch.heapify(seg, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch heapify(MemorySegment seg, long seed) {
        return new HeapArrayOfDoublesQuickSelectSketch(seg, seed);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(MemorySegment seg) {
        return ArrayOfDoublesUpdatableSketch.wrap(seg, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(MemorySegment seg, long seed) {
        return new DirectArrayOfDoublesQuickSelectSketch(seg, seed);
    }

    public void update(long key, double[] values) {
        this.update(new long[]{key}, values);
    }

    public void update(double key, double[] values) {
        this.update(Util.doubleToLongArray(key), values);
    }

    public void update(String key, double[] values) {
        this.update(Util.stringToByteArray(key), values);
    }

    public void update(byte[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(ByteBuffer key, double[] values) {
        if (key == null || !key.hasRemaining()) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(int[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(long[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public abstract int getNominalEntries();

    public abstract ResizeFactor getResizeFactor();

    public abstract float getSamplingProbability();

    public abstract void trim();

    public abstract void reset();

    @Override
    public ArrayOfDoublesCompactSketch compact() {
        return this.compact(null);
    }

    @Override
    public ArrayOfDoublesCompactSketch compact(MemorySegment dstSeg) {
        if (dstSeg == null) {
            return new HeapArrayOfDoublesCompactSketch(this);
        }
        return new DirectArrayOfDoublesCompactSketch(this, dstSeg);
    }

    abstract int getCurrentCapacity();

    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return org.apache.datasketches.common.Util.computeSeedHash(this.seed_);
    }

    abstract void insertOrIgnore(long var1, double[] var3);
}

