/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantilescommon.IncludeMinMax;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class IncludeMinMaxTest {
    private static final boolean enablePrinting = false;

    @Test
    public static void checkDoublesEndsAdjustment() {
        double[] quantiles = new double[]{2.0, 4.0, 6.0, 7.0};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        double maxItem = 8.0;
        double minItem = 1.0;
        IncludeMinMax.DoublesPair dPair = IncludeMinMax.includeDoublesMinMax((double[])quantiles, (long[])cumWeights, (double)8.0, (double)1.0);
        double[] adjQuantiles = dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10.1f %10d" + Util.LS, adjQuantiles[i], adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((double)adjQuantiles[topAdj], (double)8.0);
        Assert.assertEquals((double)adjQuantiles[0], (double)1.0);
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)1L);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)2);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)2);
    }

    @Test
    public static void checkDoublesEndsAdjustment2() {
        double[] quantiles = new double[]{2.0, 4.0, 6.0, 7.0};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        double maxItem = 7.0;
        double minItem = 2.0;
        IncludeMinMax.DoublesPair dPair = IncludeMinMax.includeDoublesMinMax((double[])quantiles, (long[])cumWeights, (double)7.0, (double)2.0);
        double[] adjQuantiles = dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10.1f %10d" + Util.LS, adjQuantiles[i], adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((double)adjQuantiles[topAdj], (double)7.0);
        Assert.assertEquals((double)adjQuantiles[0], (double)2.0);
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)cumWeights[0]);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)0);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)0);
    }

    @Test
    public static void checkFloatsEndsAdjustment() {
        float[] quantiles = new float[]{2.0f, 4.0f, 6.0f, 7.0f};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        float maxItem = 8.0f;
        float minItem = 1.0f;
        IncludeMinMax.FloatsPair dPair = IncludeMinMax.includeFloatsMinMax((float[])quantiles, (long[])cumWeights, (float)8.0f, (float)1.0f);
        float[] adjQuantiles = dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10.1f %10d" + Util.LS, Float.valueOf(adjQuantiles[i]), adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((float)adjQuantiles[topAdj], (float)8.0f);
        Assert.assertEquals((float)adjQuantiles[0], (float)1.0f);
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)1L);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)2);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)2);
    }

    @Test
    public static void checkFloatsEndsAdjustment2() {
        float[] quantiles = new float[]{2.0f, 4.0f, 6.0f, 7.0f};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        float maxItem = 7.0f;
        float minItem = 2.0f;
        IncludeMinMax.FloatsPair dPair = IncludeMinMax.includeFloatsMinMax((float[])quantiles, (long[])cumWeights, (float)7.0f, (float)2.0f);
        float[] adjQuantiles = dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10.1f %10d" + Util.LS, Float.valueOf(adjQuantiles[i]), adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((float)adjQuantiles[topAdj], (float)7.0f);
        Assert.assertEquals((float)adjQuantiles[0], (float)2.0f);
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)cumWeights[0]);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)0);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)0);
    }

    @Test
    public static void checkItemsEndsAdjustment() {
        Object[] quantiles = new String[]{"2", "4", "6", "7"};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        String maxItem = "8";
        String minItem = "1";
        IncludeMinMax.ItemsPair dPair = IncludeMinMax.includeItemsMinMax((Object[])quantiles, (long[])cumWeights, (Object)"8", (Object)"1", Comparator.naturalOrder());
        String[] adjQuantiles = (String[])dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10s %10d" + Util.LS, adjQuantiles[i], adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((String)adjQuantiles[topAdj], (String)"8");
        Assert.assertEquals((String)adjQuantiles[0], (String)"1");
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)1L);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)2);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)2);
    }

    @Test
    public static void checkItemsEndsAdjustment2() {
        Object[] quantiles = new String[]{"2", "4", "6", "7"};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        String maxItem = "7";
        String minItem = "2";
        IncludeMinMax.ItemsPair dPair = IncludeMinMax.includeItemsMinMax((Object[])quantiles, (long[])cumWeights, (Object)"7", (Object)"2", Comparator.naturalOrder());
        String[] adjQuantiles = (String[])dPair.quantiles;
        long[] adjCumWeights = dPair.cumWeights;
        int len = adjCumWeights.length;
        IncludeMinMaxTest.printf("%10s %10s" + Util.LS, "Quantiles", "CumWeights");
        for (int i = 0; i < len; ++i) {
            IncludeMinMaxTest.printf("%10s %10d" + Util.LS, adjQuantiles[i], adjCumWeights[i]);
        }
        int topIn = quantiles.length - 1;
        int topAdj = adjQuantiles.length - 1;
        Assert.assertEquals((String)adjQuantiles[topAdj], (String)"7");
        Assert.assertEquals((String)adjQuantiles[0], (String)"2");
        Assert.assertEquals((long)adjCumWeights[topAdj], (long)cumWeights[topIn]);
        Assert.assertEquals((long)adjCumWeights[0], (long)cumWeights[0]);
        Assert.assertEquals((int)(adjQuantiles.length - quantiles.length), (int)0);
        Assert.assertEquals((int)(adjCumWeights.length - cumWeights.length), (int)0);
    }

    @Test
    public void printlnTest() {
        IncludeMinMaxTest.println("PRINTING: " + this.getClass().getName());
    }

    static final void printf(String format, Object ... args) {
    }

    static final void println(Object o) {
    }
}

