/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.UndertowLogger;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathMatchPredicate
implements Predicate {
    private final PathMatcher<Boolean> pathMatcher;
    private static final boolean traceEnabled = UndertowLogger.PREDICATE_LOGGER.isTraceEnabled();

    PathMatchPredicate(String ... paths) {
        PathMatcher<Boolean> matcher = new PathMatcher<Boolean>();
        for (String path : paths) {
            if (!path.startsWith("/")) {
                matcher.addExactPath("/" + path, Boolean.TRUE);
                continue;
            }
            matcher.addExactPath(path, Boolean.TRUE);
        }
        this.pathMatcher = matcher;
    }

    public String toString() {
        Set<String> matches = this.pathMatcher.getExactPathMatchesSet();
        if (matches.size() == 1) {
            return "path( '" + String.valueOf(matches.toArray()[0]) + "' )";
        }
        return "path( { '" + matches.stream().collect(Collectors.joining("', '")) + "' } )";
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        PathMatcher.PathMatch<Boolean> result = this.pathMatcher.match(relativePath);
        boolean matches = Boolean.TRUE.equals(result.getValue());
        if (traceEnabled) {
            UndertowLogger.PREDICATE_LOGGER.tracef("Path(s) [%s] %s input [%s] for %s.", new Object[]{this.pathMatcher.getExactPathMatchesSet().stream().collect(Collectors.joining(", ")), matches ? "MATCH" : "DO NOT MATCH", relativePath, value});
        }
        return matches;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path = (String[])config.get("path");
            return new PathMatchPredicate(path);
        }
    }
}

