/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.micrometer.MicrometerClientMetricsContext;
import org.apache.cxf.metrics.micrometer.MicrometerMetricsProperties;
import org.apache.cxf.metrics.micrometer.MicrometerServerMetricsContext;
import org.apache.cxf.metrics.micrometer.provider.TagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.TagsProvider;
import org.apache.cxf.metrics.micrometer.provider.TimedAnnotationProvider;
import org.apache.cxf.service.model.BindingOperationInfo;

@NoJSR250Annotations
public class MicrometerMetricsProvider
implements MetricsProvider {
    private final MeterRegistry registry;
    private final TagsProvider tagsProvider;
    private final List<TagsCustomizer> tagsCustomizers;
    private final TimedAnnotationProvider timedAnnotationProvider;
    private final MicrometerMetricsProperties micrometerMetricsProperties;

    public MicrometerMetricsProvider(MeterRegistry registry, TagsProvider tagsProvider, List<TagsCustomizer> tagsCustomizers, TimedAnnotationProvider timedAnnotationProvider, MicrometerMetricsProperties micrometerMetricsProperties) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.tagsCustomizers = tagsCustomizers;
        this.timedAnnotationProvider = timedAnnotationProvider;
        this.micrometerMetricsProperties = micrometerMetricsProperties;
    }

    @Override
    public MetricsContext createEndpointContext(Endpoint endpoint, boolean asClient, String clientId) {
        return null;
    }

    @Override
    public MetricsContext createOperationContext(Endpoint endpoint, BindingOperationInfo boi, boolean asClient, String clientId) {
        if (asClient) {
            return new MicrometerClientMetricsContext(this.registry, this.tagsProvider, this.timedAnnotationProvider, this.tagsCustomizers, this.micrometerMetricsProperties.getClientRequestsMetricName());
        }
        return new MicrometerServerMetricsContext(this.registry, this.tagsProvider, this.timedAnnotationProvider, this.tagsCustomizers, this.micrometerMetricsProperties.getServerRequestsMetricName(), this.micrometerMetricsProperties.isAutoTimeRequests());
    }

    @Override
    public MetricsContext createResourceContext(Endpoint endpoint, String resourceName, boolean asClient, String clientId) {
        if (asClient) {
            return new MicrometerClientMetricsContext(this.registry, this.tagsProvider, this.timedAnnotationProvider, this.tagsCustomizers, this.micrometerMetricsProperties.getClientRequestsMetricName());
        }
        return new MicrometerServerMetricsContext(this.registry, this.tagsProvider, this.timedAnnotationProvider, this.tagsCustomizers, this.micrometerMetricsProperties.getServerRequestsMetricName(), this.micrometerMetricsProperties.isAutoTimeRequests());
    }
}

