/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigDecimal;
import java.math.BigInteger;

final class IntMath {
    private static final long MASK32 = 0xFFFFFFFFL;
    private static final long MASK52 = 0xFFFFFFFFFFFFFL;
    private static final int EXP_BIAS = 1023;
    private static final int EXP_SHIFT = 52;
    private static final double HALF = 0.5;

    private IntMath() {
    }

    static long squareHigh(long x) {
        long a = x >>> 32;
        long b = x & 0xFFFFFFFFL;
        long aa = a * a;
        long ab = a * b;
        long bb = b * b;
        long carry = (bb >>> 32) + (ab & 0xFFFFFFFFL) + ab;
        long hi = (ab >>> 32) + (carry >>> 32) + aa;
        return hi - ((x >> 63 & x) << 1);
    }

    static long unsignedMultiplyHigh(long value1, long value2) {
        long a = value1 >>> 32;
        long b = value1 & 0xFFFFFFFFL;
        long x = value2 >>> 32;
        long y = value2 & 0xFFFFFFFFL;
        long by = b * y;
        long bx = b * x;
        long ay = a * y;
        long ax = a * x;
        long carry = (by >>> 32) + (bx & 0xFFFFFFFFL) + ay;
        return (bx >>> 32) + (carry >>> 32) + ax;
    }

    static double unsignedMultiplyToDouble(long x, long y) {
        long lo = x * y;
        if ((x | y) >>> 31 == 0L) {
            return lo;
        }
        return IntMath.uint128ToDouble(IntMath.unsignedMultiplyHigh(x, y), lo);
    }

    static double uint128ToDouble(long hi, long lo) {
        if (hi == 0L) {
            if (lo >= 0L) {
                return lo;
            }
            return 2.0 * (double)(lo >>> 1 | lo & 1L);
        }
        int shift = Long.numberOfLeadingZeros(hi);
        long maskLow = -1L >>> shift;
        long bits64 = hi << shift | (lo & (maskLow ^ 0xFFFFFFFFFFFFFFFFL)) >>> -shift;
        int exp = 127 - shift;
        long bits = (bits64 |= (lo & maskLow) == 0L ? 0L : 1L) >>> 11 & 0xFFFFFFFFFFFFFL;
        long a = bits64 >>> 10 & 1L;
        long b = bits64 << 54 == 0L ? 0L : 1L;
        bits += a & (b | bits & 1L);
        return Double.longBitsToDouble(bits += (long)(exp + 1023) << 52);
    }

    static int toIntExact(double x) {
        double r = IntMath.roundToInteger(x);
        if (r >= -2.147483648E9 && r < 2.147483648E9) {
            return (int)r;
        }
        throw new ArithmeticException("integer overflow: " + x);
    }

    static long toLongExact(double x) {
        double r = IntMath.roundToInteger(x);
        if (r >= -9.223372036854776E18 && r < 9.223372036854776E18) {
            return (long)r;
        }
        throw new ArithmeticException("long integer overflow: " + x);
    }

    static BigInteger toBigIntegerExact(double x) {
        if (!Double.isFinite(x)) {
            throw new ArithmeticException("BigInteger overflow: " + x);
        }
        double r = IntMath.roundToInteger(x);
        if (r >= -9.223372036854776E18 && r < 9.223372036854776E18) {
            return BigInteger.valueOf((long)r);
        }
        return new BigDecimal(r).toBigInteger();
    }

    private static double roundToInteger(double x) {
        double y = Math.floor(x);
        double d = x - y;
        if (d >= 0.5) {
            return y + 1.0;
        }
        return y;
    }
}

