/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.regression.MillerUpdatingRegression;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.RegressionResults;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class MillerUpdatingRegressionTest {
    private static final double[][] airdata = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0}, {1140640.0, 1215690.0, 1309570.0, 1511530.0, 1676730.0, 1823740.0, 2022890.0, 2314760.0, 2639160.0, 3247620.0, 3787750.0, 3867750.0, 3996020.0, 4282880.0, 4748320.0, 569292.0, 640614.0, 777655.0, 999294.0, 1203970.0, 1358100.0, 1501350.0, 1709270.0, 2025400.0, 2548370.0, 3137740.0, 3557700.0, 3717740.0, 3962370.0, 4209390.0, 286298.0, 309290.0, 342056.0, 374595.0, 450037.0, 510412.0, 575347.0, 669331.0, 783799.0, 913883.0, 1041520.0, 1125800.0, 1096070.0, 1198930.0, 1170470.0, 145167.0, 170192.0, 247506.0, 309391.0, 354338.0, 373941.0, 420915.0, 474017.0, 532590.0, 676771.0, 880438.0, 1052020.0, 1193680.0, 1303390.0, 1436970.0, 91361.0, 95428.0, 98187.0, 115967.0, 138382.0, 156228.0, 183169.0, 210212.0, 274024.0, 356915.0, 432344.0, 524294.0, 530924.0, 581447.0, 610257.0, 68978.0, 74904.0, 83829.0, 98148.0, 118449.0, 133161.0, 145062.0, 170711.0, 199775.0, 276797.0, 381478.0, 506969.0, 633388.0, 804388.0, 1009500.0}, {0.952757, 0.986757, 1.09198, 1.17578, 1.16017, 1.17376, 1.29051, 1.39067, 1.61273, 1.82544, 1.54604, 1.5279, 1.6602, 1.82231, 1.93646, 0.520635, 0.534627, 0.655192, 0.791575, 0.842945, 0.852892, 0.922843, 1.0, 1.19845, 1.34067, 1.32624, 1.24852, 1.25432, 1.37177, 1.38974, 0.262424, 0.266433, 0.306043, 0.325586, 0.345706, 0.367517, 0.409937, 0.448023, 0.539595, 0.539382, 0.467967, 0.450544, 0.468793, 0.494397, 0.493317, 0.086393, 0.09674, 0.1415, 0.169715, 0.173805, 0.164272, 0.170906, 0.17784, 0.192248, 0.242469, 0.256505, 0.249657, 0.273923, 0.371131, 0.421411, 0.051028, 0.052646, 0.056348, 0.066953, 0.070308, 0.073961, 0.084946, 0.095474, 0.119814, 0.150046, 0.144014, 0.1693, 0.172761, 0.18667, 0.213279, 0.037682, 0.039784, 0.044331, 0.050245, 0.055046, 0.052462, 0.056977, 0.06149, 0.069027, 0.092749, 0.11264, 0.154154, 0.186461, 0.246847, 0.304013}, {106650.0, 110307.0, 110574.0, 121974.0, 196606.0, 265609.0, 263451.0, 316411.0, 384110.0, 569251.0, 871636.0, 997239.0, 938002.0, 859572.0, 823411.0, 103795.0, 111477.0, 118664.0, 114797.0, 215322.0, 281704.0, 304818.0, 348609.0, 374579.0, 544109.0, 853356.0, 1003200.0, 941977.0, 856533.0, 821361.0, 118788.0, 123798.0, 122882.0, 131274.0, 222037.0, 278721.0, 306564.0, 356073.0, 378311.0, 555267.0, 850322.0, 1015610.0, 954508.0, 886999.0, 844079.0, 114987.0, 120501.0, 121908.0, 127220.0, 209405.0, 263148.0, 316724.0, 363598.0, 389436.0, 547376.0, 850418.0, 1011170.0, 951934.0, 881323.0, 831374.0, 118222.0, 116223.0, 115853.0, 129372.0, 243266.0, 277930.0, 317273.0, 358794.0, 397667.0, 566672.0, 848393.0, 1005740.0, 958231.0, 872924.0, 844622.0, 117112.0, 119420.0, 116087.0, 122997.0, 194309.0, 307923.0, 323595.0, 363081.0, 386422.0, 564867.0, 874818.0, 1013170.0, 930477.0, 851676.0, 819476.0}, {0.534487, 0.532328, 0.547736, 0.540846, 0.591167, 0.575417, 0.594495, 0.597409, 0.638522, 0.676287, 0.605735, 0.61436, 0.633366, 0.650117, 0.625603, 0.490851, 0.473449, 0.503013, 0.512501, 0.566782, 0.558133, 0.558799, 0.57207, 0.624763, 0.628706, 0.58915, 0.532612, 0.526652, 0.540163, 0.528775, 0.524334, 0.537185, 0.582119, 0.579489, 0.606592, 0.60727, 0.582425, 0.573972, 0.654256, 0.631055, 0.56924, 0.589682, 0.587953, 0.565388, 0.577078, 0.432066, 0.439669, 0.488932, 0.484181, 0.529925, 0.532723, 0.549067, 0.55714, 0.611377, 0.645319, 0.611734, 0.580884, 0.572047, 0.59457, 0.585525, 0.442875, 0.462473, 0.519118, 0.529331, 0.557797, 0.556181, 0.569327, 0.583465, 0.631818, 0.604723, 0.587921, 0.616159, 0.605868, 0.594688, 0.635545, 0.448539, 0.475889, 0.500562, 0.500344, 0.528897, 0.495361, 0.510342, 0.518296, 0.546723, 0.554276, 0.517766, 0.580049, 0.556024, 0.537791, 0.525775}};

    @Test
    public void testHasIntercept() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(10, false);
        if (instance.hasIntercept()) {
            Assert.fail((String)"Should not have intercept");
        }
        if (!(instance = new MillerUpdatingRegression(10, true)).hasIntercept()) {
            Assert.fail((String)"Should have intercept");
        }
    }

    @Test
    public void testAddObsGetNClear() {
        int i;
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        double[][] xAll = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (i = 0; i < airdata[0].length; ++i) {
            xAll[i] = new double[3];
            xAll[i][0] = FastMath.log((double)airdata[3][i]);
            xAll[i][1] = FastMath.log((double)airdata[4][i]);
            xAll[i][2] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])xAll, y);
        if (instance.getN() != (long)xAll.length) {
            Assert.fail((String)"Number of observations not correct in bulk addition");
        }
        instance.clear();
        for (i = 0; i < xAll.length; ++i) {
            instance.addObservation(xAll[i], y[i]);
        }
        if (instance.getN() != (long)xAll.length) {
            Assert.fail((String)"Number of observations not correct in drip addition");
        }
    }

    @Test
    public void testNegativeTestAddObs() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        try {
            instance.addObservation(new double[]{1.0}, 0.0);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        try {
            instance.addObservation(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 0.0);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        try {
            instance.addObservation(new double[]{1.0, 1.0, 1.0}, 0.0);
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        instance = new MillerUpdatingRegression(3, false);
        try {
            instance.addObservation(new double[]{1.0}, 0.0);
            Assert.fail((String)"Should throw IllegalArgumentException [NOINTERCEPT]");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException [NOINTERCEPT]");
        }
        try {
            instance.addObservation(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 0.0);
            Assert.fail((String)"Should throw IllegalArgumentException [NOINTERCEPT]");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException [NOINTERCEPT]");
        }
        try {
            instance.addObservation(new double[]{1.0, 1.0, 1.0}, 0.0);
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException [NOINTERCEPT]");
        }
    }

    @Test
    public void testNegativeTestAddMultipleObs() {
        double[] y;
        double[][] tst2;
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        try {
            tst2 = new double[][]{{1.0, 1.0, 1.0}, {1.2, 2.0, 2.1}};
            y = new double[]{1.0};
            instance.addObservations((double[][])tst2, y);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException tst2) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        try {
            tst2 = new double[][]{{1.0, 1.0, 1.0}, {1.2, 2.0, 2.1}};
            y = new double[]{1.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
            instance.addObservations((double[][])tst2, y);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException tst3) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
    }

    @Test
    public void testRegressAirlineConstantExternal() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(4, false);
        double[][] x = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[4];
            x[i][0] = 1.0;
            x[i][1] = FastMath.log((double)airdata[3][i]);
            x[i][2] = FastMath.log((double)airdata[4][i]);
            x[i][3] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        try {
            RegressionResults result = instance.regress();
            Assert.assertNotNull((String)"The test case is a prototype.", (Object)result);
            TestUtils.assertEquals(new double[]{9.5169, 0.8827, 0.454, -1.6275}, result.getParameterEstimates(), 1.0E-4);
            TestUtils.assertEquals(new double[]{0.2292445, 0.0132545, 0.0203042, 0.345302}, result.getStdErrorOfEstimates(), 1.0E-4);
            TestUtils.assertEquals(0.01552839, result.getMeanSquareError(), 1.0E-8);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw exception but does");
        }
    }

    @Test
    public void testRegressAirlineConstantInternal() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        double[][] x = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[3];
            x[i][0] = FastMath.log((double)airdata[3][i]);
            x[i][1] = FastMath.log((double)airdata[4][i]);
            x[i][2] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        try {
            RegressionResults result = instance.regress();
            Assert.assertNotNull((String)"The test case is a prototype.", (Object)result);
            TestUtils.assertEquals(new double[]{9.5169, 0.8827, 0.454, -1.6275}, result.getParameterEstimates(), 1.0E-4);
            TestUtils.assertEquals(new double[]{0.2292445, 0.0132545, 0.0203042, 0.345302}, result.getStdErrorOfEstimates(), 1.0E-4);
            TestUtils.assertEquals(0.9883, result.getRSquared(), 1.0E-4);
            TestUtils.assertEquals(0.01552839, result.getMeanSquareError(), 1.0E-8);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw exception but does");
        }
    }

    @Test
    public void testFilippelli() {
        double[] data = new double[]{0.8116, -6.860120914, 0.9072, -4.324130045, 0.9052, -4.358625055, 0.9039, -4.358426747, 0.8053, -6.955852379, 0.8377, -6.661145254, 0.8667, -6.355462942, 0.8809, -6.118102026, 0.7975, -7.115148017, 0.8162, -6.815308569, 0.8515, -6.519993057, 0.8766, -6.204119983, 0.8885, -5.853871964, 0.8859, -6.109523091, 0.8959, -5.79832982, 0.8913, -5.482672118, 0.8959, -5.171791386, 0.8971, -4.851705903, 0.9021, -4.517126416, 0.909, -4.143573228, 0.9139, -3.709075441, 0.9199, -3.499489089, 0.8692, -6.300769497, 0.8872, -5.953504836, 0.89, -5.642065153, 0.891, -5.031376979, 0.8977, -4.680685696, 0.9035, -4.329846955, 0.9078, -3.928486195, 0.7675, -8.56735134, 0.7705, -8.363211311, 0.7713, -8.107682739, 0.7736, -7.823908741, 0.7775, -7.522878745, 0.7841, -7.218819279, 0.7971, -6.920818754, 0.8329, -6.628932138, 0.8641, -6.323946875, 0.8804, -5.991399828, 0.7668, -8.781464495, 0.7633, -8.663140179, 0.7678, -8.473531488, 0.7697, -8.247337057, 0.77, -7.971428747, 0.7749, -7.676129393, 0.7796, -7.352812702, 0.7897, -7.072065318, 0.8131, -6.774174009, 0.8498, -6.478861916, 0.8741, -6.159517513, 0.8061, -6.835647144, 0.846, -6.53165267, 0.8751, -6.224098421, 0.8856, -5.910094889, 0.8919, -5.598599459, 0.8934, -5.290645224, 0.894, -4.974284616, 0.8957, -4.64454848, 0.9047, -4.290560426, 0.9129, -3.885055584, 0.9209, -3.408378962, 0.9219, -3.13200249, 0.7739, -8.726767166, 0.7681, -8.66695597, 0.7665, -8.511026475, 0.7703, -8.165388579, 0.7702, -7.886056648, 0.7761, -7.588043762, 0.7809, -7.283412422, 0.7961, -6.995678626, 0.8253, -6.691862621, 0.8602, -6.392544977, 0.8809, -6.067374056, 0.8301, -6.684029655, 0.8664, -6.378719832, 0.8834, -6.065855188, 0.8898, -5.752272167, 0.8964, -5.132414673, 0.8963, -4.811352704, 0.9074, -4.098269308, 0.9119, -3.66174277, 0.9228, -3.2644011};
        MillerUpdatingRegression model = new MillerUpdatingRegression(10, true);
        int off = 0;
        double[] tmp = new double[10];
        int nobs = 82;
        for (int i = 0; i < nobs; ++i) {
            tmp[0] = data[off + 1];
            tmp[1] = tmp[0] * tmp[0];
            tmp[2] = tmp[0] * tmp[1];
            tmp[3] = tmp[0] * tmp[2];
            tmp[4] = tmp[0] * tmp[3];
            tmp[5] = tmp[0] * tmp[4];
            tmp[6] = tmp[0] * tmp[5];
            tmp[7] = tmp[0] * tmp[6];
            tmp[8] = tmp[0] * tmp[7];
            tmp[9] = tmp[0] * tmp[8];
            model.addObservation(tmp, data[off]);
            off += 2;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{-1467.4896142298, -2772.17959193342, -2316.37108160893, -1127.97394098372, -354.478233703349, -75.1242017393757, -10.8753180355343, -1.06221498588947, -0.0670191154593408, -0.00246781078275479, -4.02962525080404E-5}, 1.0E-5);
        double[] se = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(se, new double[]{298.084530995537, 559.77986547495, 466.477572127796, 227.204274477751, 71.6478660875927, 15.28971787474, 2.23691159816033, 0.221624321934227, 0.0142363763154724, 5.35617408889821E-4, 8.96632837373868E-6}, 1.0E-5);
        TestUtils.assertEquals(0.99672741618562, result.getRSquared(), 1.0E-8);
        TestUtils.assertEquals(1.1209174396802E-5, result.getMeanSquareError(), 1.0E-10);
        TestUtils.assertEquals(7.95851382172941E-4, result.getErrorSumSquares(), 1.0E-10);
    }

    @Test
    public void testWampler1() {
        double[] data = new double[]{1.0, 0.0, 6.0, 1.0, 63.0, 2.0, 364.0, 3.0, 1365.0, 4.0, 3906.0, 5.0, 9331.0, 6.0, 19608.0, 7.0, 37449.0, 8.0, 66430.0, 9.0, 111111.0, 10.0, 177156.0, 11.0, 271453.0, 12.0, 402234.0, 13.0, 579195.0, 14.0, 813616.0, 15.0, 1118481.0, 16.0, 1508598.0, 17.0, 2000719.0, 18.0, 2613660.0, 19.0, 3368421.0, 20.0};
        MillerUpdatingRegression model = new MillerUpdatingRegression(5, true);
        int off = 0;
        double[] tmp = new double[5];
        int nobs = 21;
        for (int i = 0; i < nobs; ++i) {
            tmp[0] = data[off + 1];
            tmp[1] = tmp[0] * tmp[0];
            tmp[2] = tmp[0] * tmp[1];
            tmp[3] = tmp[0] * tmp[2];
            tmp[4] = tmp[0] * tmp[3];
            model.addObservation(tmp, data[off]);
            off += 2;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 1.0E-8);
        double[] se = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(se, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 1.0E-8);
        TestUtils.assertEquals(1.0, result.getRSquared(), 1.0E-10);
        TestUtils.assertEquals(0.0, result.getMeanSquareError(), 1.0E-7);
        TestUtils.assertEquals(0.0, result.getErrorSumSquares(), 1.0E-6);
    }

    @Test
    public void testWampler2() {
        double[] data = new double[]{1.0, 0.0, 1.11111, 1.0, 1.24992, 2.0, 1.42753, 3.0, 1.65984, 4.0, 1.96875, 5.0, 2.38336, 6.0, 2.94117, 7.0, 3.68928, 8.0, 4.68559, 9.0, 6.0, 10.0, 7.71561, 11.0, 9.92992, 12.0, 12.75603, 13.0, 16.32384, 14.0, 20.78125, 15.0, 26.29536, 16.0, 33.05367, 17.0, 41.26528, 18.0, 51.16209, 19.0, 63.0, 20.0};
        MillerUpdatingRegression model = new MillerUpdatingRegression(5, true);
        int off = 0;
        double[] tmp = new double[5];
        int nobs = 21;
        for (int i = 0; i < nobs; ++i) {
            tmp[0] = data[off + 1];
            tmp[1] = tmp[0] * tmp[0];
            tmp[2] = tmp[0] * tmp[1];
            tmp[3] = tmp[0] * tmp[2];
            tmp[4] = tmp[0] * tmp[3];
            model.addObservation(tmp, data[off]);
            off += 2;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5}, 1.0E-8);
        double[] se = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(se, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 1.0E-8);
        TestUtils.assertEquals(1.0, result.getRSquared(), 1.0E-10);
        TestUtils.assertEquals(0.0, result.getMeanSquareError(), 1.0E-7);
        TestUtils.assertEquals(0.0, result.getErrorSumSquares(), 1.0E-6);
    }

    @Test
    public void testWampler3() {
        double[] data = new double[]{760.0, 0.0, -2042.0, 1.0, 2111.0, 2.0, -1684.0, 3.0, 3888.0, 4.0, 1858.0, 5.0, 11379.0, 6.0, 17560.0, 7.0, 39287.0, 8.0, 64382.0, 9.0, 113159.0, 10.0, 175108.0, 11.0, 273291.0, 12.0, 400186.0, 13.0, 581243.0, 14.0, 811568.0, 15.0, 1121004.0, 16.0, 1506550.0, 17.0, 2002767.0, 18.0, 2611612.0, 19.0, 3369180.0, 20.0};
        MillerUpdatingRegression model = new MillerUpdatingRegression(5, true);
        int off = 0;
        double[] tmp = new double[5];
        int nobs = 21;
        for (int i = 0; i < nobs; ++i) {
            tmp[0] = data[off + 1];
            tmp[1] = tmp[0] * tmp[0];
            tmp[2] = tmp[0] * tmp[1];
            tmp[3] = tmp[0] * tmp[2];
            tmp[4] = tmp[0] * tmp[3];
            model.addObservation(tmp, data[off]);
            off += 2;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 1.0E-8);
        double[] se = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(se, new double[]{2152.3262467817, 2363.55173469681, 779.343524331583, 101.47550755035, 5.64566512170752, 0.112324854679312}, 1.0E-8);
        TestUtils.assertEquals(0.99999555902582, result.getRSquared(), 1.0E-10);
        TestUtils.assertEquals(5570284.53333333, result.getMeanSquareError(), 1.0E-7);
        TestUtils.assertEquals(8.3554268E7, result.getErrorSumSquares(), 1.0E-6);
    }

    public void testWampler4() {
        double[] data = new double[]{75901.0, 0.0, -204794.0, 1.0, 204863.0, 2.0, -204436.0, 3.0, 253665.0, 4.0, -200894.0, 5.0, 214131.0, 6.0, -185192.0, 7.0, 221249.0, 8.0, -138370.0, 9.0, 315911.0, 10.0, -27644.0, 11.0, 455253.0, 12.0, 197434.0, 13.0, 783995.0, 14.0, 608816.0, 15.0, 1370781.0, 16.0, 1303798.0, 17.0, 2205519.0, 18.0, 2408860.0, 19.0, 3444321.0, 20.0};
        MillerUpdatingRegression model = new MillerUpdatingRegression(5, true);
        int off = 0;
        double[] tmp = new double[5];
        int nobs = 21;
        for (int i = 0; i < nobs; ++i) {
            tmp[0] = data[off + 1];
            tmp[1] = tmp[0] * tmp[0];
            tmp[2] = tmp[0] * tmp[1];
            tmp[3] = tmp[0] * tmp[2];
            tmp[4] = tmp[0] * tmp[3];
            model.addObservation(tmp, data[off]);
            off += 2;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 1.0E-8);
        double[] se = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(se, new double[]{215232.62467817, 236355.173469681, 77934.3524331583, 10147.550755035, 564.566512170752, 11.2324854679312}, 1.0E-8);
        TestUtils.assertEquals(0.957478440825662, result.getRSquared(), 1.0E-10);
        TestUtils.assertEquals(5.57028453333333E10, result.getMeanSquareError(), 1.0E-4);
        TestUtils.assertEquals(8.3554268E11, result.getErrorSumSquares(), 0.001);
    }

    @Test
    public void testLongly() {
        double[] design = new double[]{60323.0, 83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0, 61122.0, 88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0, 60171.0, 88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0, 61187.0, 89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0, 63221.0, 96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0, 63639.0, 98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0, 64989.0, 99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0, 63761.0, 100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0, 66019.0, 101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0, 67857.0, 104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0, 68169.0, 108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0, 66513.0, 110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0, 68655.0, 112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0, 69564.0, 114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0, 69331.0, 115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0, 70551.0, 116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0};
        int nobs = 16;
        int nvars = 6;
        MillerUpdatingRegression model = new MillerUpdatingRegression(6, true);
        int off = 0;
        double[] tmp = new double[6];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(design, off + 1, tmp, 0, 6);
            model.addObservation(tmp, design[off]);
            off += 7;
        }
        RegressionResults result = model.regress();
        double[] betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{-3482258.63459582, 15.0618722713733, -0.035819179292591, -2.02022980381683, -1.03322686717359, -0.0511041056535807, 1829.15146461355}, 1.0E-8);
        double[] errors = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(new double[]{890420.383607373, 84.9149257747669, 0.0334910077722432, 0.488399681651699, 0.214274163161675, 0.22607320006937, 455.478499142212}, errors, 1.0E-6);
        TestUtils.assertEquals(0.995479004577296, result.getRSquared(), 1.0E-12);
        TestUtils.assertEquals(0.992465007628826, result.getAdjustedRSquared(), 1.0E-12);
        model = new MillerUpdatingRegression(6, false);
        off = 0;
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(design, off + 1, tmp, 0, 6);
            model.addObservation(tmp, design[off]);
            off += 7;
        }
        result = model.regress();
        betaHat = result.getParameterEstimates();
        TestUtils.assertEquals(betaHat, new double[]{-52.99357013868291, 0.07107319907358, -0.42346585566399, -0.57256866841929, -0.41420358884978, 48.41786562001326}, 1.0E-11);
        errors = result.getStdErrorOfEstimates();
        TestUtils.assertEquals(new double[]{129.54486693117232, 0.03016640003786, 0.41773654056612, 0.27899087467676, 0.32128496193363, 17.68948737819961}, errors, 1.0E-11);
        TestUtils.assertEquals(0.9999670130706, result.getRSquared(), 1.0E-12);
        TestUtils.assertEquals(0.999947220913, result.getAdjustedRSquared(), 1.0E-12);
    }

    @Test
    public void testOneRedundantColumn() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(4, false);
        MillerUpdatingRegression instance2 = new MillerUpdatingRegression(5, false);
        double[][] x = new double[airdata[0].length][];
        double[][] x2 = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[4];
            x2[i] = new double[5];
            x[i][0] = 1.0;
            x[i][1] = FastMath.log((double)airdata[3][i]);
            x[i][2] = FastMath.log((double)airdata[4][i]);
            x[i][3] = airdata[5][i];
            x2[i][0] = x[i][0];
            x2[i][1] = x[i][1];
            x2[i][2] = x[i][2];
            x2[i][3] = x[i][3];
            x2[i][4] = x[i][3];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        RegressionResults result = instance.regress();
        Assert.assertNotNull((String)"Could not estimate initial regression", (Object)result);
        instance2.addObservations((double[][])x2, y);
        RegressionResults resultRedundant = instance2.regress();
        Assert.assertNotNull((String)"Could not estimate redundant regression", (Object)resultRedundant);
        double[] beta = result.getParameterEstimates();
        double[] betar = resultRedundant.getParameterEstimates();
        double[] se = result.getStdErrorOfEstimates();
        double[] ser = resultRedundant.getStdErrorOfEstimates();
        for (int i = 0; i < beta.length; ++i) {
            if (FastMath.abs((double)(beta[i] - betar[i])) > 1.0E-8) {
                Assert.fail((String)"Parameters not correctly estimated");
            }
            if (FastMath.abs((double)(se[i] - ser[i])) > 1.0E-8) {
                Assert.fail((String)"Standard errors not correctly estimated");
            }
            for (int j = 0; j < i; ++j) {
                if (!(FastMath.abs((double)(result.getCovarianceOfParameters(i, j) - resultRedundant.getCovarianceOfParameters(i, j))) > 1.0E-8)) continue;
                Assert.fail((String)"Variance Covariance not correct");
            }
        }
        TestUtils.assertEquals(result.getAdjustedRSquared(), resultRedundant.getAdjustedRSquared(), 1.0E-8);
        TestUtils.assertEquals(result.getErrorSumSquares(), resultRedundant.getErrorSumSquares(), 1.0E-8);
        TestUtils.assertEquals(result.getMeanSquareError(), resultRedundant.getMeanSquareError(), 1.0E-8);
        TestUtils.assertEquals(result.getRSquared(), resultRedundant.getRSquared(), 1.0E-8);
    }

    @Test
    public void testThreeRedundantColumn() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(4, false);
        MillerUpdatingRegression instance2 = new MillerUpdatingRegression(7, false);
        double[][] x = new double[airdata[0].length][];
        double[][] x2 = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[4];
            x2[i] = new double[7];
            x[i][0] = 1.0;
            x[i][1] = FastMath.log((double)airdata[3][i]);
            x[i][2] = FastMath.log((double)airdata[4][i]);
            x[i][3] = airdata[5][i];
            x2[i][0] = x[i][0];
            x2[i][1] = x[i][0];
            x2[i][2] = x[i][1];
            x2[i][3] = x[i][2];
            x2[i][4] = x[i][1];
            x2[i][5] = x[i][3];
            x2[i][6] = x[i][2];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        RegressionResults result = instance.regress();
        Assert.assertNotNull((String)"Could not estimate initial regression", (Object)result);
        instance2.addObservations((double[][])x2, y);
        RegressionResults resultRedundant = instance2.regress();
        Assert.assertNotNull((String)"Could not estimate redundant regression", (Object)resultRedundant);
        double[] beta = result.getParameterEstimates();
        double[] betar = resultRedundant.getParameterEstimates();
        double[] se = result.getStdErrorOfEstimates();
        double[] ser = resultRedundant.getStdErrorOfEstimates();
        if (FastMath.abs((double)(beta[0] - betar[0])) > 1.0E-8) {
            Assert.fail((String)"Parameters not correct after reorder (0,3)");
        }
        if (FastMath.abs((double)(beta[1] - betar[2])) > 1.0E-8) {
            Assert.fail((String)"Parameters not correct after reorder (1,2)");
        }
        if (FastMath.abs((double)(beta[2] - betar[3])) > 1.0E-8) {
            Assert.fail((String)"Parameters not correct after reorder (2,1)");
        }
        if (FastMath.abs((double)(beta[3] - betar[5])) > 1.0E-8) {
            Assert.fail((String)"Parameters not correct after reorder (3,0)");
        }
        if (FastMath.abs((double)(se[0] - ser[0])) > 1.0E-8) {
            Assert.fail((String)"Se not correct after reorder (0,3)");
        }
        if (FastMath.abs((double)(se[1] - ser[2])) > 1.0E-8) {
            Assert.fail((String)"Se not correct after reorder (1,2)");
        }
        if (FastMath.abs((double)(se[2] - ser[3])) > 1.0E-8) {
            Assert.fail((String)"Se not correct after reorder (2,1)");
        }
        if (FastMath.abs((double)(se[3] - ser[5])) > 1.0E-8) {
            Assert.fail((String)"Se not correct after reorder (3,0)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(0, 0) - resultRedundant.getCovarianceOfParameters(0, 0))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct after reorder (0,0)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(0, 1) - resultRedundant.getCovarianceOfParameters(0, 2))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct after reorder (0,1)<->(0,2)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(0, 2) - resultRedundant.getCovarianceOfParameters(0, 3))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct after reorder (0,2)<->(0,1)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(0, 3) - resultRedundant.getCovarianceOfParameters(0, 5))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct after reorder (0,3)<->(0,3)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(1, 0) - resultRedundant.getCovarianceOfParameters(2, 0))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct after reorder (1,0)<->(2,0)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(1, 1) - resultRedundant.getCovarianceOfParameters(2, 2))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct  (1,1)<->(2,1)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(1, 2) - resultRedundant.getCovarianceOfParameters(2, 3))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct  (1,2)<->(2,2)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(2, 0) - resultRedundant.getCovarianceOfParameters(3, 0))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct  (2,0)<->(1,0)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(2, 1) - resultRedundant.getCovarianceOfParameters(3, 2))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct  (2,1)<->(1,2)");
        }
        if (FastMath.abs((double)(result.getCovarianceOfParameters(3, 3) - resultRedundant.getCovarianceOfParameters(5, 5))) > 1.0E-8) {
            Assert.fail((String)"VCV not correct  (3,3)<->(3,2)");
        }
        TestUtils.assertEquals(result.getAdjustedRSquared(), resultRedundant.getAdjustedRSquared(), 1.0E-8);
        TestUtils.assertEquals(result.getErrorSumSquares(), resultRedundant.getErrorSumSquares(), 1.0E-8);
        TestUtils.assertEquals(result.getMeanSquareError(), resultRedundant.getMeanSquareError(), 1.0E-8);
        TestUtils.assertEquals(result.getRSquared(), resultRedundant.getRSquared(), 1.0E-8);
    }

    @Test
    public void testPCorr() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(4, false);
        double[][] x = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        double[] cp = new double[10];
        double[] yxcorr = new double[4];
        double[] diag = new double[4];
        double sumysq = 0.0;
        int off = 0;
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[4];
            x[i][0] = 1.0;
            x[i][1] = FastMath.log((double)airdata[3][i]);
            x[i][2] = FastMath.log((double)airdata[4][i]);
            x[i][3] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
            off = 0;
            int j = 0;
            while (j < 4) {
                double tmp = x[i][j];
                for (int k = 0; k <= j; ++k) {
                    int n = off++;
                    cp[n] = cp[n] + tmp * x[i][k];
                }
                int n = j++;
                yxcorr[n] = yxcorr[n] + tmp * y[i];
            }
            sumysq += y[i] * y[i];
        }
        PearsonsCorrelation pearson = new PearsonsCorrelation((double[][])x);
        RealMatrix corr = pearson.getCorrelationMatrix();
        off = 0;
        int i = 0;
        while (i < 4) {
            diag[i] = FastMath.sqrt((double)cp[off]);
            off += ++i + 1;
        }
        instance.addObservations((double[][])x, y);
        double[] pc = instance.getPartialCorrelations(0);
        int idx = 0;
        off = 0;
        int off2 = 6;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < i2; ++j) {
                if (FastMath.abs((double)(pc[idx] - cp[off] / (diag[i2] * diag[j]))) > 1.0E-8) {
                    Assert.fail((String)("Failed cross products... i = " + i2 + " j = " + j));
                }
                ++idx;
                ++off;
            }
            ++off;
            if (!(FastMath.abs((double)(pc[i2 + off2] - yxcorr[i2] / (FastMath.sqrt((double)sumysq) * diag[i2]))) > 1.0E-8)) continue;
            Assert.fail((String)("Assert.failed cross product i = " + i2 + " y"));
        }
        double[] pc2 = instance.getPartialCorrelations(1);
        idx = 0;
        for (int i3 = 1; i3 < 4; ++i3) {
            for (int j = 1; j < i3; ++j) {
                if (FastMath.abs((double)(pc2[idx] - corr.getEntry(j, i3))) > 1.0E-8) {
                    Assert.fail((String)("Failed cross products... i = " + i3 + " j = " + j));
                }
                ++idx;
            }
        }
        double[] pc3 = instance.getPartialCorrelations(2);
        if (pc3 == null) {
            Assert.fail((String)"Should not be null");
        }
    }

    @Test
    public void testHdiag() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(4, false);
        double[][] x = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[4];
            x[i][0] = 1.0;
            x[i][1] = FastMath.log((double)airdata[3][i]);
            x[i][2] = FastMath.log((double)airdata[4][i]);
            x[i][3] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        ols.setNoIntercept(true);
        ols.newSampleData(y, (double[][])x);
        RealMatrix rm = ols.calculateHat();
        for (int i = 0; i < x.length; ++i) {
            TestUtils.assertEquals(instance.getDiagonalOfHatMatrix(x[i]), rm.getEntry(i, i), 1.0E-8);
        }
    }

    @Test
    public void testHdiagConstant() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        double[][] x = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[3];
            x[i][0] = FastMath.log((double)airdata[3][i]);
            x[i][1] = FastMath.log((double)airdata[4][i]);
            x[i][2] = airdata[5][i];
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        ols.setNoIntercept(false);
        ols.newSampleData(y, (double[][])x);
        RealMatrix rm = ols.calculateHat();
        for (int i = 0; i < x.length; ++i) {
            TestUtils.assertEquals(instance.getDiagonalOfHatMatrix(x[i]), rm.getEntry(i, i), 1.0E-8);
        }
    }

    @Test
    public void testSubsetRegression() {
        MillerUpdatingRegression instance = new MillerUpdatingRegression(3, true);
        MillerUpdatingRegression redRegression = new MillerUpdatingRegression(2, true);
        double[][] x = new double[airdata[0].length][];
        double[][] xReduced = new double[airdata[0].length][];
        double[] y = new double[airdata[0].length];
        for (int i = 0; i < airdata[0].length; ++i) {
            x[i] = new double[3];
            x[i][0] = FastMath.log((double)airdata[3][i]);
            x[i][1] = FastMath.log((double)airdata[4][i]);
            x[i][2] = airdata[5][i];
            xReduced[i] = new double[2];
            xReduced[i][0] = FastMath.log((double)airdata[3][i]);
            xReduced[i][1] = FastMath.log((double)airdata[4][i]);
            y[i] = FastMath.log((double)airdata[2][i]);
        }
        instance.addObservations((double[][])x, y);
        redRegression.addObservations((double[][])xReduced, y);
        RegressionResults resultsInstance = instance.regress(new int[]{0, 1, 2});
        RegressionResults resultsReduced = redRegression.regress();
        TestUtils.assertEquals(resultsInstance.getParameterEstimates(), resultsReduced.getParameterEstimates(), 1.0E-12);
        TestUtils.assertEquals(resultsInstance.getStdErrorOfEstimates(), resultsReduced.getStdErrorOfEstimates(), 1.0E-12);
    }
}

