/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.azure.parquet;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.input.HDFSDataSourceFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.azure.blob_storage.AzureUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class AzureBlobParquetReaderFactory
extends HDFSDataSourceFactory {
    private static final long serialVersionUID = -6140824803254158253L;
    private static final List<String> recordReaderNames = Collections.singletonList("AZUREBLOB");

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException, HyracksDataException {
        IApplicationContext appCtx = (IApplicationContext)serviceCtx.getApplicationContext();
        BlobServiceClient blobServiceClient = AzureUtils.buildAzureBlobClient(appCtx, configuration);
        String endPoint = AzureBlobParquetReaderFactory.extractEndPoint(blobServiceClient.getAccountUrl());
        String path = AzureBlobParquetReaderFactory.buildPathURIs(configuration, warningCollector, blobServiceClient, endPoint);
        AzureBlobParquetReaderFactory.putAzureBlobConfToHadoopConf(configuration, path);
        JobConf conf = this.createHdfsConf(serviceCtx, configuration);
        AzureUtils.configureAzureHdfsJobConf(conf, configuration, endPoint);
        this.configureHdfsConf(conf, configuration);
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public Set<String> getReaderSupportedFormats() {
        return Collections.singleton("parquet");
    }

    private static void putAzureBlobConfToHadoopConf(Map<String, String> configuration, String path) {
        configuration.put("path", path);
        configuration.put("input-format", "parquet-input-format");
        configuration.put("parser", "noop");
    }

    private static String buildPathURIs(Map<String, String> configuration, IWarningCollector warningCollector, BlobServiceClient blobServiceClient, String endPoint) throws CompilationException {
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        List<BlobItem> filesOnly = AzureUtils.listBlobItems(blobServiceClient, configuration, includeExcludeMatcher, warningCollector);
        StringBuilder builder = new StringBuilder();
        String container = configuration.get("container");
        if (!filesOnly.isEmpty()) {
            AzureBlobParquetReaderFactory.appendFileURI(builder, container, endPoint, filesOnly.get(0));
            for (int i = 1; i < filesOnly.size(); ++i) {
                builder.append(',');
                AzureBlobParquetReaderFactory.appendFileURI(builder, container, endPoint, filesOnly.get(i));
            }
        }
        return builder.toString();
    }

    private static String extractEndPoint(String uri) {
        return uri.substring(uri.indexOf("//") + "//".length());
    }

    private static void appendFileURI(StringBuilder builder, String container, String endPoint, BlobItem file) {
        builder.append("wasbs");
        builder.append("://");
        builder.append(container);
        builder.append('@');
        builder.append(endPoint);
        builder.append('/');
        builder.append(file.getName());
    }
}

