/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils.memory;

import java.util.Comparator;
import org.apache.hyracks.dataflow.std.structures.IResetable;

public final class RunFilePointer
implements IResetable<RunFilePointer> {
    public static final int INVALID_ID = -1;
    private long fileOffset;
    private int tupleIndex;
    public static final Comparator<RunFilePointer> ASC = (tp1, tp2) -> {
        int c = (int)(tp1.getFileOffset() - tp2.getFileOffset());
        if (c == 0) {
            c = tp1.getTupleIndex() - tp2.getTupleIndex();
        }
        return c;
    };
    public static final Comparator<RunFilePointer> DESC = (tp1, tp2) -> {
        int c = (int)(tp2.getFileOffset() - tp1.getFileOffset());
        if (c == 0) {
            c = tp2.getTupleIndex() - tp1.getTupleIndex();
        }
        return c;
    };

    public RunFilePointer() {
        this(-1L, -1);
    }

    public RunFilePointer(long fileOffset, int tupleId) {
        this.reset(fileOffset, tupleId);
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public void reset(RunFilePointer other) {
        this.reset(other.fileOffset, other.tupleIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunFilePointer that = (RunFilePointer)o;
        return this.fileOffset == that.fileOffset && this.tupleIndex == that.tupleIndex;
    }

    public int hashCode() {
        int result = (int)this.fileOffset;
        result = 31 * result + this.tupleIndex;
        return result;
    }

    public void reset(long fileOffset, int tupleId) {
        this.fileOffset = fileOffset;
        this.tupleIndex = tupleId;
    }

    public String toString() {
        return "RunFilePointer(" + this.fileOffset + ", " + this.tupleIndex + ")";
    }
}

