/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ToArrayDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ToArrayDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_EXPRESSION_TYPE;
        }
    };
    private static final long serialVersionUID = 1L;
    private AOrderedListType oltype;

    public void setImmutableStates(Object ... states) {
        this.oltype = TypeComputeUtils.extractOrderedListType((IAType)((IAType)states[0]));
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IScalarEvaluator eval0;
                    private final IPointable arg0;
                    private final OrderedListBuilder listBuilder;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput out;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.arg0 = new VoidPointable();
                        this.listBuilder = new OrderedListBuilder();
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        int offset;
                        this.eval0.evaluate(tuple, this.arg0);
                        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.arg0)) {
                            return;
                        }
                        byte[] data = this.arg0.getByteArray();
                        if (data[offset = this.arg0.getStartOffset()] == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                            resultPointable.set((IValueReference)this.arg0);
                        } else if (data[offset] == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                            try {
                                this.resultStorage.reset();
                                this.out.writeByte(ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
                                this.out.write(data, offset + 1, this.arg0.getLength() - 1);
                                resultPointable.set((IValueReference)this.resultStorage);
                            }
                            catch (IOException e) {
                                throw HyracksDataException.create((Throwable)e);
                            }
                        } else {
                            this.resultStorage.reset();
                            this.listBuilder.reset((AbstractCollectionType)ToArrayDescriptor.this.oltype);
                            this.listBuilder.addItem((IValueReference)this.arg0);
                            this.listBuilder.write(this.out, true);
                            resultPointable.set((IValueReference)this.resultStorage);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.TO_ARRAY;
    }
}

