/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import org.apache.asterix.optimizer.rules.util.IntervalJoinUtils;
import org.apache.asterix.optimizer.rules.util.SpatialJoinUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;

public class AsterixJoinUtils {
    private AsterixJoinUtils() {
    }

    public static void setJoinAlgorithmAndExchangeAlgo(AbstractBinaryJoinOperator op, Boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        if (!topLevelOp.booleanValue()) {
            return;
        }
        ILogicalExpression joinCondition = (ILogicalExpression)op.getCondition().getValue();
        if (joinCondition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return;
        }
        boolean intervalJoinChosen = IntervalJoinUtils.tryIntervalJoinAssignment(op, context, joinCondition, 0, 1);
        if (!intervalJoinChosen) {
            SpatialJoinUtils.trySpatialJoinAssignment(op, context, joinCondition, 0, 1);
        }
    }
}

