/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.linearize;

import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.rtree.impls.DoublePrimitiveValueProviderFactory;
import org.apache.hyracks.storage.common.arraylist.DoubleArrayList;

public class ZCurveDoubleComparator
implements ILinearizeComparator {
    private final int dim;
    private double[] bounds;
    private double stepsize;
    private DoubleArrayList boundsStack = new DoubleArrayList(2000, 400);
    private IPrimitiveValueProvider valueProvider = DoublePrimitiveValueProviderFactory.INSTANCE.createPrimitiveValueProvider();
    private double[] a;
    private double[] b;

    public ZCurveDoubleComparator(int dimension) {
        this.dim = dimension;
        this.a = new double[this.dim];
        this.b = new double[this.dim];
        this.resetStateMachine();
    }

    private void resetStateMachine() {
        this.stepsize = 8.988465674311579E307;
        this.bounds = new double[this.dim];
        this.boundsStack.clear();
    }

    public int compare() {
        int quadrantB;
        int quadrantA;
        block15: {
            int j;
            boolean zoomOut;
            boolean equal = true;
            for (int i = 0; i < this.dim; ++i) {
                if (this.a[i] == this.b[i]) continue;
                equal = false;
            }
            if (equal) {
                return 0;
            }
            do {
                if (this.boundsStack.size() <= this.dim) {
                    this.resetStateMachine();
                    break block15;
                }
                zoomOut = false;
                for (int i = 0; i < this.dim; ++i) {
                    if (!(Math.min(this.a[i], this.b[i]) <= this.bounds[i] - 2.0 * this.stepsize) && !(Math.max(this.a[i], this.b[i]) >= this.bounds[i] + 2.0 * this.stepsize)) continue;
                    zoomOut = true;
                    break;
                }
                for (j = this.dim - 1; j >= 0; --j) {
                    this.bounds[j] = this.boundsStack.getLast();
                    this.boundsStack.removeLast();
                }
                this.stepsize *= 2.0;
            } while (zoomOut);
            for (j = this.dim - 1; j >= 0; --j) {
                this.bounds[j] = this.boundsStack.getLast();
                this.boundsStack.removeLast();
            }
            this.stepsize *= 2.0;
        }
        do {
            for (int j = 0; j < this.dim; ++j) {
                this.boundsStack.add(this.bounds[j]);
            }
            quadrantA = 0;
            quadrantB = 0;
            for (int i = this.dim - 1; i >= 0; --i) {
                if (this.a[i] >= this.bounds[i]) {
                    quadrantA ^= 1 << this.dim - i - 1;
                }
                if (this.b[i] >= this.bounds[i]) {
                    quadrantB ^= 1 << this.dim - i - 1;
                }
                if (this.a[i] >= this.bounds[i]) {
                    int n = i;
                    this.bounds[n] = this.bounds[n] + this.stepsize;
                    continue;
                }
                int n = i;
                this.bounds[n] = this.bounds[n] - this.stepsize;
            }
            this.stepsize /= 2.0;
            if (!(this.stepsize <= 2.0 * DoublePointable.getEpsilon())) continue;
            return 0;
        } while (quadrantA == quadrantB);
        if (quadrantA < quadrantB) {
            return -1;
        }
        if (quadrantA > quadrantB) {
            return 1;
        }
        return 0;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        for (int i = 0; i < this.dim; ++i) {
            this.a[i] = DoublePointable.getDouble((byte[])b1, (int)(s1 + i * l1));
            this.b[i] = DoublePointable.getDouble((byte[])b2, (int)(s2 + i * l2));
        }
        return this.compare();
    }

    public int getDimensions() {
        return this.dim;
    }
}

